/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.capabilities;

import com.peeko32213.unusualprehistory.common.capabilities.UPCapabilities;
import com.peeko32213.unusualprehistory.common.capabilities.UPPlayerCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class UPAttacherPlayerCapability {
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof ServerPlayer) {
            UPCapabilityProvider provider = new UPCapabilityProvider();
            event.addCapability(UPCapabilityProvider.IDENTIFIER, (ICapabilityProvider)provider);
        }
    }

    private static class UPCapabilityProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation IDENTIFIER = new ResourceLocation("unusualprehistory", "player_capability");
        private final UPPlayerCapability backend = new UPPlayerCapability();
        private final LazyOptional<UPPlayerCapability> optionalData = LazyOptional.of(() -> this.backend);

        private UPCapabilityProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return UPCapabilities.PLAYER_CAPABILITY.orEmpty(cap, this.optionalData);
        }

        public CompoundTag serializeNBT() {
            return this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT(nbt);
        }
    }
}

