/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.block.entity;

import com.peeko32213.unusualprehistory.common.block.BlockCultivator;
import com.peeko32213.unusualprehistory.common.message.SyncItemStackC2SPacket;
import com.peeko32213.unusualprehistory.common.recipe.CultivatorRecipe;
import com.peeko32213.unusualprehistory.common.screen.CultivatorMenu;
import com.peeko32213.unusualprehistory.core.registry.UPBlockEntities;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPMessages;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CultivatorBlockEntity
extends BlockEntity
implements MenuProvider {
    private BlockState blockstate;
    public int ticksExisted;
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            CultivatorBlockEntity.this.m_6596_();
            if (!((CultivatorBlockEntity)CultivatorBlockEntity.this).f_58857_.f_46443_) {
                UPMessages.sendToClients(new SyncItemStackC2SPacket(this, CultivatorBlockEntity.this.f_58858_));
            }
        }
    };
    private IItemHandler hopperHandler = new IItemHandler(){

        public int getSlots() {
            return CultivatorBlockEntity.this.itemHandler.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return CultivatorBlockEntity.this.itemHandler.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (CultivatorBlockEntity.this.blockstate.m_61143_(BlockCultivator.HALF) == DoubleBlockHalf.UPPER) {
                return CultivatorBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
            }
            if (slot == 2 || slot == 3) {
                return CultivatorBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return stack;
            }
            if (slot == 0 && stack.m_204117_(UPTags.DNA_FLASKS)) {
                return CultivatorBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
            }
            if (slot == 1 && stack.m_150930_((Item)UPItems.ORGANIC_OOZE.get())) {
                return CultivatorBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public int getSlotLimit(int slot) {
            return CultivatorBlockEntity.this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return CultivatorBlockEntity.this.itemHandler.isItemValid(slot, stack);
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
    private LazyOptional<IItemHandler> hopperHandlerOptional = LazyOptional.of(() -> this.hopperHandler);
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 1152;
    private int fuel = 0;
    private int maxFuel = 790;
    public int tickCount = 0;

    public CultivatorBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)UPBlockEntities.CULTIVATOR_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
        this.blockstate = pBlockState;
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> CultivatorBlockEntity.this.progress;
                    case 1 -> CultivatorBlockEntity.this.maxProgress;
                    case 2 -> CultivatorBlockEntity.this.fuel;
                    case 3 -> CultivatorBlockEntity.this.maxFuel;
                    case 4 -> CultivatorBlockEntity.this.tickCount;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        CultivatorBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        CultivatorBlockEntity.this.maxProgress = value;
                        break;
                    }
                    case 2: {
                        CultivatorBlockEntity.this.fuel = value;
                        break;
                    }
                    case 3: {
                        CultivatorBlockEntity.this.maxFuel = value;
                        break;
                    }
                    case 4: {
                        CultivatorBlockEntity.this.tickCount = value;
                    }
                }
            }

            public int m_6499_() {
                return 5;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"unusualprehistory.blockentity.cultivator");
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandlerOptional.cast();
            }
            return this.hopperHandlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
        this.hopperHandlerOptional = LazyOptional.of(() -> this.hopperHandler);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            UPMessages.sendToClients(new SyncItemStackC2SPacket(this.itemHandler, this.f_58858_));
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandlerOptional.invalidate();
        this.hopperHandlerOptional.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("analyzer.progress", this.progress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("analyzer.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void spawnParticles(LevelAccessor levelAccessor, BlockPos pos, RandomSource random, double speedXZModifier, double speedYModifier) {
        Level level = (Level)levelAccessor;
        level.m_6485_((ParticleOptions)ParticleTypes.f_123772_, true, (double)pos.m_123341_() + 0.2 + random.m_188500_() * 0.4, (double)pos.m_123342_() + 0.5 + random.m_188500_(), (double)pos.m_123343_() + 0.2 + random.m_188500_() * 0.6, speedXZModifier, speedYModifier, speedXZModifier);
    }

    public ItemStack getRenderStack() {
        ItemStack stack = !this.itemHandler.getStackInSlot(2).m_41619_() ? this.itemHandler.getStackInSlot(2) : this.itemHandler.getStackInSlot(0);
        return stack;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, CultivatorBlockEntity pBlockEntity) {
        ++pBlockEntity.tickCount;
        if (CultivatorBlockEntity.hasRecipe(pBlockEntity)) {
            CultivatorBlockEntity.spawnParticles((LevelAccessor)pLevel, pPos, pLevel.f_46441_, 0.0, 0.02);
            ++pBlockEntity.progress;
            pBlockEntity.depleteFuel();
            CultivatorBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                CultivatorBlockEntity.craftItem(pBlockEntity);
            }
        } else {
            pBlockEntity.resetProgress();
            if (!pBlockEntity.hasFuel()) {
                pBlockEntity.refuel();
            }
            CultivatorBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private static boolean hasRecipe(CultivatorBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional match = level.m_7465_().m_44015_((RecipeType)CultivatorRecipe.Type.INSTANCE, (Container)inventory, level);
        return match.isPresent() && CultivatorBlockEntity.canInsertAmountIntoOutputSlot(inventory) && CultivatorBlockEntity.canInsertItemIntoOutputSlot(inventory, ((CultivatorRecipe)match.get()).assemble(inventory, level.m_9598_())) && CultivatorBlockEntity.canDiscardFlask(inventory, new ItemStack((ItemLike)UPItems.FLASK.get())) && entity.hasFuel();
    }

    private static void craftItem(CultivatorBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional match = level.m_7465_().m_44015_((RecipeType)CultivatorRecipe.Type.INSTANCE, (Container)inventory, level);
        if (match.isPresent()) {
            entity.itemHandler.extractItem(0, 1, false);
            entity.itemHandler.insertItem(2, ((CultivatorRecipe)match.get()).assemble(inventory, level.m_9598_()), false);
            entity.itemHandler.insertItem(3, new ItemStack((ItemLike)UPItems.FLASK.get()), false);
            entity.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void depleteFuel() {
        --this.fuel;
        if (this.fuel <= 0) {
            this.fuel = 0;
            this.refuel();
        }
    }

    private void refuel() {
        ItemStack fuelStack = this.itemHandler.getStackInSlot(1);
        int fuelAmount = this.getFuelAmount(fuelStack);
        if (fuelAmount > 0) {
            this.itemHandler.extractItem(1, 1, false);
            this.fuel = fuelAmount;
        }
    }

    private boolean hasFuel() {
        return this.fuel > 0;
    }

    private int getFuelAmount(ItemStack fuelStack) {
        if (!fuelStack.m_41619_() && fuelStack.m_204117_(UPTags.ORGANIC_OOZE)) {
            return this.maxFuel;
        }
        return 0;
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack output) {
        return inventory.m_8020_(2).m_41720_() == output.m_41720_() || inventory.m_8020_(2).m_41619_();
    }

    private static boolean canDiscardFlask(SimpleContainer inventory, ItemStack output) {
        return inventory.m_8020_(3).m_41720_() == output.m_41720_() || inventory.m_8020_(3).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.m_8020_(2).m_41741_() > inventory.m_8020_(2).m_41613_() && inventory.m_8020_(3).m_41741_() > inventory.m_8020_(3).m_41613_();
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new CultivatorMenu(pContainerId, pInventory, this, this.data);
    }
}

