/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.block;

import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPParticles;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockTar
extends Block
implements BucketPickup {
    private static final float HORIZONTAL_PARTICLE_MOMENTUM_FACTOR = 0.083333336f;
    private static final float IN_BLOCK_HORIZONTAL_SPEED_MULTIPLIER = 0.9f;
    private static final float IN_BLOCK_VERTICAL_SPEED_MULTIPLIER = 1.5f;
    private static final float NUM_BLOCKS_TO_FALL_INTO_BLOCK = 2.5f;
    private static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);
    private static final double MINIMUM_FALL_DISTANCE_FOR_SOUND = 4.0;
    private static final double MINIMUM_FALL_DISTANCE_FOR_BIG_SOUND = 7.0;

    public BlockTar(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        return pAdjacentBlockState.m_60713_((Block)this) ? true : super.m_6104_(pState, pAdjacentBlockState, pDirection);
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!(pEntity instanceof LivingEntity) || pEntity.m_146900_().m_60713_((Block)this)) {
            if (!pEntity.m_6095_().m_204039_(UPTags.TAR_WALKABLE_THROUGH_MOBS)) {
                pEntity.m_7601_(pState, new Vec3((double)0.2f, 1.5, (double)0.2f));
            }
            if (pLevel.f_46443_) {
                boolean flag;
                RandomSource randomsource = pLevel.m_213780_();
                boolean bl = flag = pEntity.f_19790_ != pEntity.m_20185_() || pEntity.f_19792_ != pEntity.m_20189_();
                if (flag && randomsource.m_188499_()) {
                    pLevel.m_7106_((ParticleOptions)UPParticles.TAR_BUBBLE.get(), pEntity.m_20185_(), (double)(pPos.m_123342_() + 1), pEntity.m_20189_(), (double)(Mth.m_216283_((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.m_216283_((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f));
                }
            }
        }
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        if (!((double)pFallDistance < 4.0) && pEntity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)pEntity;
            LivingEntity.Fallsounds $$7 = livingentity.m_196493_();
            SoundEvent soundevent = (double)pFallDistance < 7.0 ? $$7.f_196626_() : $$7.f_196627_();
            pEntity.m_5496_(soundevent, 1.0f, 1.0f);
        }
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        EntityCollisionContext entitycollisioncontext;
        Entity entity;
        if (pContext instanceof EntityCollisionContext && (entity = (entitycollisioncontext = (EntityCollisionContext)pContext).m_193113_()) != null) {
            if (entity.f_19789_ > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            boolean flag = entity instanceof FallingBlockEntity;
            if (flag || BlockTar.canEntityWalkOnTar(entity) && pContext.m_6513_(Shapes.m_83144_(), pPos, false) && !pContext.m_6226_()) {
                return super.m_5939_(pState, pLevel, pPos, pContext);
            }
        }
        return Shapes.m_83040_();
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83040_();
    }

    public static boolean canEntityWalkOnTar(Entity pEntity) {
        if (pEntity.m_6095_().m_204039_(UPTags.TAR_WALKABLE_ON_MOBS)) {
            return true;
        }
        return pEntity instanceof LivingEntity ? ((LivingEntity)pEntity).m_6844_(EquipmentSlot.FEET).canWalkOnPowderedSnow((LivingEntity)pEntity) : false;
    }

    public ItemStack m_142598_(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 11);
        if (!pLevel.m_5776_()) {
            pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
        }
        return new ItemStack((ItemLike)UPItems.TAR_BUCKET.get());
    }

    public Optional<SoundEvent> m_142298_() {
        return Optional.of(SoundEvents.f_11783_);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return true;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos blockpos = pPos.m_7494_();
        if (pLevel.m_8055_(blockpos).m_60795_() && !pLevel.m_8055_(blockpos).m_60804_((BlockGetter)pLevel, blockpos)) {
            if (pRandom.m_188503_(100) == 0) {
                double d0 = (double)pPos.m_123341_() + pRandom.m_188500_();
                double d1 = (double)pPos.m_123342_() + 1.0;
                double d2 = (double)pPos.m_123343_() + pRandom.m_188500_();
                pLevel.m_7106_((ParticleOptions)UPParticles.TAR_BUBBLE.get(), d0, d1, d2, 0.0, 0.0, 0.0);
                pLevel.m_7785_(d0, d1, d2, (SoundEvent)UPSounds.TAR_POP.get(), SoundSource.BLOCKS, 0.2f + pRandom.m_188501_() * 0.2f, 0.9f + pRandom.m_188501_() * 0.15f, false);
            }
            if (pRandom.m_188503_(200) == 0) {
                pLevel.m_7785_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)UPSounds.TAR_AMBIENT.get(), SoundSource.BLOCKS, 0.2f + pRandom.m_188501_() * 0.2f, 0.9f + pRandom.m_188501_() * 0.15f, false);
            }
        }
    }
}

