/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory;

import com.peeko32213.unusualprehistory.ClientProxy;
import com.peeko32213.unusualprehistory.CommonProxy;
import com.peeko32213.unusualprehistory.client.event.ClientEvents;
import com.peeko32213.unusualprehistory.common.capabilities.UPAnimalCapability;
import com.peeko32213.unusualprehistory.common.capabilities.UPCapabilities;
import com.peeko32213.unusualprehistory.common.capabilities.UPPlayerCapability;
import com.peeko32213.unusualprehistory.common.config.UnusualPrehistoryConfig;
import com.peeko32213.unusualprehistory.core.events.ServerEvents;
import com.peeko32213.unusualprehistory.core.registry.UPAdvancementTriggerRegistry;
import com.peeko32213.unusualprehistory.core.registry.UPBlockEntities;
import com.peeko32213.unusualprehistory.core.registry.UPBlocks;
import com.peeko32213.unusualprehistory.core.registry.UPEffects;
import com.peeko32213.unusualprehistory.core.registry.UPEntities;
import com.peeko32213.unusualprehistory.core.registry.UPEntityPlacement;
import com.peeko32213.unusualprehistory.core.registry.UPFeatureModifiers;
import com.peeko32213.unusualprehistory.core.registry.UPFeatures;
import com.peeko32213.unusualprehistory.core.registry.UPInstruments;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPLootModifiers;
import com.peeko32213.unusualprehistory.core.registry.UPMenuTypes;
import com.peeko32213.unusualprehistory.core.registry.UPMessages;
import com.peeko32213.unusualprehistory.core.registry.UPParticles;
import com.peeko32213.unusualprehistory.core.registry.UPRecipes;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTabs;
import com.peeko32213.unusualprehistory.core.registry.UPTrunkPlacerType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="unusualprehistory")
public class UnusualPrehistory {
    public static final String MODID = "unusualprehistory";
    private static int packetsRegistered;
    public static final List<Runnable> CALLBACKS;
    public static final Logger LOGGER;
    public static CommonProxy PROXY;

    public UnusualPrehistory() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(ClientEvents::init));
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::setupClient);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)UnusualPrehistoryConfig.CONFIG_BUILDER);
        UPItems.ITEMS.register(modEventBus);
        UPBlocks.BLOCKS.register(modEventBus);
        UPTabs.TABS.register(modEventBus);
        UPFeatures.FEATURES.register(modEventBus);
        UPParticles.PARTICLE_TYPES.register(modEventBus);
        UPAdvancementTriggerRegistry.init();
        UPTrunkPlacerType.TRUNK_PLACER_TYPES.register(modEventBus);
        UPInstruments.INSTRUMENT.register(modEventBus);
        UPBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        UPMenuTypes.MENUS.register(modEventBus);
        UPRecipes.SERIALIZERS.register(modEventBus);
        UPEntities.ENTITIES.register(modEventBus);
        UPLootModifiers.LOOT_MODIFIERS.register(modEventBus);
        UPFeatureModifiers.FOLIAGE_PLACERS.register(modEventBus);
        UPFeatureModifiers.PLACEMENT_MODIFIERS.register(modEventBus);
        UPSounds.DEF_REG.register(modEventBus);
        UPEffects.EFFECT_DEF_REG.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvents());
        PROXY.init();
        UPCapabilities.setupCapabilities();
        eventBus.addListener(UPPlayerCapability::onPlayerCloned);
        eventBus.addListener(UPPlayerCapability::onLivingDamage);
        eventBus.addListener(UPPlayerCapability::onPlayerJoinWorld);
        eventBus.addListener(UPAnimalCapability::tickAnimal);
        eventBus.addListener(UPAnimalCapability::tickWaterAnimal);
    }

    public static void checkForGeckoLib() {
        if (!ModList.get().isLoaded("geckolib")) {
            try {
                LOGGER.debug("Geckolib3 version 3.1.39 and up didn't seem to be loaded!");
                throw new Exception("Something went wrong setting up compat");
            }
            catch (Exception e) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)e, (String)"Geckolib3 version 3.1.39 and up didn't seem to be loaded!");
                crashreport.m_127514_("Mod not loaded");
                throw new ReportedException(crashreport);
            }
        }
        LOGGER.debug("Geckolib loaded correctly!");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            UPEntityPlacement.entityPlacement();
            UnusualPrehistory.addToFlowerPot(UPBlocks.HORSETAIL.getId(), UPBlocks.POTTED_HORSETAIL);
            UnusualPrehistory.addToFlowerPot(UPBlocks.LEEFRUCTUS.getId(), UPBlocks.POTTED_LEEFRUCTUS);
            UnusualPrehistory.addToFlowerPot(UPBlocks.BENNETTITALES.getId(), UPBlocks.POTTED_BENNETTITALES);
            UnusualPrehistory.addToFlowerPot(UPBlocks.ARCHAEOSIGILARIA.getId(), UPBlocks.POTTED_ARCHAEOSIGILARIA);
            UnusualPrehistory.addToFlowerPot(UPBlocks.PETRIFIED_BUSH.getId(), UPBlocks.POTTED_PETRIFIED_BUSH);
            UnusualPrehistory.addToFlowerPot(UPBlocks.SARACENIA.getId(), UPBlocks.POTTED_SARACENIA);
            UnusualPrehistory.addToFlowerPot(UPBlocks.GINKGO_SAPLING.getId(), UPBlocks.POTTED_GINKGO_SAPLING);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.HORSETAIL.get()).m_5456_(), 0.4f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.TALL_HORSETAIL.get()).m_5456_(), 0.8f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.LEEFRUCTUS.get()).m_5456_(), 0.4f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.BENNETTITALES.get()).m_5456_(), 0.4f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.ARCHAEOSIGILARIA.get()).m_5456_(), 0.4f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.SARACENIA.get()).m_5456_(), 0.4f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.TALL_SARACENIA.get()).m_5456_(), 0.8f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.RAIGUENRAYUN.get()).m_5456_(), 0.8f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.GINKGO_LEAVES.get()).m_5456_(), 0.4f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.FOXXI_LEAVES.get()).m_5456_(), 0.4f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.GINKGO_SAPLING.get()).m_5456_(), 0.4f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.ARCHAEFRUCTUS.get()).m_5456_(), 0.4f);
            UnusualPrehistory.addToComposter((ItemLike)UPBlocks.NELUMBITES.get().m_5456_(), 0.4f);
            UnusualPrehistory.addToComposter((ItemLike)UPBlocks.NELUMBITES.get().m_5456_(), 0.4f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.QUEREUXIA.get()).m_5456_(), 0.2f);
            UnusualPrehistory.addToComposter((ItemLike)UPBlocks.QUEREUXIA_TOP.get().m_5456_(), 0.2f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.PETRIFIED_BUSH.get()).m_5456_(), 0.2f);
            UnusualPrehistory.addToComposter((ItemLike)((Block)UPBlocks.ZULOAGAE.get()).m_5456_(), 0.2f);
        });
        UPMessages.register();
    }

    public static void addToFlowerPot(ResourceLocation plantBlockLoc, Supplier<? extends Block> pottedPlantBlock) {
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(plantBlockLoc, pottedPlantBlock);
    }

    public static void addToComposter(ItemLike item, float amountOfCompost) {
        ComposterBlock.f_51914_.put((Object)item, amountOfCompost);
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(MODID, name.toLowerCase(Locale.ROOT));
    }

    public static MutableComponent getTranslation(String key, Object ... args) {
        return Component.m_237110_((String)("unusualprehistory." + key), (Object[])args);
    }

    private void setupClient(FMLClientSetupEvent event) {
        PROXY.clientInit();
    }

    static {
        CALLBACKS = new ArrayList<Runnable>();
        LOGGER = LogManager.getLogger();
        PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }
}

