/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client;

import com.teammetallurgy.aquaculture.client.gui.screen.TackleBoxScreen;
import com.teammetallurgy.aquaculture.client.renderer.entity.AquaBobberRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.AquaFishRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.FishMountRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.TurtleLandRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishCathfishModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLargeModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLongnoseModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishMediumModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishSmallModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.JellyfishModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.TurtleLandModel;
import com.teammetallurgy.aquaculture.client.renderer.tileentity.NeptunesBountyRenderer;
import com.teammetallurgy.aquaculture.client.renderer.tileentity.TackleBoxRenderer;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.init.AquaBlockEntities;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaGuis;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.FishRegistry;
import com.teammetallurgy.aquaculture.item.DyeableItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.SpectralArrowRenderer;
import net.minecraft.client.renderer.entity.TippableArrowRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="aquaculture", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientHandler {
    public static final ModelLayerLocation TACKLE_BOX = new ModelLayerLocation(new ResourceLocation("aquaculture", "tackle_box"), "tackle_box");
    public static final ModelLayerLocation TURTLE_LAND_LAYER = new ModelLayerLocation(new ResourceLocation("aquaculture", "turtle_land"), "turtle_land");
    public static final ModelLayerLocation SMALL_MODEL = new ModelLayerLocation(new ResourceLocation("aquaculture", "small_model"), "small_model");
    public static final ModelLayerLocation MEDIUM_MODEL = new ModelLayerLocation(new ResourceLocation("aquaculture", "medium_model"), "medium_model");
    public static final ModelLayerLocation LARGE_MODEL = new ModelLayerLocation(new ResourceLocation("aquaculture", "large_model"), "large_model");
    public static final ModelLayerLocation LONGNOSE_MODEL = new ModelLayerLocation(new ResourceLocation("aquaculture", "longnose_model"), "longnose_model");
    public static final ModelLayerLocation CATFISH_MODEL = new ModelLayerLocation(new ResourceLocation("aquaculture", "catfish_model"), "catfish_model");
    public static final ModelLayerLocation JELLYFISH_MODEL = new ModelLayerLocation(new ResourceLocation("aquaculture", "jellyfish_model"), "jellyfish_model");

    public static void setupClient() {
        MenuScreens.m_96206_((MenuType)((MenuType)AquaGuis.TACKLE_BOX.get()), TackleBoxScreen::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)AquaBlockEntities.NEPTUNES_BOUNTY.get()), NeptunesBountyRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)AquaBlockEntities.TACKLE_BOX.get()), TackleBoxRenderer::new);
        ItemColors itemColor = Minecraft.m_91087_().getItemColors();
        itemColor.m_92689_((stack, tintIndex) -> tintIndex > 0 ? -1 : ((DyeableItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{(ItemLike)AquaItems.FISHING_LINE.get(), (ItemLike)AquaItems.BOBBER.get()});
        ClientHandler.registerFishingRodModelProperties((Item)AquaItems.IRON_FISHING_ROD.get());
        ClientHandler.registerFishingRodModelProperties((Item)AquaItems.GOLD_FISHING_ROD.get());
        ClientHandler.registerFishingRodModelProperties((Item)AquaItems.DIAMOND_FISHING_ROD.get());
        ClientHandler.registerFishingRodModelProperties((Item)AquaItems.NEPTUNIUM_FISHING_ROD.get());
        ClientHandler.registerBowModelProperties((Item)AquaItems.NEPTUNIUM_BOW.get());
    }

    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)AquaEntities.BOBBER.get(), AquaBobberRenderer::new);
        for (RegistryObject<EntityType<AquaFishEntity>> registryObject : FishRegistry.fishEntities) {
            event.registerEntityRenderer((EntityType)registryObject.get(), context -> new AquaFishRenderer(context, ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)fish.get())).equals((Object)new ResourceLocation("aquaculture", "jellyfish"))));
        }
        event.registerEntityRenderer((EntityType)AquaEntities.WATER_ARROW.get(), TippableArrowRenderer::new);
        event.registerEntityRenderer((EntityType)AquaEntities.SPECTRAL_WATER_ARROW.get(), SpectralArrowRenderer::new);
        event.registerEntityRenderer((EntityType)AquaEntities.BOX_TURTLE.get(), TurtleLandRenderer::new);
        event.registerEntityRenderer((EntityType)AquaEntities.ARRAU_TURTLE.get(), TurtleLandRenderer::new);
        event.registerEntityRenderer((EntityType)AquaEntities.STARSHELL_TURTLE.get(), TurtleLandRenderer::new);
        for (RegistryObject registryObject : FishRegistry.fishMounts) {
            event.registerEntityRenderer((EntityType)registryObject.get(), FishMountRenderer::new);
        }
    }

    @SubscribeEvent
    public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(TACKLE_BOX, TackleBoxRenderer::createLayer);
        event.registerLayerDefinition(TURTLE_LAND_LAYER, TurtleLandModel::createBodyLayer);
        event.registerLayerDefinition(SMALL_MODEL, FishSmallModel::createBodyLayer);
        event.registerLayerDefinition(MEDIUM_MODEL, FishMediumModel::createBodyLayer);
        event.registerLayerDefinition(LARGE_MODEL, FishLargeModel::createBodyLayer);
        event.registerLayerDefinition(LONGNOSE_MODEL, FishLongnoseModel::createBodyLayer);
        event.registerLayerDefinition(CATFISH_MODEL, FishCathfishModel::createBodyLayer);
        event.registerLayerDefinition(JELLYFISH_MODEL, JellyfishModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        event.register((ResourceLocation)FishMountRenderer.OAK);
        event.register((ResourceLocation)FishMountRenderer.SPRUCE);
        event.register((ResourceLocation)FishMountRenderer.BIRCH);
        event.register((ResourceLocation)FishMountRenderer.JUNGLE);
        event.register((ResourceLocation)FishMountRenderer.ACACIA);
        event.register((ResourceLocation)FishMountRenderer.DARK_OAK);
    }

    public static void registerFishingRodModelProperties(Item fishingRod) {
        ItemProperties.register((Item)fishingRod, (ResourceLocation)new ResourceLocation("cast"), (stack, level, entity, i) -> {
            boolean isOffHand;
            if (entity == null) {
                return 0.0f;
            }
            boolean isMainhand = entity.m_21205_() == stack;
            boolean bl = isOffHand = entity.m_21206_() == stack;
            if (entity.m_21205_().m_41720_() instanceof FishingRodItem) {
                isOffHand = false;
            }
            return (isMainhand || isOffHand) && entity instanceof Player && ((Player)entity).f_36083_ != null ? 1.0f : 0.0f;
        });
    }

    public static void registerBowModelProperties(Item bow) {
        ItemProperties.register((Item)bow, (ResourceLocation)new ResourceLocation("pull"), (stack, level, entity, i) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / 20.0f;
        });
        ItemProperties.register((Item)bow, (ResourceLocation)new ResourceLocation("pulling"), (stack, level, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }
}

