/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.utils.registry;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.sonmok14.fromtheshadows.server.entity.BulldrogiothEntity;
import net.sonmok14.fromtheshadows.server.entity.ClericEntity;
import net.sonmok14.fromtheshadows.server.entity.FroglinEntity;
import net.sonmok14.fromtheshadows.server.entity.NehemothEntity;
import net.sonmok14.fromtheshadows.server.entity.projectiles.CoralThornEntity;
import net.sonmok14.fromtheshadows.server.entity.projectiles.DoomBreathEntity;
import net.sonmok14.fromtheshadows.server.entity.projectiles.FrogVomit;
import net.sonmok14.fromtheshadows.server.entity.projectiles.PlayerBreathEntity;
import net.sonmok14.fromtheshadows.server.entity.projectiles.PlayerProjectileEntity;
import net.sonmok14.fromtheshadows.server.entity.projectiles.ScreenShakeEntity;
import net.sonmok14.fromtheshadows.server.entity.projectiles.ThrowingDaggerEntity;

@Mod.EventBusSubscriber(modid="fromtheshadows", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"fromtheshadows");
    public static final RegistryObject<EntityType<NehemothEntity>> NEHEMOTH = ENTITY_TYPES.register("nehemoth", () -> EntityType.Builder.m_20704_(NehemothEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.25f, 3.65f).m_20719_().m_20702_(9).m_20712_(new ResourceLocation("fromtheshadows", "nehemoth").toString()));
    public static final RegistryObject<EntityType<FroglinEntity>> FROGLIN = ENTITY_TYPES.register("froglin", () -> EntityType.Builder.m_20704_(FroglinEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(9).m_20712_(new ResourceLocation("fromtheshadows", "froglin").toString()));
    public static final RegistryObject<EntityType<BulldrogiothEntity>> BULLDROGIOTH = ENTITY_TYPES.register("bulldrogioth", () -> EntityType.Builder.m_20704_(BulldrogiothEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.5f, 2.9f).m_20702_(9).m_20712_(new ResourceLocation("fromtheshadows", "bulldrogioth").toString()));
    public static final RegistryObject<EntityType<ClericEntity>> CLERIC = ENTITY_TYPES.register("cleric", () -> EntityType.Builder.m_20704_(ClericEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(9).m_20712_(new ResourceLocation("fromtheshadows", "cleric").toString()));
    public static final RegistryObject<EntityType<ScreenShakeEntity>> SCREEN_SHAKE = ENTITY_TYPES.register("screen_shake", () -> EntityType.Builder.m_20704_(ScreenShakeEntity::new, (MobCategory)MobCategory.MISC).m_20698_().m_20699_(1.0f, 1.0f).setUpdateInterval(Integer.MAX_VALUE).m_20712_("fromtheshadows:screen_shake"));
    public static final RegistryObject<EntityType<DoomBreathEntity>> DOOM_BREATH = ENTITY_TYPES.register("doom_breath", () -> EntityType.Builder.m_20704_(DoomBreathEntity::new, (MobCategory)MobCategory.MISC).m_20698_().m_20699_(1.0f, 1.0f).setUpdateInterval(Integer.MAX_VALUE).m_20712_("fromtheshadows:doom_breath"));
    public static final RegistryObject<EntityType<PlayerBreathEntity>> PLAYER_BREATH = ENTITY_TYPES.register("player_breath", () -> EntityType.Builder.m_20704_(PlayerBreathEntity::new, (MobCategory)MobCategory.MISC).m_20698_().m_20699_(1.0f, 1.0f).setUpdateInterval(Integer.MAX_VALUE).m_20712_("fromtheshadows:player_breath"));
    public static final RegistryObject<EntityType<PlayerProjectileEntity>> PLAYER_PROJECTILE = ENTITY_TYPES.register("player_projectile", () -> EntityType.Builder.m_20704_(PlayerProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20698_().m_20699_(1.0f, 1.0f).setUpdateInterval(Integer.MAX_VALUE).m_20712_("fromtheshadows:player_projectile"));
    public static final RegistryObject<EntityType<CoralThornEntity>> CORAL_THORN = ENTITY_TYPES.register("coral_thorn", () -> EntityType.Builder.m_20704_(CoralThornEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20698_().setUpdateInterval(Integer.MAX_VALUE).m_20712_("fromtheshadows:coral_thorn"));
    public static final RegistryObject<EntityType<ThrowingDaggerEntity>> THROWING_DAGGER = ENTITY_TYPES.register("throwing_dagger", () -> EntityType.Builder.m_20704_(ThrowingDaggerEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20698_().setUpdateInterval(Integer.MAX_VALUE).m_20712_("fromtheshadows:throwing_dagger"));
    public static final RegistryObject<EntityType<FrogVomit>> FROGLIN_VOMIT = ENTITY_TYPES.register("froglin_vomit", () -> EntityType.Builder.m_20704_(FrogVomit::new, (MobCategory)MobCategory.MISC).m_20698_().m_20699_(1.0f, 1.0f).setUpdateInterval(Integer.MAX_VALUE).m_20712_("fromtheshadows:froglin_vomit"));

    public static Predicate<LivingEntity> buildPredicateFromTag(TagKey<EntityType<?>> entityTag) {
        if (entityTag == null) {
            return Predicates.alwaysFalse();
        }
        return e -> e.m_6084_() && e.m_6095_().m_204039_(entityTag);
    }

    public static boolean rollSpawn(int rolls, RandomSource random, MobSpawnType reason) {
        if (reason == MobSpawnType.SPAWNER) {
            return true;
        }
        return rolls <= 0 || random.m_188503_(rolls) == 0;
    }

    @SubscribeEvent
    public static void initializeAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)NEHEMOTH.get(), NehemothEntity.createAttributes().m_22265_());
        SpawnPlacements.m_21754_((EntityType)((EntityType)NEHEMOTH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, NehemothEntity::canNehemothSpawn);
        event.put((EntityType)FROGLIN.get(), FroglinEntity.createAttributes().m_22265_());
        SpawnPlacements.m_21754_((EntityType)((EntityType)FROGLIN.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FroglinEntity::canFroglinSpawn);
        event.put((EntityType)BULLDROGIOTH.get(), BulldrogiothEntity.createAttributes().m_22265_());
        SpawnPlacements.m_21754_((EntityType)((EntityType)BULLDROGIOTH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BulldrogiothEntity::canBulldrogiothSpawn);
        event.put((EntityType)CLERIC.get(), ClericEntity.createAttributes().m_22265_());
    }
}

