/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.items;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.sonmok14.fromtheshadows.client.renderer.items.CrustArmorRenderer;
import net.sonmok14.fromtheshadows.server.utils.registry.ItemRegistry;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrustArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public CrustArmorItem(ArmorMaterial materialIn, ArmorItem.Type type, Item.Properties builder) {
        super(materialIn, type, builder.m_41487_(1));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private CrustArmorRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new CrustArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> {
            state.setAnimation(DefaultAnimations.IDLE);
            Entity entity = (Entity)state.getData(DataTickets.ENTITY);
            if (entity instanceof ArmorStand) {
                return PlayState.CONTINUE;
            }
            ObjectOpenHashSet wornArmor = new ObjectOpenHashSet();
            for (ItemStack stack : entity.m_6168_()) {
                if (stack.m_41619_()) {
                    return PlayState.STOP;
                }
                wornArmor.add(stack.m_41720_());
            }
            boolean isFullSet = wornArmor.containsAll((Collection<?>)ObjectArrayList.of((Object[])new CrustArmorItem[]{(CrustArmorItem)((Object)((Object)ItemRegistry.CRUST_LEGGINGS.get())), (CrustArmorItem)((Object)((Object)ItemRegistry.CRUST_CHEST.get())), (CrustArmorItem)((Object)((Object)ItemRegistry.CRUST_HEAD.get()))}));
            return isFullSet ? PlayState.CONTINUE : PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6832_(ItemStack p_41134_, ItemStack p_41135_) {
        return p_41135_.m_150930_((Item)ItemRegistry.CRIMSON_SHELL.get());
    }

    public boolean isRepairable(ItemStack stack) {
        return super.isRepairable(stack);
    }
}

