/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.entity;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.sonmok14.fromtheshadows.server.Fromtheshadows;
import net.sonmok14.fromtheshadows.server.config.FTSConfig;
import net.sonmok14.fromtheshadows.server.entity.BulldrogiothEntity;
import net.sonmok14.fromtheshadows.server.entity.FTSMobType;
import net.sonmok14.fromtheshadows.server.entity.projectiles.DoomBreathEntity;
import net.sonmok14.fromtheshadows.server.entity.projectiles.ScreenShakeEntity;
import net.sonmok14.fromtheshadows.server.utils.registry.EffectRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.EntityRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.SoundRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NehemothEntity
extends Monster
implements Enemy,
GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> IS_RIGHT = SynchedEntityData.m_135353_(NehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STONE = SynchedEntityData.m_135353_(NehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(NehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(NehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int attackID;
    private int stunnedTick;
    public int attacktick;
    public int attackCooldown;
    public int biteCooldown;
    public int smashCooldown;
    public int breathCooldown;
    public int roarCooldown;
    public float growlProgress;
    public static final byte MELEE_ATTACK = 1;
    public static final byte BITE_ATTACK = 3;
    public static final byte ROAR_ATTACK = 4;
    public static final byte SMASH_ATTACK = 5;
    public static final byte BREATH_ATTACK = 6;
    public static final byte GUARD = 7;
    public static final ResourceLocation STONE_LOOT = new ResourceLocation("fromtheshadows", "entities/nehemoth_stone");

    public NehemothEntity(EntityType<? extends NehemothEntity> type, Level world) {
        super(type, world);
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.f_21364_ = 30;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "growl", 15, event -> {
            if (this.growlProgress <= 50.0f && this.m_6084_() && !this.isStone() && this.m_5448_() == null) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.growl"));
            }
            event.resetCurrentAnimation();
            return PlayState.STOP;
        })});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "stone", 50, event -> {
            if (this.isStone()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.stop1"));
            }
            return PlayState.STOP;
        })});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 20, event -> {
            if (!this.isStone()) {
                if (!event.isMoving() && this.attackID == 0 && !this.isClimbing() && this.attackCooldown <= 0) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.idle"));
                }
                if (this.attackID == 6 && this.attacktick < 18) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.breathready"));
                }
            }
            return PlayState.STOP;
        })});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 8, event -> {
            if (this.m_6084_()) {
                if (this.attackID == 0) {
                    event.resetCurrentAnimation();
                }
                if (this.attackID == 5 && this.m_20096_() && this.attacktick < 15) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.smash_start"));
                }
                if (this.attackID == 5 && !this.m_20096_()) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.jump"));
                }
                if (this.attackID == 1 && !this.isRight()) {
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.nehemoth.left_melee"));
                }
                if (this.attackID == 1 && this.isRight()) {
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.nehemoth.right_melee"));
                }
            }
            return PlayState.STOP;
        })});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller3", 3, event -> {
            if (!this.isStone()) {
                if (this.attackCooldown > 0) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.smash"));
                }
                if (event.isMoving() && this.f_267362_.m_267731_() > 0.35f && this.attackID == 0) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.run"));
                }
                if (this.isClimbing() && this.attackID == 0) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.climb"));
                }
                if (this.attackID == 4) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.roar"));
                }
                if (!this.m_6107_()) {
                    if (this.attackID == 1) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.none"));
                    }
                    if (this.attackID == 3) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.bite"));
                    }
                    if (this.attackID == 5 && !this.m_20096_()) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.jump"));
                    }
                    if (this.attackID == 5) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.none"));
                    }
                    if (this.attackID == 7) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.guard"));
                    }
                    if (this.attackID == 6 && this.attacktick < 18) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.none"));
                    }
                    if (this.attackID == 6) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.breath"));
                    }
                }
                if (this.m_6107_() && this.m_6084_()) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.stun"));
                }
                if (event.isMoving() && this.attackID == 0) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.walk"));
                }
            } else if (this.isStone()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.none"));
            }
            return PlayState.STOP;
        })});
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22276_, ((Double)FTSConfig.SERVER.nehemoth_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)FTSConfig.SERVER.nehemoth_melee_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22283_, 2.0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("Stone", this.isStone());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setStone(compound.m_128471_("Stone"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_RIGHT, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(CLIMBING, (Object)false);
        this.f_19804_.m_135372_(STONE, (Object)false);
    }

    public boolean isRight() {
        return (Boolean)this.f_19804_.m_135370_(IS_RIGHT);
    }

    public void setRight(boolean p_32759_) {
        this.f_19804_.m_135381_(IS_RIGHT, (Object)p_32759_);
    }

    public boolean isStone() {
        return (Boolean)this.f_19804_.m_135370_(STONE);
    }

    public void setStone(boolean p_32759_) {
        this.f_19804_.m_135381_(STONE, (Object)p_32759_);
    }

    public boolean isClimbing() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    public void setClimbing(boolean p_32759_) {
        this.f_19804_.m_135381_(CLIMBING, (Object)p_32759_);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (NehemothEntity.isBiomeSoulSandValley((LevelAccessor)worldIn, this.m_20183_())) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        this.m_20301_(this.m_6062_());
        this.m_146926_(0.0f);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private static boolean isNether(ServerLevelAccessor worldIn, BlockPos position) {
        return worldIn.m_204166_(position).m_203656_(BiomeTags.f_207612_);
    }

    private static boolean isBiomeSoulSandValley(LevelAccessor worldIn, BlockPos position) {
        return worldIn.m_204166_(position).m_203565_(Biomes.f_48199_);
    }

    public int m_5792_() {
        return 1;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return EntityRegistry.rollSpawn((Integer)FTSConfig.SERVER.nehemothSpawnRolls.get(), this.m_217043_(), spawnReasonIn);
    }

    public static <T extends Mob> boolean canNehemothSpawn(EntityType<NehemothEntity> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || !iServerWorld.m_45527_(pos) && (pos.m_123342_() <= 0 || NehemothEntity.isNether(iServerWorld, pos)) && NehemothEntity.isBiomeSoulSandValley((LevelAccessor)iServerWorld, pos) && NehemothEntity.m_219013_(entityType, iServerWorld, reason, pos, random);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public MobType m_6336_() {
        if (this.getVariant() == 1) {
            return MobType.f_21641_;
        }
        return FTSMobType.DEMON;
    }

    protected float m_6059_() {
        return this.m_5912_() ? this.f_19788_ + 2.0f : this.f_19788_ + 3.3f;
    }

    protected void m_7355_(BlockPos p_33350_, BlockState p_33351_) {
        if (this.isStone()) {
            super.m_7355_(p_33350_, p_33351_);
        } else {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.STOMP.get(), SoundSource.HOSTILE, 0.25f, 0.25f + this.m_217043_().m_188501_() * 0.1f);
        }
    }

    public boolean m_142066_() {
        return !this.isStone() && super.m_142066_();
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.35, true));
        this.f_21345_.m_25352_(0, (Goal)new DoubleMeleeAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new BiteAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new RoarGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SmashGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new BreathGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DoNothingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new GuardGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Allay.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{NehemothEntity.class}));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5, 25, true));
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else if (id == 39) {
            this.stunnedTick = 40;
        } else if (id == 45) {
            this.attackCooldown = 10;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7327_(Entity p_85031_1_) {
        this.m_146922_(this.f_20883_);
        if (!this.m_9236_().f_46443_) {
            this.attackID = 1;
        }
        return true;
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_274367_(1.0f);
        if (this.growlProgress == 80.0f && this.m_6084_() && !this.isStone() && this.m_5448_() == null) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.NEHEMOTH_IDLE.get(), SoundSource.HOSTILE, 0.5f, 0.5f + this.m_217043_().m_188501_() * 0.1f);
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.attackID == 0) {
            this.setRight(false);
        }
        if (this.m_9236_().m_46462_()) {
            this.setStone(false);
        }
        if (this.m_9236_().f_46443_ && this.m_6084_() && this.m_5448_() != null) {
            Fromtheshadows.PROXY.playWorldSound((Object)this, (byte)0);
        }
        if (this.attackID != 0) {
            ++this.attacktick;
        }
        if (this.breathCooldown > 0) {
            --this.breathCooldown;
        }
        if (this.biteCooldown > 0) {
            --this.biteCooldown;
        }
        if (this.roarCooldown > 0) {
            --this.roarCooldown;
        }
        if (this.smashCooldown > 0) {
            --this.smashCooldown;
        }
        if (this.smashCooldown == 0 && this.attackID == 5) {
            this.smashCooldown = 200;
        }
        if (this.biteCooldown == 0 && this.attackID == 3) {
            this.biteCooldown = 250;
        }
        if (this.breathCooldown == 0 && this.attackID == 6) {
            this.breathCooldown = 300;
        }
        if (this.roarCooldown == 0 && this.attackID == 4) {
            this.roarCooldown = 1500;
        }
        if (this.growlProgress == 0.0f) {
            this.growlProgress = 150.0f;
        }
        if (this.growlProgress > 0.0f) {
            this.growlProgress -= 1.0f;
        }
        if (this.stunnedTick > 0) {
            --this.stunnedTick;
        }
        if (this.isStone()) {
            this.setAttackID(0);
        }
        if (this.m_6084_() && this.m_5448_() != null && this.attackID != 6) {
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 1.5f, 90.0f);
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        Fromtheshadows.PROXY.clearSoundCacheFor((Entity)this);
        super.m_142687_(removalReason);
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.attackCooldown > 0 || this.stunnedTick > 0 || this.isStone();
    }

    public boolean m_142582_(Entity p_149755_) {
        return this.attackCooldown <= 0 || this.stunnedTick <= 0 && super.m_142582_(p_149755_);
    }

    public boolean m_214076_(ServerLevel p_216988_, LivingEntity p_216989_) {
        if (this.m_6084_()) {
            this.biteCooldown = 0;
            this.roarCooldown = 0;
        }
        return super.m_214076_(p_216988_, p_216989_);
    }

    public static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = Mth.m_14177_((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    private void smash(int distance) {
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * 2;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        if (this.m_6084_()) {
            for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(3.0))) {
                if (livingentity instanceof NehemothEntity) continue;
                livingentity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), ((Double)FTSConfig.SERVER.nehemoth_ranged_damage.get()).floatValue());
                this.strongKnockback((Entity)livingentity);
            }
        }
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance;
            double pz = this.m_20189_() + vz * (double)distance;
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) continue;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY, hitZ);
            BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
            BlockState block = this.m_9236_().m_8055_(pos);
            BlockState blockAbove = this.m_9236_().m_8055_(abovePos);
            if (this.m_9236_().m_8055_(pos) == Blocks.f_50016_.m_49966_()) continue;
            FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(this.m_9236_(), (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
            this.m_9236_().m_7731_(pos, block.m_60819_().m_76188_(), 3);
            fallingBlockEntity.m_5997_(this.m_217043_().m_188583_() * 0.2, 0.2 + this.m_217043_().m_188583_() * 0.2, this.m_217043_().m_188583_() * 0.2);
            this.m_9236_().m_7967_((Entity)fallingBlockEntity);
        }
    }

    public boolean m_7307_(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (p_32665_ instanceof Warden) {
            return true;
        }
        if (p_32665_ instanceof NehemothEntity) {
            return true;
        }
        if (p_32665_ instanceof BulldrogiothEntity) {
            return true;
        }
        return super.m_7307_(p_32665_);
    }

    private void strongKnockback(Entity p_33340_) {
        double d0 = p_33340_.m_20185_() - this.m_20185_();
        double d1 = p_33340_.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_33340_.m_5997_(d0 / d2, 0.05, d1 / d2);
    }

    protected void m_6731_(LivingEntity p_33361_) {
        if (this.f_19796_.m_188500_() < 0.5 && this.attackID == 3) {
            this.stunnedTick = 40;
            this.m_9236_().m_7605_((Entity)this, (byte)39);
            p_33361_.m_7334_((Entity)this);
        }
        p_33361_.f_19864_ = true;
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    private void meleeattack() {
        float range = 3.5f;
        float arc = 80.0f;
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, 3.5, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20885_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range) || !(entityRelativeAngle <= arc / 2.0f) || !(entityRelativeAngle >= -arc / 2.0f) || entityRelativeAngle >= 360.0f - arc / 2.0f != entityRelativeAngle <= -360.0f + arc / 2.0f || entityHit instanceof NehemothEntity) continue;
            boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
            if (entityHit.m_21254_()) continue;
            entityHit.f_19802_ = 0;
            if (!flag) continue;
            entityHit.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.BLEEDING.get(), 100), (Entity)this);
            entityHit.m_5496_((SoundEvent)SoundRegistry.NEHEMOTH_GORE_SOUND.get(), 1.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
        }
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunc) {
        super.m_19956_(passenger, moveFunc);
        if (this.m_20363_(passenger)) {
            double extraY;
            int tick = 5;
            if (this.attackID == 3) {
                tick = this.attacktick;
                if (this.attacktick == 22) {
                    passenger.m_8127_();
                }
                this.m_146922_(this.f_19859_);
                this.f_20883_ = this.m_146908_();
                this.f_20885_ = this.m_146908_();
            }
            float radius = 0.3f;
            float math = 1.0f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            double d = extraY = tick < 5 ? 0.0 : (double)(0.2f * (float)Mth.m_14045_((int)(tick - 5), (int)0, (int)5));
            if (passenger.m_20206_() < 1.0f) {
                passenger.m_6034_(this.m_20185_() + (double)(f * math) + extraX, this.m_20186_() + extraY + (double)1.4f, this.m_20189_() + (double)(f1 * math) + extraZ);
            } else {
                passenger.m_6034_(this.m_20185_() + (double)(f * math) + extraX, this.m_20186_() + extraY + (double)0.7f, this.m_20189_() + (double)(f1 * math) + extraZ);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        super.m_7350_(p_21104_);
    }

    private void roar() {
        if (this.m_6084_()) {
            for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(8.0, 1.0, 8.0))) {
                if (livingentity instanceof NehemothEntity) continue;
                livingentity.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 70, 0, false, false));
                livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 130, 0, false, false));
                this.strongKnockback((Entity)livingentity);
            }
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return this.isStone() ? SoundEvents.f_12446_ : (SoundEvent)SoundRegistry.NEHEMOTH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.isStone() ? SoundEvents.f_12442_ : (SoundEvent)SoundRegistry.NEHEMOTH_DEATH.get();
    }

    public float m_6100_() {
        return this.isStone() ? 1.0f : 0.4f;
    }

    protected void m_6153_() {
        if (this.isStone() && this.f_20919_ == 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        } else {
            super.m_6153_();
        }
    }

    public boolean m_6094_() {
        return !this.isStone();
    }

    @Nullable
    protected ResourceLocation m_7582_() {
        return this.isStone() ? STONE_LOOT : super.m_7582_();
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        Entity entity = p_21016_.m_7639_();
        if (this.attackID == 7) {
            return false;
        }
        if (p_21016_.m_269533_(DamageTypeTags.f_268524_)) {
            return super.m_6469_(p_21016_, p_21017_ / 4.0f);
        }
        if (this.isStone()) {
            if (p_21016_.m_269533_(DamageTypeTags.f_268738_)) {
                return super.m_6469_(p_21016_, p_21017_);
            }
            return false;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    public static boolean m_219013_(EntityType<? extends Monster> p_33018_, ServerLevelAccessor p_33019_, MobSpawnType p_33020_, BlockPos p_33021_, RandomSource p_33022_) {
        return p_33019_.m_46791_() != Difficulty.PEACEFUL && NehemothEntity.m_217057_(p_33018_, (LevelAccessor)p_33019_, (MobSpawnType)p_33020_, (BlockPos)p_33021_, (RandomSource)p_33022_);
    }

    public boolean m_213854_() {
        return true;
    }

    public boolean canRiderInteract() {
        return false;
    }

    protected boolean m_7341_(Entity p_20339_) {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.attackID != 0 || this.isStone()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            travelVector = Vec3.f_82478_;
            super.m_7023_(travelVector);
            return;
        }
        super.m_7023_(travelVector);
    }

    @Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    class DoubleMeleeAttackGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public DoubleMeleeAttackGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 1;
        }

        public void m_8056_() {
            NehemothEntity.this.setRight(NehemothEntity.this.f_19796_.m_188503_(2) != 0);
            this.nehemoth.setAttackID(1);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 50;
        }

        public void m_8037_() {
            float f2;
            float f1;
            NehemothEntity.this.m_146922_(NehemothEntity.this.f_20883_);
            if (NehemothEntity.this.attacktick == 7) {
                NehemothEntity.this.f_20883_ = NehemothEntity.this.f_20885_;
                f1 = (float)Math.cos(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                f2 = (float)Math.sin(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                NehemothEntity.this.m_5997_((double)f1 * 0.3, 0.0, (double)f2 * 0.3);
            }
            if (NehemothEntity.this.attacktick == 25) {
                NehemothEntity.this.f_20883_ = NehemothEntity.this.f_20885_;
                f1 = (float)Math.cos(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                f2 = (float)Math.sin(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                NehemothEntity.this.m_5997_((double)f1 * 0.3, 0.0, (double)f2 * 0.3);
            }
            if (NehemothEntity.this.attacktick == 9) {
                NehemothEntity.this.meleeattack();
                NehemothEntity.this.m_5496_(SoundEvents.f_12317_, 3.0f, 0.5f + NehemothEntity.this.m_217043_().m_188501_() * 0.1f);
            }
            if (NehemothEntity.this.attacktick == 31) {
                NehemothEntity.this.meleeattack();
                NehemothEntity.this.m_5496_(SoundEvents.f_12317_, 3.0f, 0.5f + NehemothEntity.this.m_217043_().m_188501_() * 0.1f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    class BiteAttackGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public BiteAttackGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && NehemothEntity.this.m_20270_((Entity)this.attackTarget) <= 3.0f && NehemothEntity.this.f_19796_.m_188503_(2) == 0 && this.nehemoth.m_20197_().isEmpty() && NehemothEntity.this.biteCooldown == 0 && this.attackTarget.m_20205_() < this.nehemoth.m_20205_();
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(3);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
            NehemothEntity.this.m_8127_();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 23 && this.nehemoth.attackID != 0;
        }

        public void m_8037_() {
            boolean flag;
            if (this.nehemoth.attacktick > 6 && this.attackTarget != null && !this.nehemoth.m_20363_((Entity)this.attackTarget)) {
                this.m_8041_();
            }
            if (this.attackTarget != null && NehemothEntity.this.attacktick == 2) {
                float f1 = (float)Math.cos(Math.toRadians(this.nehemoth.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(this.nehemoth.m_146908_() + 90.0f));
                this.nehemoth.m_5997_((double)f1 * 0.2, 0.0, f2 * 1.0f);
            }
            if (this.nehemoth.attacktick == 6 && this.nehemoth.m_20270_((Entity)this.attackTarget) < 4.0f && this.nehemoth.m_142582_((Entity)this.attackTarget) && this.attackTarget != null && !(flag = this.attackTarget.m_21254_()) && this.attackTarget.m_20205_() < this.nehemoth.m_20205_() && this.nehemoth.m_20197_().isEmpty() && !this.attackTarget.m_6144_()) {
                this.attackTarget.m_20329_((Entity)this.nehemoth);
            }
            if (this.nehemoth.attacktick > 6) {
                double d0 = this.nehemoth.m_20185_() - this.attackTarget.m_20185_();
                double d2 = this.nehemoth.m_20189_() - this.attackTarget.m_20189_();
                double d1 = this.nehemoth.m_20186_() - 1.0 - this.attackTarget.m_20186_();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.29577951308232));
                this.attackTarget.m_146926_(NehemothEntity.updateRotation(this.attackTarget.m_146909_(), f1, 30.0f));
                this.attackTarget.m_146922_(NehemothEntity.updateRotation(this.attackTarget.m_146908_(), f, 30.0f));
            }
            if (this.nehemoth.attacktick == 17 && this.nehemoth.m_20363_((Entity)this.attackTarget)) {
                this.attackTarget.m_6469_(this.nehemoth.m_269291_().m_269333_((LivingEntity)this.nehemoth), (float)this.nehemoth.m_21133_(Attributes.f_22281_));
                if (!this.attackTarget.m_21254_()) {
                    this.nehemoth.m_9236_().m_6263_(null, this.nehemoth.m_20185_(), this.nehemoth.m_20186_(), this.nehemoth.m_20189_(), SoundEvents.f_12465_, this.nehemoth.m_5720_(), 3.0f, 0.3f + (this.nehemoth.f_19796_.m_188501_() - this.nehemoth.f_19796_.m_188501_()) * 0.2f);
                    this.attackTarget.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.HEAL_BLOCK.get(), 100), (Entity)this.nehemoth);
                    NehemothEntity.this.m_5634_((float)this.nehemoth.m_21133_(Attributes.f_22281_) / 2.0f);
                }
                if (this.attackTarget.m_21254_() && this.nehemoth.f_19796_.m_188500_() < 0.5) {
                    NehemothEntity.this.m_6731_((LivingEntity)this.nehemoth);
                    NehemothEntity.this.m_20153_();
                    this.m_8041_();
                }
            }
            if (this.nehemoth.attacktick == 22 && NehemothEntity.this.m_20363_((Entity)this.attackTarget)) {
                NehemothEntity.this.m_20153_();
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    class RoarGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public RoarGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && NehemothEntity.this.m_20096_() && NehemothEntity.this.roarCooldown == 0;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(4);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 58;
        }

        public void m_8037_() {
            if (NehemothEntity.this.attacktick < 58 && this.attackTarget.m_6084_() && this.attackTarget != null) {
                NehemothEntity.this.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 90.0f);
            }
            if (NehemothEntity.this.attacktick > 8 && NehemothEntity.this.attacktick < 52) {
                NehemothEntity.this.roar();
            }
            if (NehemothEntity.this.attacktick == 8) {
                NehemothEntity.this.f_20883_ = NehemothEntity.this.f_20885_;
                float f1 = (float)Math.cos(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                NehemothEntity.this.m_5997_((double)f1 * 0.3, 0.0, (double)f2 * 0.3);
                this.nehemoth.m_9236_().m_6263_(null, this.nehemoth.m_20185_(), this.nehemoth.m_20186_(), this.nehemoth.m_20189_(), (SoundEvent)SoundRegistry.NEHEMOTH_ROAR.get(), SoundSource.HOSTILE, 1.5f, 0.7f + NehemothEntity.this.m_217043_().m_188501_() * 0.1f);
                ScreenShakeEntity.ScreenShake(NehemothEntity.this.m_9236_(), NehemothEntity.this.m_20182_(), 50.0f, 0.1f, 30, 30);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    class SmashGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public SmashGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && (double)NehemothEntity.this.m_20270_((Entity)this.attackTarget) > 5.0 && NehemothEntity.this.m_20096_() && NehemothEntity.this.f_19796_.m_188503_(2) == 0 && NehemothEntity.this.smashCooldown == 0 && !NehemothEntity.this.f_19862_;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(5);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 38 && this.nehemoth.attackID != 0;
        }

        public void m_8037_() {
            if (this.attackTarget != null && NehemothEntity.this.attacktick < 9 && this.attackTarget != null) {
                NehemothEntity.this.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 90.0f);
            }
            if (NehemothEntity.this.attacktick == 2) {
                float f1 = (float)Math.cos(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                NehemothEntity.this.m_5997_((double)f1 * 0.4, 0.0, (double)f2 * 0.4);
            }
            if (NehemothEntity.this.attacktick == 9) {
                NehemothEntity.this.m_20334_((this.attackTarget.m_20185_() - NehemothEntity.this.m_20185_()) * 0.21, 0.9, (this.attackTarget.m_20189_() - NehemothEntity.this.m_20189_()) * 0.21);
            }
            if (NehemothEntity.this.attacktick > 10 && NehemothEntity.this.m_20096_()) {
                Player player;
                NehemothEntity.this.attackCooldown = 10;
                this.nehemoth.m_9236_().m_7605_((Entity)this.nehemoth, (byte)45);
                this.attackTarget = this.nehemoth.m_5448_();
                if (this.attackTarget instanceof Player && this.attackTarget != null && (player = (Player)this.attackTarget).m_21254_()) {
                    player.m_36384_(true);
                }
                ScreenShakeEntity.ScreenShake(NehemothEntity.this.m_9236_(), NehemothEntity.this.m_20182_(), 15.0f, 0.2f, 0, 10);
                NehemothEntity.this.smash(4);
                NehemothEntity.this.m_5496_(SoundEvents.f_11913_, 2.0f, 0.2f + NehemothEntity.this.m_217043_().m_188501_() * 0.1f);
                this.m_8041_();
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    class BreathGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public BreathGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && NehemothEntity.this.m_20270_((Entity)this.attackTarget) <= 1024.0f && NehemothEntity.this.m_20096_() && NehemothEntity.this.f_19796_.m_188503_(8) == 0 && NehemothEntity.this.getVariant() == 1 && NehemothEntity.this.breathCooldown == 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(6);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 43;
        }

        public void m_8037_() {
            NehemothEntity.this.f_19865_ = Vec3.f_82478_;
            float radius1 = 0.2f;
            if (this.nehemoth.attacktick == 1) {
                this.nehemoth.m_5496_((SoundEvent)SoundRegistry.SOUL_LASER_READY.get(), 2.0f, 0.3f + this.nehemoth.m_217043_().m_188501_() * 0.1f);
            }
            if (this.nehemoth.attacktick == 3) {
                DoomBreathEntity doomBreath = new DoomBreathEntity((EntityType<? extends DoomBreathEntity>)((EntityType)EntityRegistry.DOOM_BREATH.get()), this.nehemoth.m_9236_(), (LivingEntity)this.nehemoth, this.nehemoth.m_20185_() + (double)radius1 * Math.sin((double)(-this.nehemoth.m_146908_()) * Math.PI / 180.0), this.nehemoth.m_20186_() + 1.4, this.nehemoth.m_20189_() + (double)radius1 * Math.cos((double)(-this.nehemoth.m_146908_()) * Math.PI / 180.0), (float)((double)(this.nehemoth.f_20885_ + 90.0f) * Math.PI / 180.0), (float)((double)(-this.nehemoth.m_146909_()) * Math.PI / 180.0), 10);
                this.nehemoth.m_9236_().m_7967_((Entity)doomBreath);
            }
            if (this.nehemoth.attacktick == 18) {
                ScreenShakeEntity.ScreenShake(NehemothEntity.this.m_9236_(), NehemothEntity.this.m_20182_(), 30.0f, 0.1f, 30, 30);
                this.nehemoth.m_5496_((SoundEvent)SoundRegistry.SOUL_LASER.get(), 3.0f, 0.8f + this.nehemoth.m_217043_().m_188501_() * 0.1f);
            }
            if (this.nehemoth.attacktick >= 15 && this.attackTarget != null) {
                this.nehemoth.m_21563_().m_24950_(this.attackTarget.m_20185_(), this.attackTarget.m_20186_() + (double)(this.attackTarget.m_20206_() / 2.0f), this.attackTarget.m_20189_(), 1.5f, 90.0f);
            }
            if (this.nehemoth.attacktick <= 14 && this.attackTarget != null) {
                NehemothEntity.this.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 90.0f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    class DoNothingGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public DoNothingGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(NehemothEntity.this.m_20185_(), NehemothEntity.this.m_20188_(), NehemothEntity.this.m_20189_());
            return NehemothEntity.this.m_9236_().m_46461_() && NehemothEntity.this.m_9236_().m_45527_((BlockPos)blockpos) && NehemothEntity.this.getVariant() == 0;
        }

        public void m_8037_() {
            NehemothEntity.this.attackID = 0;
            this.attackTarget = null;
            NehemothEntity.this.setStone(true);
        }
    }

    class GuardGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public GuardGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && (double)NehemothEntity.this.m_20270_((Entity)this.attackTarget) <= 3.0 && NehemothEntity.this.f_19796_.m_188503_(8) == 0 && this.attackTarget.f_20911_;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(7);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 20;
        }

        public void m_8037_() {
            NehemothEntity.this.f_19865_ = Vec3.f_82478_;
            if (this.nehemoth.attacktick < 20 && this.attackTarget.m_6084_()) {
                NehemothEntity.this.f_20883_ = NehemothEntity.this.f_20885_;
                NehemothEntity.this.m_21391_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }
}

