/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.entity;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.sonmok14.fromtheshadows.server.config.FTSConfig;
import net.sonmok14.fromtheshadows.server.entity.NehemothEntity;
import net.sonmok14.fromtheshadows.server.entity.ai.GroundPathNavigatorWide;
import net.sonmok14.fromtheshadows.server.entity.ai.ISemiAquatic;
import net.sonmok14.fromtheshadows.server.entity.ai.MobAIFindWater;
import net.sonmok14.fromtheshadows.server.entity.ai.MobAILeaveWater;
import net.sonmok14.fromtheshadows.server.entity.ai.SemiAquaticPathNavigator;
import net.sonmok14.fromtheshadows.server.entity.projectiles.FrogVomit;
import net.sonmok14.fromtheshadows.server.utils.registry.EntityRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.TagRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FroglinEntity
extends Monster
implements Enemy,
GeoEntity,
ISemiAquatic {
    boolean searchingForLand;
    private boolean isLandNavigator;
    public float SwimProgress = 0.0f;
    public float prevSwimProgress = 0.0f;
    private static final EntityDataAccessor<Boolean> RIGHT = SynchedEntityData.m_135353_(FroglinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FULL = SynchedEntityData.m_135353_(FroglinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(FroglinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float blinkProgress;
    public float croakingProgress;
    public int attacktick;
    public int attackID;
    public static final byte MELEE_ATTACK = 1;
    public static final byte VOMIT_ATTACK = 2;
    public static final byte JUMP_ATTACK = 3;
    public static final byte STRIKE_ATTACK = 4;
    public static final byte SWALLOW_ATTACK = 5;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FroglinEntity(EntityType<FroglinEntity> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.switchNavigator(false);
        this.f_21342_ = new FroglinMoveControl(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    @Nullable
    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, ((Double)FTSConfig.SERVER.froglin_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)FTSConfig.SERVER.froglin_melee_damage.get()).doubleValue()).m_22268_(Attributes.f_22284_, 2.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, event -> {
            if (event.isMoving() && this.f_267362_.m_267731_() > 0.35f && this.attackID == 0) {
                event.getController().setAnimationSpeed(1.5);
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.frog.walk"));
            }
            if (event.isMoving() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.frog.walkslow"));
            }
            if (!event.isMoving() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.frog.idle"));
            }
            if (this.attackID == 3 && this.attacktick > 9) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.frog.dash"));
            }
            if (this.attackID == 5 && this.attacktick > 9) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.frog.swallow"));
            }
            if (this.attackID == 5 && this.attacktick < 9) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.frog.crouched"));
            }
            if (this.attackID == 3 && this.attacktick < 9) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.frog.crouched"));
            }
            if (this.attackID == 2 && this.attacktick > 10) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.frog.vomitattack"));
            }
            if (this.attackID == 2 && this.attacktick < 10) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.frog.vomitready"));
            }
            if (this.attackID == 4) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.frog.strike"));
            }
            if (this.attackID == 1) {
                if (this.isRight()) {
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.frog.mtright"));
                }
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.frog.mtleft"));
            }
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "eye", 20, event -> {
            if (this.blinkProgress <= 10.0f) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.frog.eye"));
            }
            return PlayState.STOP;
        }).setSoundKeyframeHandler(event -> {
            if (event.getKeyframeData().getSound().matches("blinkSoundkey") && this.m_9236_().f_46443_) {
                this.m_20193_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12329_, SoundSource.HOSTILE, 1.0f, 0.5f, true);
            }
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "full", 20, event -> {
            if (this.isFull()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.frog.full"));
            }
            return PlayState.STOP;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "croaking", 20, event -> {
            if (this.croakingProgress <= 10.0f) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.frog.croaking"));
            }
            return PlayState.STOP;
        }).setSoundKeyframeHandler(event -> {
            if (event.getKeyframeData().getSound().matches("croakingSoundkey") && this.m_9236_().f_46443_) {
                this.m_20193_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215690_, SoundSource.HOSTILE, 1.0f, 0.5f, true);
            }
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    private static boolean isBiomeSwamp(LevelAccessor worldIn, BlockPos position) {
        return worldIn.m_204166_(position).m_203656_(Tags.Biomes.IS_SWAMP);
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return EntityRegistry.rollSpawn((Integer)FTSConfig.SERVER.froglinSpawnRolls.get(), this.m_217043_(), spawnReasonIn);
    }

    public static boolean m_219013_(EntityType<? extends Monster> p_33018_, ServerLevelAccessor p_33019_, MobSpawnType p_33020_, BlockPos p_33021_, RandomSource p_33022_) {
        return p_33019_.m_46791_() != Difficulty.PEACEFUL && FroglinEntity.m_217057_(p_33018_, (LevelAccessor)p_33019_, (MobSpawnType)p_33020_, (BlockPos)p_33021_, (RandomSource)p_33022_);
    }

    public static <T extends Mob> boolean canFroglinSpawn(EntityType<FroglinEntity> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || !iServerWorld.m_45527_(pos) && (pos.m_123342_() <= 0 || FroglinEntity.isBiomeSwamp((LevelAccessor)iServerWorld, pos) && FroglinEntity.m_219013_(entityType, iServerWorld, reason, pos, random));
    }

    public boolean canRiderInteract() {
        return false;
    }

    protected boolean m_7341_(Entity p_20339_) {
        return false;
    }

    @Override
    public boolean shouldEnterWater() {
        return false;
    }

    @Override
    public boolean shouldLeaveWater() {
        return this.m_5448_() != null && !this.m_5448_().m_20069_();
    }

    @Override
    public boolean shouldStopMoving() {
        return false;
    }

    @Override
    public int getWaterSearchRange() {
        return 32;
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        LivingEntity livingentity = this.m_5448_();
        return livingentity != null && livingentity.m_20069_();
    }

    public void m_7023_(Vec3 p_32394_) {
        if (this.attackID != 0) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            p_32394_ = Vec3.f_82478_;
            super.m_7023_(p_32394_);
            return;
        }
        if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.03f, p_32394_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        } else {
            super.m_7023_(p_32394_);
        }
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21344_ = new GroundPathNavigatorWide((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21344_ = new SemiAquaticPathNavigator((Mob)this, this.m_9236_());
            this.isLandNavigator = false;
        }
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean m_7327_(Entity p_85031_1_) {
        if (!this.m_9236_().f_46443_ && this.attackID == 0) {
            this.attackID = this.f_19796_.m_188503_(4) != 0 ? 1 : 4;
        }
        return true;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RIGHT, (Object)false);
        this.f_19804_.m_135372_(FULL, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setVariant(this.m_217043_().m_188503_(3));
        if (this.f_19796_.m_188503_(2) == 0) {
            this.setFull(true);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public boolean isRight() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT);
    }

    public void setRight(boolean p_32759_) {
        this.f_19804_.m_135381_(RIGHT, (Object)p_32759_);
    }

    public boolean isFull() {
        return (Boolean)this.f_19804_.m_135370_(FULL);
    }

    public void setFull(boolean p_32759_) {
        this.f_19804_.m_135381_(FULL, (Object)p_32759_);
    }

    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        this.setVariant(p_21450_.m_128451_("Variant"));
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_215693_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215691_;
    }

    private void meleeattack() {
        float range = 2.0f;
        float arc = 80.0f;
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, 3.5, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20885_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range) || !(entityRelativeAngle <= arc / 2.0f) || !(entityRelativeAngle >= -arc / 2.0f) || entityRelativeAngle >= 360.0f - arc / 2.0f != entityRelativeAngle <= -360.0f + arc / 2.0f || entityHit instanceof FroglinEntity) continue;
            entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_) * 1.3f);
        }
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
        }
        this.m_274367_(1.0f);
        if (this.attackID == 0) {
            this.setRight(false);
        }
        if (this.blinkProgress == 0.0f) {
            this.blinkProgress = 100.0f;
        }
        if (this.blinkProgress > 0.0f) {
            this.blinkProgress -= 1.0f;
        }
        if (this.croakingProgress == 0.0f) {
            this.croakingProgress = 50.0f;
        }
        if (this.croakingProgress > 0.0f) {
            this.croakingProgress -= 1.0f;
        }
        if (this.m_20069_() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.m_20069_() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        this.prevSwimProgress = this.SwimProgress;
        if (this.m_20069_()) {
            if (this.SwimProgress < 10.0f) {
                this.SwimProgress += 1.0f;
            }
        } else if (this.SwimProgress > 0.0f) {
            this.SwimProgress -= 1.0f;
        }
        if (this.attackID != 0) {
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            ++this.attacktick;
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 90.0f);
            }
        }
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn == this) {
            return true;
        }
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof FroglinEntity) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new FroglinGoToBeachGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FroglinSwimUpGoal(this, 1.0, this.m_9236_().m_5736_()));
        this.f_21345_.m_25352_(4, (Goal)new MobAIFindWater((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MobAILeaveWater((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new FroglinSwallowAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FroglinVomitGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FroglinMeleeAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FroglinStrikeAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FroglinJumpAttackGoal(this));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, NehemothEntity.class, 6.0f, 1.0, 1.2));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractFish.class, true));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5, 25, true));
        super.m_8099_();
    }

    public boolean m_214076_(ServerLevel p_216988_, LivingEntity p_216989_) {
        if (!this.isFull() && p_216989_.m_20206_() < 1.0f && this.f_19796_.m_188503_(3) == 0) {
            this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
            this.setFull(true);
        }
        return super.m_214076_(p_216988_, p_216989_);
    }

    public void setSearchingForLand(boolean p_32399_) {
        this.searchingForLand = p_32399_;
    }

    protected boolean closeToNextPos() {
        double d0;
        BlockPos blockpos;
        Path path = this.m_21573_().m_26570_();
        return path != null && (blockpos = path.m_77406_()) != null && (d0 = this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_())) < 4.0;
    }

    static class FroglinMoveControl
    extends MoveControl {
        private final FroglinEntity froglinEntity;

        public FroglinMoveControl(FroglinEntity p_32433_) {
            super((Mob)p_32433_);
            this.froglinEntity = p_32433_;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.froglinEntity.m_5448_();
            if (this.froglinEntity.wantsToSwim() && this.froglinEntity.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.froglinEntity.m_20186_() || this.froglinEntity.searchingForLand) {
                    this.froglinEntity.m_20256_(this.froglinEntity.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.froglinEntity.m_21573_().m_26571_()) {
                    this.froglinEntity.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.froglinEntity.m_20185_();
                double d1 = this.f_24976_ - this.froglinEntity.m_20186_();
                double d2 = this.f_24977_ - this.froglinEntity.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.froglinEntity.m_146922_(this.m_24991_(this.froglinEntity.m_146908_(), f, 90.0f));
                this.froglinEntity.f_20883_ = this.froglinEntity.m_146908_();
                float f1 = (float)(this.f_24978_ * this.froglinEntity.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.froglinEntity.m_6113_(), (float)f1);
                this.froglinEntity.m_7910_(f2);
                this.froglinEntity.m_20256_(this.froglinEntity.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.froglinEntity.m_20096_()) {
                    this.froglinEntity.m_20256_(this.froglinEntity.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }

    static class FroglinGoToBeachGoal
    extends MoveToBlockGoal {
        private final FroglinEntity froglinEntity;

        public FroglinGoToBeachGoal(FroglinEntity p_32409_, double p_32410_) {
            super((PathfinderMob)p_32409_, p_32410_, 8, 2);
            this.froglinEntity = p_32409_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.froglinEntity.m_9236_().m_46471_() && this.froglinEntity.m_20069_() && this.froglinEntity.m_20186_() >= (double)(this.froglinEntity.m_9236_().m_5736_() - 3);
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected boolean m_6465_(LevelReader p_32413_, BlockPos p_32414_) {
            BlockPos blockpos = p_32414_.m_7494_();
            return p_32413_.m_46859_(blockpos) && p_32413_.m_46859_(blockpos.m_7494_()) ? p_32413_.m_8055_(p_32414_).m_60634_((BlockGetter)p_32413_, p_32414_, (Entity)this.froglinEntity) : false;
        }

        public void m_8056_() {
            this.froglinEntity.setSearchingForLand(false);
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class FroglinSwimUpGoal
    extends Goal {
        private final FroglinEntity froglinEntity;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public FroglinSwimUpGoal(FroglinEntity p_32440_, double p_32441_, int p_32442_) {
            this.froglinEntity = p_32440_;
            this.speedModifier = p_32441_;
            this.seaLevel = p_32442_;
        }

        public boolean m_8036_() {
            return (this.froglinEntity.m_9236_().m_46471_() || this.froglinEntity.m_20069_()) && this.froglinEntity.m_20186_() < (double)(this.seaLevel - 2);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.froglinEntity.m_20186_() < (double)(this.seaLevel - 1) && (this.froglinEntity.m_21573_().m_26571_() || this.froglinEntity.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.froglinEntity, (int)4, (int)8, (Vec3)new Vec3(this.froglinEntity.m_20185_(), (double)(this.seaLevel - 1), this.froglinEntity.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.froglinEntity.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            this.froglinEntity.setSearchingForLand(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.froglinEntity.setSearchingForLand(false);
        }
    }

    class FroglinSwallowAttackGoal
    extends Goal {
        private final FroglinEntity froglinEntity;
        private LivingEntity attackTarget;

        public FroglinSwallowAttackGoal(FroglinEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.froglinEntity = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.froglinEntity.m_5448_();
            return this.attackTarget != null && this.froglinEntity.attackID == 0 && (double)FroglinEntity.this.m_20270_((Entity)this.attackTarget) <= 4.0 && FroglinEntity.this.f_19796_.m_188503_(10) == 0 && !this.attackTarget.m_6095_().m_204039_(TagRegistry.FROGLIN_NOT_SWALLOW) && this.attackTarget.m_20206_() < 1.0f && !FroglinEntity.this.isFull();
        }

        public void m_8056_() {
            this.froglinEntity.setAttackID(5);
        }

        public void m_8041_() {
            this.froglinEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.froglinEntity.attacktick < 20;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.froglinEntity.attacktick == 2) {
                float f1 = (float)Math.cos(Math.toRadians(FroglinEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(FroglinEntity.this.m_146908_() + 90.0f));
                FroglinEntity.this.m_5997_((double)f1 * 0.4, 0.0, (double)f2 * 0.4);
            }
            if (FroglinEntity.this.attacktick == 9) {
                FroglinEntity.this.m_20334_((this.attackTarget.m_20185_() - FroglinEntity.this.m_20185_()) * 0.21, 0.5, (this.attackTarget.m_20189_() - FroglinEntity.this.m_20189_()) * 0.21);
            }
            if (this.froglinEntity.attacktick >= 14 && this.froglinEntity.m_20270_((Entity)this.attackTarget) <= 4.0f && this.attackTarget != null) {
                FroglinEntity.this.setFull(true);
                this.froglinEntity.m_146850_(GameEvent.f_157806_);
                this.froglinEntity.m_5496_(SoundEvents.f_11912_, this.froglinEntity.m_6121_(), this.froglinEntity.m_6100_());
                this.attackTarget.m_146870_();
            }
            FroglinEntity.this.m_21573_().m_26569_();
        }
    }

    class FroglinVomitGoal
    extends Goal {
        private final FroglinEntity froglinEntity;
        private LivingEntity attackTarget;

        public FroglinVomitGoal(FroglinEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.froglinEntity = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.froglinEntity.m_5448_();
            return this.attackTarget != null && this.froglinEntity.attackID == 0 && (double)FroglinEntity.this.m_20270_((Entity)this.attackTarget) > 5.0 && FroglinEntity.this.m_20096_() && FroglinEntity.this.f_19796_.m_188503_(5) == 0 && FroglinEntity.this.isFull();
        }

        public void m_8056_() {
            this.froglinEntity.setAttackID(2);
        }

        public void m_8041_() {
            this.froglinEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.froglinEntity.attacktick < 30;
        }

        public void m_8037_() {
            double d3;
            double d2;
            double d1;
            double d0;
            if (FroglinEntity.this.attacktick == 10) {
                this.froglinEntity.m_5496_(SoundEvents.f_12321_, 2.0f, 0.2f + this.froglinEntity.m_217043_().m_188501_() * 0.1f);
                FrogVomit frogVomit = new FrogVomit(this.froglinEntity.m_9236_(), (LivingEntity)this.froglinEntity);
                d0 = this.attackTarget.m_20185_() - this.froglinEntity.m_20185_();
                d1 = this.attackTarget.m_20227_(0.3333333333333333) - frogVomit.m_20186_();
                d2 = this.attackTarget.m_20189_() - this.froglinEntity.m_20189_();
                d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.4f;
                frogVomit.m_6686_(d0, d1 + d3, d2, 1.0f, 5.0f);
                this.froglinEntity.m_9236_().m_7967_((Entity)frogVomit);
            }
            if (FroglinEntity.this.attacktick == 20) {
                this.froglinEntity.m_5496_(SoundEvents.f_12321_, 1.0f, 0.8f + this.froglinEntity.m_217043_().m_188501_() * 0.1f);
                FrogVomit llamaspit = new FrogVomit(this.froglinEntity.m_9236_(), (LivingEntity)this.froglinEntity);
                d0 = this.attackTarget.m_20185_() - this.froglinEntity.m_20185_();
                d1 = this.attackTarget.m_20227_(0.3333333333333333) - llamaspit.m_20186_();
                d2 = this.attackTarget.m_20189_() - this.froglinEntity.m_20189_();
                d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.4f;
                llamaspit.m_6686_(d0, d1 + d3, d2, 1.0f, 5.0f);
                FroglinEntity.this.setFull(false);
                this.froglinEntity.m_9236_().m_7967_((Entity)llamaspit);
            }
            FroglinEntity.this.m_21573_().m_26569_();
        }
    }

    class FroglinMeleeAttackGoal
    extends Goal {
        private final FroglinEntity froglinEntity;
        private LivingEntity attackTarget;

        public FroglinMeleeAttackGoal(FroglinEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.froglinEntity = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.froglinEntity.m_5448_();
            return this.attackTarget != null && this.froglinEntity.attackID == 1;
        }

        public void m_8056_() {
            FroglinEntity.this.setRight(FroglinEntity.this.f_19796_.m_188503_(2) != 0);
            this.froglinEntity.setAttackID(1);
        }

        public void m_8041_() {
            this.froglinEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.froglinEntity.attacktick < 20;
        }

        public void m_8037_() {
            if (FroglinEntity.this.attacktick == 4) {
                float f1 = (float)Math.cos(Math.toRadians(FroglinEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(FroglinEntity.this.m_146908_() + 90.0f));
                FroglinEntity.this.m_5997_((double)f1 * 0.3, 0.0, (double)f2 * 0.3);
            }
            if (FroglinEntity.this.attacktick == 9 && FroglinEntity.this.m_20270_((Entity)this.attackTarget) <= 3.5f) {
                this.attackTarget.m_6469_(FroglinEntity.this.m_269291_().m_269333_((LivingEntity)this.froglinEntity), (float)FroglinEntity.this.m_21133_(Attributes.f_22281_));
            }
            FroglinEntity.this.m_21573_().m_26569_();
        }
    }

    class FroglinStrikeAttackGoal
    extends Goal {
        private final FroglinEntity froglinEntity;
        private LivingEntity attackTarget;

        public FroglinStrikeAttackGoal(FroglinEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.froglinEntity = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.froglinEntity.m_5448_();
            return this.attackTarget != null && this.froglinEntity.attackID == 4;
        }

        public void m_8056_() {
            this.froglinEntity.setAttackID(4);
        }

        public void m_8041_() {
            this.froglinEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.froglinEntity.attacktick < 22;
        }

        public void m_8037_() {
            if (FroglinEntity.this.attacktick == 5) {
                FroglinEntity.this.f_20883_ = FroglinEntity.this.f_20885_;
                float f1 = (float)Math.cos(Math.toRadians(this.froglinEntity.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(this.froglinEntity.m_146908_() + 90.0f));
                this.froglinEntity.m_5997_((double)f1 * 0.3, 0.0, (double)f2 * 0.3);
            }
            if (FroglinEntity.this.attacktick == 12) {
                FroglinEntity.this.meleeattack();
            }
            FroglinEntity.this.m_21573_().m_26569_();
        }
    }

    class FroglinJumpAttackGoal
    extends Goal {
        private final FroglinEntity froglinEntity;
        private LivingEntity attackTarget;

        public FroglinJumpAttackGoal(FroglinEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.froglinEntity = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.froglinEntity.m_5448_();
            return this.attackTarget != null && this.froglinEntity.attackID == 0 && (double)FroglinEntity.this.m_20270_((Entity)this.attackTarget) > 4.0 && FroglinEntity.this.m_20096_() && FroglinEntity.this.f_19796_.m_188503_(15) == 0;
        }

        public void m_8056_() {
            this.froglinEntity.setAttackID(3);
        }

        public void m_8041_() {
            this.froglinEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.froglinEntity.attacktick < 20;
        }

        public void m_8037_() {
            if (this.froglinEntity.attacktick == 2) {
                float f1 = (float)Math.cos(Math.toRadians(FroglinEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(FroglinEntity.this.m_146908_() + 90.0f));
                FroglinEntity.this.m_5997_((double)f1 * 0.4, 0.0, (double)f2 * 0.4);
            }
            if (FroglinEntity.this.attacktick == 9) {
                FroglinEntity.this.m_20334_((this.attackTarget.m_20185_() - FroglinEntity.this.m_20185_()) * 0.21, 0.5, (this.attackTarget.m_20189_() - FroglinEntity.this.m_20189_()) * 0.21);
            }
            if (this.froglinEntity.attacktick >= 14) {
                FroglinEntity.this.meleeattack();
            }
            FroglinEntity.this.m_21573_().m_26569_();
        }
    }
}

