/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.entity;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.sonmok14.fromtheshadows.server.config.FTSConfig;
import net.sonmok14.fromtheshadows.server.entity.NehemothEntity;
import net.sonmok14.fromtheshadows.server.entity.ai.GroundPathNavigatorWide;
import net.sonmok14.fromtheshadows.server.entity.ai.ISemiAquatic;
import net.sonmok14.fromtheshadows.server.entity.ai.MobAIFindWater;
import net.sonmok14.fromtheshadows.server.entity.ai.MobAILeaveWater;
import net.sonmok14.fromtheshadows.server.entity.ai.SemiAquaticPathNavigator;
import net.sonmok14.fromtheshadows.server.entity.projectiles.CoralThornEntity;
import net.sonmok14.fromtheshadows.server.entity.projectiles.ScreenShakeEntity;
import net.sonmok14.fromtheshadows.server.utils.registry.SoundRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BulldrogiothEntity
extends Monster
implements Enemy,
GeoEntity,
ISemiAquatic {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(BulldrogiothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float growlingProgress;
    public int attacktick;
    public int biteCooldown;
    public int comboCooldown;
    public int coralthornCooldown;
    public int coralthorncomboCooldown;
    public int attackID;
    private static final EntityDataAccessor<Boolean> IS_RIGHT = SynchedEntityData.m_135353_(BulldrogiothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    boolean searchingForLand;
    private boolean isLandNavigator;
    public float SwimProgress = 0.0f;
    public float prevSwimProgress = 0.0f;
    public static final byte MELEE_ATTACK = 1;
    public static final byte CLAW = 2;
    public static final byte COMBO = 3;
    public static final byte BITE = 4;
    public static final byte CORAL_THORN = 5;
    public static final byte CORAL_THORN_COMBO = 6;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BulldrogiothEntity(EntityType<BulldrogiothEntity> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.switchNavigator(false);
        this.f_21342_ = new BulldrogiothMoveControl(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.f_21364_ = 30;
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(IS_RIGHT, (Object)false);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public boolean isRight() {
        return (Boolean)this.f_19804_.m_135370_(IS_RIGHT);
    }

    public void setRight(boolean p_32759_) {
        this.f_19804_.m_135381_(IS_RIGHT, (Object)p_32759_);
    }

    private static boolean isBiomeSwamp(LevelAccessor worldIn, BlockPos position) {
        return worldIn.m_204166_(position).m_203565_(Biomes.f_48207_) || worldIn.m_204166_(position).m_203565_(Biomes.f_220595_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (BulldrogiothEntity.isBiomeSwamp((LevelAccessor)worldIn, this.m_20183_())) {
            this.setVariant(2);
        } else {
            this.setVariant(this.m_217043_().m_188503_(2));
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        this.setVariant(p_21450_.m_128451_("Variant"));
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else {
            super.m_7822_(id);
        }
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    @Override
    public int getWaterSearchRange() {
        return 32;
    }

    public boolean canRiderInteract() {
        return false;
    }

    @Override
    public boolean shouldEnterWater() {
        return false;
    }

    @Override
    public boolean shouldLeaveWater() {
        return this.m_5448_() != null && !this.m_5448_().m_20069_();
    }

    @Override
    public boolean shouldStopMoving() {
        return false;
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        LivingEntity livingentity = this.m_5448_();
        return livingentity != null && livingentity.m_20069_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 7, event -> {
            if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bulldrogioth.death"));
            }
            if (this.f_19800_ && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bulldrogioth.swim"));
            }
            if (event.isMoving() && !this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bulldrogioth.walk"));
            }
            if (this.attackID != 0) {
                event.resetCurrentAnimation();
            }
            if (this.f_19800_ && this.f_267362_.m_267731_() > 0.35f && this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bulldrogioth.swim"));
            }
            if (this.f_267362_.m_267731_() > 0.35f && this.m_5912_() && this.attackID == 0) {
                event.getController().setAnimationSpeed(1.25);
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bulldrogioth.walk"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bulldrogioth.idle"));
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attack", 15, event -> {
            if (this.m_6084_()) {
                if (this.attackID == 0) {
                    event.resetCurrentAnimation();
                }
                if (this.attackID == 1) {
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bulldrogioth.normal"));
                }
                if (this.attackID == 2 && !this.isRight()) {
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bulldrogioth.claw_left"));
                }
                if (this.attackID == 2 && this.isRight()) {
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bulldrogioth.claw_right"));
                }
                if (this.attackID == 5 && this.isRight()) {
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bulldrogioth.thorn_right"));
                }
                if (this.attackID == 5 && !this.isRight()) {
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bulldrogioth.thorn_left"));
                }
                if (this.attackID == 3) {
                    if (this.isRight()) {
                        return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bulldrogioth.combo_right"));
                    }
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bulldrogioth.combo_left"));
                }
                if (this.attackID == 4) {
                    if (this.isRight()) {
                        return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bulldrogioth.bite_right"));
                    }
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bulldrogioth.bite_left"));
                }
                if (this.attackID == 6) {
                    if (this.isRight()) {
                        return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bulldrogioth.thorn_combo_right"));
                    }
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bulldrogioth.thorn_combo_left"));
                }
            }
            return PlayState.STOP;
        }).setSoundKeyframeHandler(event -> {
            if (event.getKeyframeData().getSound().matches("attackkey") && this.m_9236_().f_46443_) {
                this.m_20193_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.BULLDROGIOTH_ATTACK.get(), SoundSource.HOSTILE, 0.5f, this.m_6100_() + this.m_217043_().m_188501_() * 0.1f, false);
            }
            if (event.getKeyframeData().getSound().matches("combokey") && this.m_9236_().f_46443_) {
                this.m_20193_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.BULLDROGIOTH_ATTACK.get(), SoundSource.HOSTILE, 0.5f, 0.3f + this.m_217043_().m_188501_() * 0.1f, false);
            }
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "growling", 20, event -> {
            if (this.growlingProgress <= 30.0f && this.m_6084_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bulldrogioth.growl"));
            }
            return PlayState.STOP;
        }).setSoundKeyframeHandler(event -> {
            if (event.getKeyframeData().getSound().matches("growlkey") && this.m_9236_().f_46443_) {
                this.m_20193_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.BULLDROGIOTH_IDLE.get(), SoundSource.HOSTILE, 0.5f, this.m_6100_() + this.m_217043_().m_188501_() * 0.1f, false);
            }
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "hurt", 20, event -> {
            if (this.f_20916_ > 0 && this.m_6084_()) {
                event.getController().setAnimationSpeed(0.5);
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bulldrogioth.hurt"));
            }
            return PlayState.STOP;
        }).setSoundKeyframeHandler(event -> {
            if (event.getKeyframeData().getSound().matches("hurtkey") && this.m_9236_().f_46443_) {
                this.m_20193_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.BULLDROGIOTH_HURT.get(), SoundSource.HOSTILE, 0.5f, this.m_6100_() + this.m_217043_().m_188501_() * 0.1f, false);
            }
        })});
    }

    @Nullable
    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, ((Double)FTSConfig.SERVER.bulldrogioth_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)FTSConfig.SERVER.bulldrogioth_melee_damage.get()).doubleValue()).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22285_, 10.0);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.BULLDROGIOTH_HURT.get();
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (p_21016_.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(p_21016_, p_21017_);
        }
        if (p_21016_.m_269533_(DamageTypeTags.f_268524_)) {
            return super.m_6469_(p_21016_, p_21017_ / 2.0f);
        }
        if (p_21016_.m_269533_(DamageTypeTags.f_268745_)) {
            return super.m_6469_(p_21016_, p_21017_ * 2.0f);
        }
        if (p_21016_.m_269533_(DamageTypeTags.f_268725_)) {
            return super.m_6469_(p_21016_, p_21017_ * 4.0f);
        }
        if (p_21016_.m_269533_(DamageTypeTags.f_268415_)) {
            return super.m_6469_(p_21016_, p_21017_ / 4.0f);
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    private void meleeattack() {
        float range = 3.0f;
        float arc = 80.0f;
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, 3.5, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20885_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range) || !(entityRelativeAngle <= arc / 2.0f) || !(entityRelativeAngle >= -arc / 2.0f) || entityRelativeAngle >= 360.0f - arc / 2.0f != entityRelativeAngle <= -360.0f + arc / 2.0f) continue;
            if (!(entityHit instanceof BulldrogiothEntity)) {
                entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                this.strongKnockback((Entity)entityHit);
            }
            if (entityHit instanceof BulldrogiothEntity || this.attackID != 4) continue;
            entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_) / 3.0f);
        }
    }

    private void rightClaw() {
        float range = 3.5f;
        float arc = 80.0f;
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, 3.5, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20885_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range) || !(entityRelativeAngle <= arc / 2.0f) || !(entityRelativeAngle >= -arc / 2.0f) || entityRelativeAngle >= 360.0f - arc / 2.0f != entityRelativeAngle <= -360.0f + arc / 2.0f || entityHit instanceof BulldrogiothEntity) continue;
            entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        }
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    public boolean m_7327_(Entity target) {
        if (!this.m_9236_().f_46443_ && this.attackID == 0) {
            this.attackID = this.f_19796_.m_188503_(4) != 0 ? 2 : 1;
        }
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_274367_(1.0f);
        if (this.growlingProgress == 0.0f) {
            this.growlingProgress = 150.0f;
        }
        if (this.attackID == 0) {
            this.setRight(false);
        }
        if (this.attackID == 0 && this.m_5448_() != null) {
            this.m_21391_((Entity)this.m_5448_(), 20.0f, 20.0f);
        }
        if (this.m_20069_() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.m_20069_() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        this.prevSwimProgress = this.SwimProgress;
        if (this.m_20069_()) {
            if (this.SwimProgress < 10.0f) {
                this.SwimProgress += 1.0f;
            }
        } else if (this.SwimProgress > 0.0f) {
            this.SwimProgress -= 1.0f;
        }
        if (this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (!(block instanceof LeavesBlock)) continue;
                flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
            }
            if (!flag && this.m_20096_()) {
                this.m_6135_();
            }
        }
        if (this.attackID != 0) {
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            ++this.attacktick;
            if (this.m_5448_() != null) {
                this.m_21391_((Entity)this.m_5448_(), 30.0f, 30.0f);
            }
        }
        if (this.comboCooldown > 0) {
            --this.comboCooldown;
        }
        if (this.biteCooldown > 0) {
            --this.biteCooldown;
        }
        if (this.coralthornCooldown > 0) {
            --this.coralthornCooldown;
        }
        if (this.coralthorncomboCooldown > 0) {
            --this.coralthorncomboCooldown;
        }
        if (this.biteCooldown == 0 && this.attackID == 4) {
            this.biteCooldown = 150;
        }
        if (this.comboCooldown == 0 && this.attackID == 3) {
            this.comboCooldown = 200;
        }
        if (this.coralthornCooldown == 0 && this.attackID == 5) {
            this.coralthornCooldown = 400;
        }
        if (this.coralthorncomboCooldown == 0 && this.attackID == 6) {
            this.coralthorncomboCooldown = 600;
        }
        if (this.growlingProgress > 0.0f) {
            this.growlingProgress -= 1.0f;
        }
    }

    protected float m_6059_() {
        if (this.m_5912_()) {
            return this.f_19788_ + 2.5f;
        }
        return this.f_19788_ + 3.0f;
    }

    protected void m_7355_(BlockPos p_33350_, BlockState p_33351_) {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.STOMP.get(), SoundSource.HOSTILE, 0.25f, 0.35f + this.m_217043_().m_188501_() * 0.1f);
    }

    public static <T extends Mob> boolean canBulldrogiothSpawn(EntityType<BulldrogiothEntity> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || iServerWorld.m_45527_(pos) && BulldrogiothEntity.m_219013_(entityType, (ServerLevelAccessor)iServerWorld, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public boolean m_7307_(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (p_32665_ instanceof Warden) {
            return true;
        }
        if (p_32665_ instanceof BulldrogiothEntity) {
            return true;
        }
        if (p_32665_ instanceof NehemothEntity) {
            return true;
        }
        return super.m_7307_(p_32665_);
    }

    public boolean m_213854_() {
        return true;
    }

    public void coralThorn() {
        if (this.m_5448_() != null) {
            int count = 3;
            double offsetangle = Math.toRadians(20.0);
            double d1 = this.m_5448_().m_20185_() - this.m_20185_();
            double d2 = this.m_5448_().m_20186_() - this.m_20186_();
            double d3 = this.m_5448_().m_20189_() - this.m_20189_();
            for (int i = 0; i <= count - 1; ++i) {
                double angle = (double)(i - (count - 1) / 4) * offsetangle;
                CoralThornEntity coralThornEntity = new CoralThornEntity(this.m_9236_(), (LivingEntity)this, null);
                double f0 = this.m_5448_().m_20185_() - this.m_20185_();
                double f1 = this.m_5448_().m_20227_(0.3333333333333333) - coralThornEntity.m_20186_();
                double f2 = this.m_5448_().m_20189_() - this.m_20189_();
                double f3 = Math.sqrt(f0 * f0 + f2 * f2);
                double x = d1 * Math.cos(angle) + d3 * Math.sin(angle);
                double z = -d1 * Math.sin(angle) + d3 * Math.cos(angle);
                coralThornEntity.m_6686_(x, f1 + f3 * (double)0.2f, z, 1.5f, 16 - this.m_9236_().m_46791_().m_19028_() * 4);
                this.m_9236_().m_7967_((Entity)coralThornEntity);
            }
        }
    }

    public void coralThornFive() {
        if (this.m_5448_() != null) {
            int count = 6;
            double offsetangle = Math.toRadians(15.0);
            double d1 = this.m_5448_().m_20185_() - this.m_20185_();
            double d2 = this.m_5448_().m_20186_() - this.m_20186_();
            double d3 = this.m_5448_().m_20189_() - this.m_20189_();
            for (int i = 0; i <= count - 1; ++i) {
                double angle = (double)(i - (count - 1) / 4) * offsetangle;
                CoralThornEntity coralThornEntity = new CoralThornEntity(this.m_9236_(), (LivingEntity)this, null);
                double f0 = this.m_5448_().m_20185_() - this.m_20185_();
                double f1 = this.m_5448_().m_20227_(0.3333333333333333) - coralThornEntity.m_20186_();
                double f2 = this.m_5448_().m_20189_() - this.m_20189_();
                double f3 = Math.sqrt(f0 * f0 + f2 * f2);
                double x = d1 * Math.cos(angle) + d3 * Math.sin(angle);
                double z = -d1 * Math.sin(angle) + d3 * Math.cos(angle);
                coralThornEntity.m_6686_(x, f1 + f3 * (double)0.2f, z, 1.5f, 16 - this.m_9236_().m_46791_().m_19028_() * 4);
                this.m_9236_().m_7967_((Entity)coralThornEntity);
            }
        }
    }

    @Deprecated
    public static boolean canDestroy(BlockState p_31492_) {
        return !p_31492_.m_60795_() && !p_31492_.m_204336_(BlockTags.f_13070_);
    }

    public void breakBlock() {
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            int j1 = Mth.m_14107_((double)this.m_20186_());
            int i2 = Mth.m_14107_((double)this.m_20185_());
            int j2 = Mth.m_14107_((double)this.m_20189_());
            boolean flag = false;
            for (int j = -1; j <= 1; ++j) {
                for (int k2 = -1; k2 <= 1; ++k2) {
                    for (int k = 0; k <= 4; ++k) {
                        int l2 = i2 + j;
                        int l = j1 + k;
                        int i1 = j2 + k2;
                        BlockPos blockpos = new BlockPos(l2, l, i1);
                        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                        if (!blockstate.canEntityDestroy((BlockGetter)this.m_9236_(), blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                        flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
                    }
                }
            }
            if (flag) {
                this.m_9236_().m_5898_((Player)null, 1022, this.m_20183_(), 0);
            }
        }
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return null;
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new CoralThornComboGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new CoralThornGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new BiteAttackGoal());
        this.f_21346_.m_25352_(0, (Goal)new ComboAttackGoal());
        this.f_21346_.m_25352_(0, (Goal)new RightClawAttackGoal());
        this.f_21346_.m_25352_(0, (Goal)new BulldrogiothMeleeAttackGoal());
        this.f_21345_.m_25352_(5, (Goal)new BulldrogiothGoToBeachGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new BulldrogiothSwimUpGoal(this, 1.3, this.m_9236_().m_5736_()));
        this.f_21345_.m_25352_(8, (Goal)new MobAIFindWater((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new MobAILeaveWater((PathfinderMob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7, 25, true));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.4f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.1));
        }
        if (this.attackID != 0) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            travelVector = Vec3.f_82478_;
            super.m_7023_(travelVector);
            return;
        }
        super.m_7023_(travelVector);
    }

    public void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21344_ = new GroundPathNavigatorWide((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21344_ = new SemiAquaticPathNavigator((Mob)this, this.m_9236_());
            this.isLandNavigator = false;
        }
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean m_6914_(LevelReader p_32829_) {
        return p_32829_.m_45784_((Entity)this);
    }

    private void strongKnockback(Entity p_33340_) {
        double d0 = p_33340_.m_20185_() - this.m_20185_();
        double d1 = p_33340_.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_33340_.m_5997_(d0 / d2 * 2.0, 0.2, d1 / d2 * 2.0);
    }

    public void setSearchingForLand(boolean p_32399_) {
        this.searchingForLand = p_32399_;
    }

    protected boolean closeToNextPos() {
        double d0;
        BlockPos blockpos;
        Path path = this.m_21573_().m_26570_();
        return path != null && (blockpos = path.m_77406_()) != null && (d0 = this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_())) < 4.0;
    }

    static class BulldrogiothMoveControl
    extends MoveControl {
        private final BulldrogiothEntity bulldrogiothEntity;

        public BulldrogiothMoveControl(BulldrogiothEntity p_32433_) {
            super((Mob)p_32433_);
            this.bulldrogiothEntity = p_32433_;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.bulldrogiothEntity.m_5448_();
            if (this.bulldrogiothEntity.wantsToSwim() && this.bulldrogiothEntity.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.bulldrogiothEntity.m_20186_() || this.bulldrogiothEntity.searchingForLand) {
                    this.bulldrogiothEntity.m_20256_(this.bulldrogiothEntity.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.bulldrogiothEntity.m_21573_().m_26571_()) {
                    this.bulldrogiothEntity.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.bulldrogiothEntity.m_20185_();
                double d1 = this.f_24976_ - this.bulldrogiothEntity.m_20186_();
                double d2 = this.f_24977_ - this.bulldrogiothEntity.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.bulldrogiothEntity.m_146922_(this.m_24991_(this.bulldrogiothEntity.m_146908_(), f, 90.0f));
                this.bulldrogiothEntity.f_20883_ = this.bulldrogiothEntity.m_146908_();
                float f1 = (float)(this.f_24978_ * this.bulldrogiothEntity.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.bulldrogiothEntity.m_6113_(), (float)f1);
                this.bulldrogiothEntity.m_7910_(f2);
                this.bulldrogiothEntity.m_20256_(this.bulldrogiothEntity.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.bulldrogiothEntity.m_20096_()) {
                    this.bulldrogiothEntity.m_20256_(this.bulldrogiothEntity.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }

    class CoralThornComboGoal
    extends Goal {
        private final BulldrogiothEntity mob;
        private LivingEntity attackTarget;

        public CoralThornComboGoal(BulldrogiothEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.attackTarget = BulldrogiothEntity.this.m_5448_();
            return this.attackTarget != null && BulldrogiothEntity.this.attackID == 0 && BulldrogiothEntity.this.m_20270_((Entity)this.attackTarget) <= 1024.0f && BulldrogiothEntity.this.f_19796_.m_188503_(16) == 0 && BulldrogiothEntity.this.coralthorncomboCooldown == 0 && this.mob.m_21223_() <= this.mob.m_21233_() / 2.0f;
        }

        public void m_8056_() {
            BulldrogiothEntity.this.setRight(BulldrogiothEntity.this.f_19796_.m_188503_(2) != 0);
            BulldrogiothEntity.this.setAttackID(6);
        }

        public void m_8041_() {
            BulldrogiothEntity.this.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return BulldrogiothEntity.this.attacktick < 65;
        }

        public void m_8037_() {
            float f2;
            float f1;
            if (BulldrogiothEntity.this.attacktick == 20) {
                f1 = (float)Math.cos(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                f2 = (float)Math.sin(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                BulldrogiothEntity.this.m_5997_(f1 * 1.0f, 0.0, f2 * 1.0f);
            }
            if (BulldrogiothEntity.this.attacktick == 23) {
                BulldrogiothEntity.this.coralThornFive();
            }
            if (BulldrogiothEntity.this.attacktick == 39) {
                f1 = (float)Math.cos(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                f2 = (float)Math.sin(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                BulldrogiothEntity.this.m_5997_(f1 * 1.0f, 0.0, f2 * 1.0f);
            }
            if (BulldrogiothEntity.this.attacktick == 42) {
                BulldrogiothEntity.this.coralThornFive();
            }
        }
    }

    class CoralThornGoal
    extends Goal {
        private final BulldrogiothEntity mob;
        private LivingEntity attackTarget;

        public CoralThornGoal(BulldrogiothEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.attackTarget = BulldrogiothEntity.this.m_5448_();
            return this.attackTarget != null && BulldrogiothEntity.this.attackID == 0 && BulldrogiothEntity.this.m_20270_((Entity)this.attackTarget) <= 1024.0f && BulldrogiothEntity.this.f_19796_.m_188503_(8) == 0 && BulldrogiothEntity.this.coralthornCooldown == 0;
        }

        public void m_8056_() {
            BulldrogiothEntity.this.setRight(BulldrogiothEntity.this.f_19796_.m_188503_(2) != 0);
            BulldrogiothEntity.this.setAttackID(5);
        }

        public void m_8041_() {
            BulldrogiothEntity.this.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return BulldrogiothEntity.this.attacktick < 45;
        }

        public void m_8037_() {
            if (BulldrogiothEntity.this.attacktick == 20) {
                float f1 = (float)Math.cos(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                BulldrogiothEntity.this.m_5997_(f1 * 1.0f, 0.0, f2 * 1.0f);
            }
            if (BulldrogiothEntity.this.attacktick == 23) {
                BulldrogiothEntity.this.coralThorn();
            }
        }
    }

    class BiteAttackGoal
    extends Goal {
        private LivingEntity attackTarget;

        public BiteAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.attackTarget = BulldrogiothEntity.this.m_5448_();
            return this.attackTarget != null && BulldrogiothEntity.this.attackID == 0 && BulldrogiothEntity.this.m_20270_((Entity)this.attackTarget) <= 6.0f && BulldrogiothEntity.this.f_19796_.m_188503_(2) == 0 && BulldrogiothEntity.this.biteCooldown == 0;
        }

        public void m_8056_() {
            BulldrogiothEntity.this.setRight(BulldrogiothEntity.this.f_19796_.m_188503_(2) != 0);
            BulldrogiothEntity.this.setAttackID(4);
        }

        public void m_8041_() {
            BulldrogiothEntity.this.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return BulldrogiothEntity.this.attacktick < 36;
        }

        public void m_8037_() {
            if (BulldrogiothEntity.this.attacktick == 20) {
                float f1 = (float)Math.cos(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                BulldrogiothEntity.this.m_5997_((double)f1 * 1.5, 0.0, (double)f2 * 1.5);
            }
            if (BulldrogiothEntity.this.attacktick == 23) {
                BulldrogiothEntity.this.meleeattack();
                BulldrogiothEntity.this.breakBlock();
            }
            double dist = BulldrogiothEntity.this.m_20270_((Entity)this.attackTarget);
            if (BulldrogiothEntity.this.attacktick == 23 && dist <= 4.0 && this.attackTarget != null) {
                this.attackTarget.m_6469_(BulldrogiothEntity.this.m_269291_().m_269333_((LivingEntity)BulldrogiothEntity.this), (float)BulldrogiothEntity.this.m_21133_(Attributes.f_22281_) / 3.0f);
            }
        }
    }

    class ComboAttackGoal
    extends Goal {
        private LivingEntity attackTarget;

        public ComboAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.attackTarget = BulldrogiothEntity.this.m_5448_();
            return this.attackTarget != null && BulldrogiothEntity.this.attackID == 0 && (double)BulldrogiothEntity.this.m_20270_((Entity)this.attackTarget) <= 4.5 && BulldrogiothEntity.this.f_19796_.m_188503_(4) == 0 && BulldrogiothEntity.this.comboCooldown == 0;
        }

        public void m_8056_() {
            BulldrogiothEntity.this.setRight(BulldrogiothEntity.this.f_19796_.m_188503_(2) != 0);
            BulldrogiothEntity.this.setAttackID(3);
        }

        public void m_8041_() {
            BulldrogiothEntity.this.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return BulldrogiothEntity.this.attacktick < 60;
        }

        public void m_8037_() {
            float f2;
            float f1;
            double dist = BulldrogiothEntity.this.m_20270_((Entity)this.attackTarget);
            if (BulldrogiothEntity.this.attacktick == 25) {
                f1 = (float)Math.cos(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                f2 = (float)Math.sin(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                BulldrogiothEntity.this.m_5997_((double)f1 * 0.4, 0.0, (double)f2 * 0.4);
            }
            if (BulldrogiothEntity.this.attacktick == 28) {
                BulldrogiothEntity.this.rightClaw();
                BulldrogiothEntity.this.breakBlock();
            }
            if (BulldrogiothEntity.this.attacktick == 40) {
                f1 = (float)Math.cos(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                f2 = (float)Math.sin(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                BulldrogiothEntity.this.m_5997_((double)f1 * 0.4, 0.0, (double)f2 * 0.4);
            }
            if (BulldrogiothEntity.this.attacktick == 43) {
                BulldrogiothEntity.this.rightClaw();
                BulldrogiothEntity.this.breakBlock();
            }
            if (BulldrogiothEntity.this.attacktick == 28 && dist <= 4.0 && this.attackTarget != null) {
                this.attackTarget.m_6469_(BulldrogiothEntity.this.m_269291_().m_269333_((LivingEntity)BulldrogiothEntity.this), (float)BulldrogiothEntity.this.m_21133_(Attributes.f_22281_) / 2.0f);
            }
            if (BulldrogiothEntity.this.attacktick == 43 && dist <= 4.0 && this.attackTarget != null) {
                this.attackTarget.m_6469_(BulldrogiothEntity.this.m_269291_().m_269333_((LivingEntity)BulldrogiothEntity.this), (float)BulldrogiothEntity.this.m_21133_(Attributes.f_22281_) / 2.0f);
            }
        }
    }

    class RightClawAttackGoal
    extends Goal {
        private LivingEntity attackTarget;

        public RightClawAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.attackTarget = BulldrogiothEntity.this.m_5448_();
            return this.attackTarget != null && BulldrogiothEntity.this.attackID == 2;
        }

        public void m_8056_() {
            BulldrogiothEntity.this.setRight(BulldrogiothEntity.this.f_19796_.m_188503_(2) != 0);
            BulldrogiothEntity.this.setAttackID(2);
        }

        public void m_8041_() {
            BulldrogiothEntity.this.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return BulldrogiothEntity.this.attacktick < 36;
        }

        public void m_8037_() {
            double dist = BulldrogiothEntity.this.m_20270_((Entity)this.attackTarget);
            if (BulldrogiothEntity.this.attackID == 2) {
                float f2;
                float f1;
                if (BulldrogiothEntity.this.attacktick == 17) {
                    f1 = (float)Math.cos(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                    f2 = (float)Math.sin(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                    BulldrogiothEntity.this.m_5997_((double)f1 * -0.2, 0.0, (double)f2 * 0.2);
                }
                if (BulldrogiothEntity.this.attacktick == 20) {
                    f1 = (float)Math.cos(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                    f2 = (float)Math.sin(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                    BulldrogiothEntity.this.m_5997_((double)f1 * 0.4, 0.0, (double)f2 * 0.4);
                }
                if (BulldrogiothEntity.this.attacktick == 23) {
                    BulldrogiothEntity.this.rightClaw();
                    BulldrogiothEntity.this.breakBlock();
                }
            }
            if (BulldrogiothEntity.this.attacktick == 23 && dist <= 4.0 && this.attackTarget != null) {
                this.attackTarget.m_6469_(BulldrogiothEntity.this.m_269291_().m_269333_((LivingEntity)BulldrogiothEntity.this), (float)BulldrogiothEntity.this.m_21133_(Attributes.f_22281_) / 2.0f);
            }
        }
    }

    class BulldrogiothMeleeAttackGoal
    extends Goal {
        private LivingEntity attackTarget;

        public BulldrogiothMeleeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.attackTarget = BulldrogiothEntity.this.m_5448_();
            return this.attackTarget != null && BulldrogiothEntity.this.attackID == 1;
        }

        public void m_8056_() {
            BulldrogiothEntity.this.setAttackID(1);
        }

        public void m_8041_() {
            BulldrogiothEntity.this.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return BulldrogiothEntity.this.attacktick < 45;
        }

        public void m_8037_() {
            if (BulldrogiothEntity.this.attacktick < 45 && this.attackTarget.m_6084_()) {
                BulldrogiothEntity.this.m_21391_((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (BulldrogiothEntity.this.attacktick == 29) {
                float f1 = (float)Math.cos(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(BulldrogiothEntity.this.m_146908_() + 90.0f));
                BulldrogiothEntity.this.m_5997_(f1 * 1.0f, 0.0, f2 * 1.0f);
            }
            if (BulldrogiothEntity.this.attacktick == 32) {
                BulldrogiothEntity.this.breakBlock();
                BulldrogiothEntity.this.meleeattack();
                ScreenShakeEntity.ScreenShake(BulldrogiothEntity.this.m_9236_(), BulldrogiothEntity.this.m_20182_(), 5.0f, 0.4f, 5, 3);
                BulldrogiothEntity.this.m_5496_(SoundEvents.f_12555_, 1.0f, 1.0f);
            }
            double dist = BulldrogiothEntity.this.m_20270_((Entity)this.attackTarget);
            if (BulldrogiothEntity.this.attacktick == 32 && dist <= 4.0 && this.attackTarget != null) {
                Player player;
                BulldrogiothEntity.this.strongKnockback((Entity)this.attackTarget);
                this.attackTarget.m_6469_(BulldrogiothEntity.this.m_269291_().m_269333_((LivingEntity)BulldrogiothEntity.this), (float)BulldrogiothEntity.this.m_21133_(Attributes.f_22281_));
                if (!this.attackTarget.m_6469_(BulldrogiothEntity.this.m_269291_().m_269333_((LivingEntity)BulldrogiothEntity.this), (float)BulldrogiothEntity.this.m_21133_(Attributes.f_22281_)) && BulldrogiothEntity.this.m_5448_() instanceof Player && (player = (Player)BulldrogiothEntity.this.m_5448_()).m_21254_()) {
                    player.m_36384_(true);
                }
            }
        }
    }

    static class BulldrogiothGoToBeachGoal
    extends MoveToBlockGoal {
        private final BulldrogiothEntity bulldrogiothEntity;

        public BulldrogiothGoToBeachGoal(BulldrogiothEntity p_32409_, double p_32410_) {
            super((PathfinderMob)p_32409_, p_32410_, 8, 2);
            this.bulldrogiothEntity = p_32409_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.bulldrogiothEntity.m_9236_().m_46471_() && this.bulldrogiothEntity.m_20069_() && this.bulldrogiothEntity.m_20186_() >= (double)(this.bulldrogiothEntity.m_9236_().m_5736_() - 3);
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected boolean m_6465_(LevelReader p_32413_, BlockPos p_32414_) {
            BlockPos blockpos = p_32414_.m_7494_();
            return p_32413_.m_46859_(blockpos) && p_32413_.m_46859_(blockpos.m_7494_()) ? p_32413_.m_8055_(p_32414_).m_60634_((BlockGetter)p_32413_, p_32414_, (Entity)this.bulldrogiothEntity) : false;
        }

        public void m_8056_() {
            this.bulldrogiothEntity.setSearchingForLand(false);
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class BulldrogiothSwimUpGoal
    extends Goal {
        private final BulldrogiothEntity bulldrogiothEntity;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public BulldrogiothSwimUpGoal(BulldrogiothEntity p_32440_, double p_32441_, int p_32442_) {
            this.bulldrogiothEntity = p_32440_;
            this.speedModifier = p_32441_;
            this.seaLevel = p_32442_;
        }

        public boolean m_8036_() {
            return (this.bulldrogiothEntity.m_9236_().m_46471_() || this.bulldrogiothEntity.m_20069_()) && this.bulldrogiothEntity.m_20186_() < (double)(this.seaLevel - 2);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.bulldrogiothEntity.m_20186_() < (double)(this.seaLevel - 1) && (this.bulldrogiothEntity.m_21573_().m_26571_() || this.bulldrogiothEntity.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.bulldrogiothEntity, (int)4, (int)8, (Vec3)new Vec3(this.bulldrogiothEntity.m_20185_(), (double)(this.seaLevel - 1), this.bulldrogiothEntity.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.bulldrogiothEntity.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            this.bulldrogiothEntity.setSearchingForLand(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.bulldrogiothEntity.setSearchingForLand(false);
        }
    }
}

