/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.config;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.sonmok14.fromtheshadows.server.Fromtheshadows;
import net.sonmok14.fromtheshadows.server.config.DefaultBiomes;
import net.sonmok14.fromtheshadows.server.config.SpawnBiomeConfig;
import net.sonmok14.fromtheshadows.server.world.biome.SpawnBiomeData;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeConfig {
    public static final Pair<String, SpawnBiomeData> bulldrogith = Pair.of((Object)"fromtheshadows:bulldrogith_spawns", (Object)DefaultBiomes.BULLDROGIOTH);
    public static final Pair<String, SpawnBiomeData> nehemoth = Pair.of((Object)"fromtheshadows:nehemoth_spawns", (Object)DefaultBiomes.NEHEMOTH);
    public static final Pair<String, SpawnBiomeData> murlock = Pair.of((Object)"fromtheshadows:froglin_spawns", (Object)DefaultBiomes.MURLOCK);
    private static boolean init = false;
    private static final Map<String, SpawnBiomeData> biomeConfigValues = new HashMap<String, SpawnBiomeData>();

    public static void init() {
        try {
            for (Field f : BiomeConfig.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Pair)) continue;
                String id = (String)((Pair)obj).getLeft();
                SpawnBiomeData data = (SpawnBiomeData)((Pair)obj).getRight();
                biomeConfigValues.put(id, SpawnBiomeConfig.create(new ResourceLocation(id), data));
            }
        }
        catch (Exception e) {
            Fromtheshadows.LOGGER.warn("Encountered error building from the shadows biome config .json files");
            e.printStackTrace();
        }
        init = true;
    }

    public static boolean test(Pair<String, SpawnBiomeData> entry, Holder<Biome> biome, ResourceLocation name) {
        if (!init) {
            return false;
        }
        return biomeConfigValues.get(entry.getKey()).matches(biome, name);
    }

    public static boolean test(Pair<String, SpawnBiomeData> spawns, Holder<Biome> biome) {
        return BiomeConfig.test(spawns, biome, ForgeRegistries.BIOMES.getKey((Object)((Biome)biome.m_203334_())));
    }
}

