/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.sonmok14.fromtheshadows.client.ClientEvents;
import net.sonmok14.fromtheshadows.client.particle.BloodParticle;
import net.sonmok14.fromtheshadows.client.renderer.BulldrogiothRenderer;
import net.sonmok14.fromtheshadows.client.renderer.ClericRenderer;
import net.sonmok14.fromtheshadows.client.renderer.CoralThornRenderer;
import net.sonmok14.fromtheshadows.client.renderer.DoomBreathRenderer;
import net.sonmok14.fromtheshadows.client.renderer.FroglinRenderer;
import net.sonmok14.fromtheshadows.client.renderer.FroglinVomitRenderer;
import net.sonmok14.fromtheshadows.client.renderer.NehemothRenderer;
import net.sonmok14.fromtheshadows.client.renderer.PlayerBreathRenderer;
import net.sonmok14.fromtheshadows.client.renderer.RendererNull;
import net.sonmok14.fromtheshadows.client.renderer.ThrowingDaggerRenderer;
import net.sonmok14.fromtheshadows.client.sound.NehemothSound;
import net.sonmok14.fromtheshadows.server.CommonProxy;
import net.sonmok14.fromtheshadows.server.Fromtheshadows;
import net.sonmok14.fromtheshadows.server.entity.NehemothEntity;
import net.sonmok14.fromtheshadows.server.utils.registry.EntityRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.ItemRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.ParticleRegistry;

public class ClientProxy
extends CommonProxy {
    public static final Int2ObjectMap<AbstractTickableSoundInstance> ENTITY_SOUND_INSTANCE_MAP = new Int2ObjectOpenHashMap();

    @Override
    public void commonInit() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::registry);
    }

    @Override
    public void clientInit() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.THROWING_DAGGER.get()), ThrowingDaggerRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.CORAL_THORN.get()), CoralThornRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.BULLDROGIOTH.get()), BulldrogiothRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.FROGLIN_VOMIT.get()), FroglinVomitRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.FROGLIN.get()), FroglinRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.DOOM_BREATH.get()), DoomBreathRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.PLAYER_BREATH.get()), PlayerBreathRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.CLERIC.get()), ClericRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.NEHEMOTH.get()), NehemothRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.SCREEN_SHAKE.get()), RendererNull::new);
        try {
            ItemProperties.register((Item)((Item)ItemRegistry.THIRST_FOR_BLOOD.get()), (ResourceLocation)new ResourceLocation("using"), (stack, p_2394211, p_2394212, j) -> p_2394212 != null && p_2394212.m_6117_() && p_2394212.m_21211_() == stack ? 1.0f : 0.0f);
        }
        catch (Exception e) {
            Fromtheshadows.LOGGER.warn("Could not load item models for weapons");
        }
    }

    public void registry(RegisterParticleProvidersEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleRegistry.BLOOD.get(), BloodParticle.Provider::new);
    }

    @Override
    public void playWorldSound(@Nullable Object soundEmitter, byte type) {
        if (soundEmitter instanceof Entity) {
            Entity entity = (Entity)soundEmitter;
            if (!entity.m_9236_().f_46443_) {
                return;
            }
        }
        switch (type) {
            case 1: {
                NehemothSound sound;
                NehemothSound nehemothSound;
                if (!(soundEmitter instanceof NehemothEntity)) break;
                NehemothEntity nehemoth = (NehemothEntity)((Object)soundEmitter);
                AbstractTickableSoundInstance old = (AbstractTickableSoundInstance)ENTITY_SOUND_INSTANCE_MAP.get(nehemoth.m_19879_());
                if (old == null || !(old instanceof NehemothSound) || !(nehemothSound = (NehemothSound)old).isSameEntity(nehemoth)) {
                    sound = new NehemothSound(nehemoth);
                    ENTITY_SOUND_INSTANCE_MAP.put(nehemoth.m_19879_(), (Object)sound);
                } else {
                    sound = (NehemothSound)old;
                }
                if (Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)sound) || !sound.m_7767_()) break;
                Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)sound);
            }
        }
    }

    @Override
    public void clearSoundCacheFor(Entity entity) {
        ENTITY_SOUND_INSTANCE_MAP.remove(entity.m_19879_());
    }
}

