/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.item.custom;

import java.util.List;
import net.miauczel.legendary_monsters.entity.custom.ModArmorItem;
import net.miauczel.legendary_monsters.item.custom.ModArmorMaterials;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="legendary_monsters", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MossyChestplateItem
extends ArmorItem {
    private static final MobEffectInstance MOSSY_ARMOR_EFFECT = new MobEffectInstance(MobEffects.f_19611_, 200, 1, false, false, true);

    public MossyChestplateItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack chestplateItemStack;
        Player player;
        if (event.phase == TickEvent.Phase.START && !(player = event.player).m_9236_().m_5776_() && !(chestplateItemStack = (ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.CHEST.m_20749_())).m_41619_() && chestplateItemStack.m_41720_() instanceof MossyChestplateItem) {
            if (MossyChestplateItem.hasMossyChestplate(player)) {
                MossyChestplateItem.addMossyArmorEffect(player);
            } else {
                MossyChestplateItem.removePoisonEffect(player);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && !event.getEntity().m_9236_().m_5776_() && MossyChestplateItem.hasMossyChestplate(player = (Player)event.getEntity())) {
            MossyChestplateItem.removePoisonEffect(player);
        }
    }

    private static boolean hasMossyChestplate(Player player) {
        ItemStack chestplateStack = (ItemStack)player.m_150109_().f_35975_.get(2);
        return !chestplateStack.m_41619_() && chestplateStack.m_41720_() instanceof ModArmorItem && ((ModArmorItem)chestplateStack.m_41720_()).m_40401_() == ModArmorMaterials.MOSSY;
    }

    private static void addMossyArmorEffect(Player player) {
        boolean hasPlayerEffect = player.m_21023_(MOSSY_ARMOR_EFFECT.m_19544_());
        if (!hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(MOSSY_ARMOR_EFFECT));
        }
    }

    private static void removePoisonEffect(Player player) {
        MobEffectInstance poisonEffect = new MobEffectInstance(MobEffects.f_19614_);
        if (player.m_21023_(poisonEffect.m_19544_())) {
            player.m_21195_(poisonEffect.m_19544_());
        }
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237113_((String)"\u00a76SPECIAL ABILITY: \u00a76\u00a7l[MOSSY PROTECTION] \u00a76 this chestplate protects player"));
        list.add((Component)Component.m_237113_((String)"\u00a76 from poison effect."));
    }
}

