/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import net.miauczel.legendary_monsters.entity.ai.Withered_AbominationAttackGoal;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Withered_AbominationEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Withered_AbominationEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int cooldown = 0;
    private static final int COOLDOWN_DURATION = 40;
    private static final float MAX_ROTATION = 0.0f;
    private static final float ROTATION_SPEED = 0.2f;
    private static final double HITBOX_RADIUS = 3.0;
    private static final double HITBOX_HEIGHT = 2.0;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    private float prevYaw;

    public Withered_AbominationEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
        this.m_21557_(false);
        this.m_21530_();
        this.m_21530_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 31;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new Withered_AbominationAttackGoal((PathfinderMob)this, 3.0, true));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 3.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Hoglin.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, PiglinBrute.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_8107_() {
        super.m_8107_();
        LivingEntity target = this.m_5448_();
        if (target != null) {
            double targetX = target.m_20185_() - this.m_20185_();
            double targetY = target.m_20188_() - this.m_20188_();
            double targetZ = target.m_20189_() - this.m_20189_();
            double horizontalDistance = Math.sqrt(targetX * targetX + targetZ * targetZ);
            float yaw = (float)(Math.atan2(targetZ, targetX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(targetY, horizontalDistance) * 57.29577951308232));
            this.f_20885_ = this.f_20883_ = yaw;
            this.f_20883_ = pitch;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 13.0);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.WITHERED_ABOMINATION_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WITHERED_ABOMINATION_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        ItemStack diamond = new ItemStack((ItemLike)ModItems.WITHERED_BONE.get(), 2);
        ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
        emerald = this.getItemWithLootingEnchant(emerald, source.m_7639_());
        this.m_19983_(diamond);
        this.m_19983_(emerald);
    }

    private ItemStack getItemWithLootingEnchant(ItemStack stack, Entity killer) {
        int lootingLevel;
        if (killer instanceof Player && (lootingLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44982_, (LivingEntity)((LivingEntity)killer))) > 0) {
            stack.m_41769_(lootingLevel);
        }
        return stack;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }
}

