/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.ai;

import net.miauczel.legendary_monsters.entity.custom.Shulker_MimicEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;

public class Shulker_MimicAttackGoal
extends MeleeAttackGoal {
    private final Shulker_MimicEntity entity;
    private int attackDelay = 12;
    private int ticksUntilNextAttack = 12;
    private boolean shouldCountTillNextAttack = false;
    private boolean hasPlayedAttackSound = false;

    public Shulker_MimicAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (Shulker_MimicEntity)pMob;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackDelay = 12;
        this.ticksUntilNextAttack = 12;
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation() && !this.hasPlayedAttackSound) {
                this.f_25540_.m_9236_().m_5594_(null, this.f_25540_.m_20183_(), SoundEvents.f_11865_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.entity.setAttacking(true);
                this.hasPlayedAttackSound = true;
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.hasPlayedAttackSound = false;
                this.performAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            this.entity.setAttacking(false);
            this.entity.attackAnimationTimeout = 5;
            this.hasPlayedAttackSound = false;
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        return pDistToEnemySqr <= 24.0;
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(this.attackDelay * 2);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        Player player;
        this.m_25563_();
        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
        this.f_25540_.m_7327_((Entity)pEnemy);
        if (this.f_25540_.m_5448_() != null && !this.f_25540_.m_5448_().m_21254_() && this.entity.m_217043_().m_188501_() < 0.75f) {
            this.f_25540_.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19620_, 40, 2));
        }
        if (this.f_25540_.m_5448_().m_21023_(MobEffects.f_19620_)) {
            // empty if block
        }
        if (pEnemy instanceof Player && (player = (Player)pEnemy).m_21254_() && (player.m_21205_().m_41720_() instanceof ShieldItem || player.m_21206_().m_41720_() instanceof ShieldItem)) {
            Item shieldItem;
            Item item = shieldItem = player.m_21205_().m_41720_() instanceof ShieldItem ? player.m_21205_().m_41720_() : player.m_21206_().m_41720_();
            if (!player.m_36335_().m_41519_(shieldItem)) {
                player.m_36335_().m_41524_(shieldItem, 40);
                if (player.m_21254_()) {
                    player.m_5810_();
                }
            }
        }
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public void m_8041_() {
        this.entity.setAttacking(false);
        super.m_8041_();
        this.hasPlayedAttackSound = false;
    }
}

