/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters;

import com.mojang.logging.LogUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.client.ChoruslingRenderer;
import net.miauczel.legendary_monsters.entity.client.EndersentRenderer;
import net.miauczel.legendary_monsters.entity.client.Frostbitten_GolemRenderer;
import net.miauczel.legendary_monsters.entity.client.Lava_eaterRenderer;
import net.miauczel.legendary_monsters.entity.client.Overgrown_colossusRenderer;
import net.miauczel.legendary_monsters.entity.client.Shulker_MimicRenderer;
import net.miauczel.legendary_monsters.entity.client.SkeletosaurusRenderer;
import net.miauczel.legendary_monsters.entity.client.Warped_FungussusRenderer;
import net.miauczel.legendary_monsters.entity.client.Withered_AbominationRenderer;
import net.miauczel.legendary_monsters.item.ModCreativeModTabs;
import net.miauczel.legendary_monsters.item.ModItemProperties;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="legendary_monsters")
public class LegendaryMonsters {
    public static final String MOD_ID = "legendary_monsters";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static DamageSource EXTRA_DAMAGE;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue;

    public LegendaryMonsters() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModEntities.register(modEventBus);
        ModItems.register(modEventBus);
        ModCreativeModTabs.register(modEventBus);
        ModEffects.register(modEventBus);
        ModSounds.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.Skeletosaurus.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_));
        event.enqueueWork(() -> SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.Warped_Fungussus.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_));
        event.enqueueWork(() -> SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.Chorusling.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    static {
        workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();
    }

    @Mod.EventBusSubscriber(modid="legendary_monsters", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.Skeletosaurus.get()), SkeletosaurusRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.Overgrown_colossus.get()), Overgrown_colossusRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.Endersent.get()), EndersentRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.Warped_Fungussus.get()), Warped_FungussusRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.Lava_eater.get()), Lava_eaterRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.Frostbitten_Golem.get()), Frostbitten_GolemRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.Shulker_Mimic.get()), Shulker_MimicRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.Chorusling.get()), ChoruslingRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.Withered_Abomination.get()), Withered_AbominationRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.CHORUS_BOMB.get()), ThrownItemRenderer::new);
            ModItemProperties.addCustomItemProperties();
        }
    }
}

