/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.common;

import cofh.thermal.core.item.SatchelItem;
import cofh.thermal.core.tileentity.device.DeviceFisherTile;
import cofh.thermal.core.tileentity.device.DeviceTreeExtractorTile;
import cofh.thermal.core.util.managers.dynamo.CompressionFuelManager;
import cofh.thermal.core.util.managers.dynamo.DisenchantmentFuelManager;
import cofh.thermal.core.util.managers.dynamo.GourmandFuelManager;
import cofh.thermal.core.util.managers.dynamo.LapidaryFuelManager;
import cofh.thermal.core.util.managers.dynamo.MagmaticFuelManager;
import cofh.thermal.core.util.managers.dynamo.NumismaticFuelManager;
import cofh.thermal.core.util.managers.dynamo.StirlingFuelManager;
import cofh.thermal.core.util.managers.machine.BottlerRecipeManager;
import cofh.thermal.core.util.managers.machine.BrewerRecipeManager;
import cofh.thermal.core.util.managers.machine.CentrifugeRecipeManager;
import cofh.thermal.core.util.managers.machine.ChillerRecipeManager;
import cofh.thermal.core.util.managers.machine.CrafterRecipeManager;
import cofh.thermal.core.util.managers.machine.CrucibleRecipeManager;
import cofh.thermal.core.util.managers.machine.FurnaceRecipeManager;
import cofh.thermal.core.util.managers.machine.InsolatorRecipeManager;
import cofh.thermal.core.util.managers.machine.PressRecipeManager;
import cofh.thermal.core.util.managers.machine.PulverizerRecipeManager;
import cofh.thermal.core.util.managers.machine.PyrolyzerRecipeManager;
import cofh.thermal.core.util.managers.machine.RefineryRecipeManager;
import cofh.thermal.core.util.managers.machine.SawmillRecipeManager;
import cofh.thermal.core.util.managers.machine.SmelterRecipeManager;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ThermalConfig {
    private static boolean registered = false;
    private static final ForgeConfigSpec.Builder SERVER_CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec.Builder CLIENT_CONFIG;
    private static ForgeConfigSpec clientSpec;
    public static final byte[] DEFAULT_MACHINE_SIDES_RAW;
    public static final byte[] DEFAULT_CELL_SIDES_RAW;
    public static int deviceAugments;
    public static int dynamoAugments;
    public static int machineAugments;
    public static int storageAugments;
    public static int toolAugments;
    public static boolean permanentLava;
    public static boolean permanentWater;
    public static ForgeConfigSpec.BooleanValue standaloneRedstoneFlux;
    public static ForgeConfigSpec.BooleanValue enableVillagerTrades;
    public static ForgeConfigSpec.BooleanValue enableWandererTrades;
    public static ForgeConfigSpec.BooleanValue keepEnergy;
    public static ForgeConfigSpec.BooleanValue keepItems;
    public static ForgeConfigSpec.BooleanValue keepFluids;
    public static ForgeConfigSpec.BooleanValue keepAugments;
    public static ForgeConfigSpec.BooleanValue keepRSControl;
    public static ForgeConfigSpec.BooleanValue keepSideConfig;
    public static ForgeConfigSpec.BooleanValue keepTransferControl;
    public static ForgeConfigSpec.BooleanValue flagReconfigSides;
    public static ForgeConfigSpec.BooleanValue flagRSControl;
    public static ForgeConfigSpec.BooleanValue flagXPStorage;
    private static ForgeConfigSpec.BooleanValue flagVanillaBlocks;
    private static ForgeConfigSpec.BooleanValue flagRockwool;
    private static ForgeConfigSpec.BooleanValue flagWrench;
    private static ForgeConfigSpec.BooleanValue flagRedprint;
    private static ForgeConfigSpec.BooleanValue flagRFPotato;
    private static ForgeConfigSpec.BooleanValue flagXPCrystal;
    private static ForgeConfigSpec.BooleanValue flagLock;
    private static ForgeConfigSpec.BooleanValue flagSatchel;
    private static ForgeConfigSpec.BooleanValue flagDetonator;
    private static ForgeConfigSpec.BooleanValue flagMobBasalz;
    private static ForgeConfigSpec.BooleanValue flagMobBlitz;
    private static ForgeConfigSpec.BooleanValue flagMobBlizz;
    private static ForgeConfigSpec.BooleanValue worldGenApatite;
    private static ForgeConfigSpec.BooleanValue worldGenCinnabar;
    private static ForgeConfigSpec.BooleanValue worldGenNiter;
    private static ForgeConfigSpec.BooleanValue worldGenSulfur;
    private static ForgeConfigSpec.BooleanValue worldGenCopper;
    private static ForgeConfigSpec.BooleanValue worldGenTin;
    private static ForgeConfigSpec.BooleanValue worldGenLead;
    private static ForgeConfigSpec.BooleanValue worldGenSilver;
    private static ForgeConfigSpec.BooleanValue worldGenNickel;
    private static ForgeConfigSpec.BooleanValue worldGenOil;
    private static ForgeConfigSpec.BooleanValue freezePermanentLava;
    private static ForgeConfigSpec.BooleanValue freezePermanentWater;
    private static ForgeConfigSpec.IntValue deviceTreeExtractorTimeConstant;
    private static ForgeConfigSpec.IntValue deviceFisherTimeConstant;
    private static ForgeConfigSpec.IntValue deviceFisherTimeReductionWater;
    private static ForgeConfigSpec.IntValue dynamoStirlingPower;
    private static ForgeConfigSpec.IntValue dynamoCompressionPower;
    private static ForgeConfigSpec.IntValue dynamoMagmaticPower;
    private static ForgeConfigSpec.IntValue dynamoNumismaticPower;
    private static ForgeConfigSpec.IntValue dynamoLapidaryPower;
    private static ForgeConfigSpec.IntValue dynamoDisenchantmentPower;
    private static ForgeConfigSpec.IntValue dynamoGourmandPower;
    private static ForgeConfigSpec.IntValue machineFurnacePower;
    private static ForgeConfigSpec.IntValue machineSawmillPower;
    private static ForgeConfigSpec.IntValue machinePulverizerPower;
    private static ForgeConfigSpec.IntValue machineSmelterPower;
    private static ForgeConfigSpec.IntValue machineInsolatorPower;
    private static ForgeConfigSpec.IntValue machineCentrifugePower;
    private static ForgeConfigSpec.IntValue machinePressPower;
    private static ForgeConfigSpec.IntValue machineCruciblePower;
    private static ForgeConfigSpec.IntValue machineChillerPower;
    private static ForgeConfigSpec.IntValue machineRefineryPower;
    private static ForgeConfigSpec.IntValue machinePyrolyzerPower;
    private static ForgeConfigSpec.IntValue machineBottlerPower;
    private static ForgeConfigSpec.IntValue machineBrewerPower;
    private static ForgeConfigSpec.IntValue machineCrafterPower;
    public static ForgeConfigSpec.ConfigValue<List<String>> satchelBans;
    public static boolean jeiBucketTanks;
    public static boolean blockAmbientSounds;
    public static boolean mobAmbientSounds;
    public static ForgeConfigSpec.BooleanValue flagBlockAmbientSounds;
    public static ForgeConfigSpec.BooleanValue flagMobAmbientSounds;

    public static void register() {
        if (registered) {
            return;
        }
        FMLJavaModLoadingContext.get().getModEventBus().register(ThermalConfig.class);
        registered = true;
        ThermalConfig.genClientConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    public static void setup() {
        ThermalConfig.genServerConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
    }

    private ThermalConfig() {
    }

    private static void genServerConfig() {
        SERVER_CONFIG.push("Global Options");
        standaloneRedstoneFlux = SERVER_CONFIG.comment("If TRUE, Redstone Flux will act as its own energy system and will NOT be interoperable with 'Forge Energy' - only enable this if you absolutely know what you are doing and want the Thermal Series to use a unique energy system.").define("Standalone Redstone Flux", false);
        keepEnergy = SERVER_CONFIG.comment("If TRUE, most Thermal Blocks will retain Energy when dropped.\nThis setting does not control ALL blocks.").define("Blocks Retain Energy", true);
        keepItems = SERVER_CONFIG.comment("If TRUE, most Thermal Blocks will retain Inventory Contents when dropped.\nThis setting does not control ALL blocks.").define("Blocks Retain Inventory", false);
        keepFluids = SERVER_CONFIG.comment("If TRUE, most Thermal Blocks will retain Tank Contents when dropped.\nThis setting does not control ALL blocks.").define("Blocks Retain Tank Contents", false);
        keepAugments = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Augments when dropped.").define("Blocks Retain Augments", true);
        keepRSControl = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Redstone Control configuration when dropped.").define("Blocks Retain Redstone Control", true);
        keepSideConfig = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Side configuration when dropped.").define("Blocks Retain Side Configuration", true);
        keepTransferControl = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Transfer Control configuration when dropped.").define("Blocks Retain Transfer Control", true);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Features");
        flagVanillaBlocks = SERVER_CONFIG.comment("If TRUE, various 'Vanilla+' Blocks and Recipes are enabled.").define("Vanilla+", true);
        flagRockwool = SERVER_CONFIG.comment("If TRUE, Rockwool Blocks and Recipes are enabled.").define("Rockwool", true);
        SERVER_CONFIG.push("Tools");
        flagWrench = SERVER_CONFIG.comment("If TRUE, the Crescent Hammer is enabled.").define("Wrench", true);
        flagRedprint = SERVER_CONFIG.comment("If TRUE, the Redprint is enabled.").define("Redprint", true);
        flagRFPotato = SERVER_CONFIG.comment("If TRUE, the Capacitato is enabled.").define("RF Potato", true);
        flagXPCrystal = SERVER_CONFIG.comment("If TRUE, the Insightful Crystal is enabled.").define("XP Crystal", true);
        flagLock = SERVER_CONFIG.comment("If TRUE, the Signalum Security Lock is enabled.").define("Lock", true);
        flagDetonator = SERVER_CONFIG.comment("If TRUE, the Remote Detonator is enabled.").define("Detonator", true);
        SERVER_CONFIG.push("Satchel");
        flagSatchel = SERVER_CONFIG.comment("If TRUE, the Satchel is enabled.").define("Satchel", true);
        String[] shulkerBoxes = new String[]{"thermal:satchel", Items.field_221970_gq.getRegistryName().toString(), Items.field_221972_gr.getRegistryName().toString(), Items.field_221974_gs.getRegistryName().toString(), Items.field_221976_gt.getRegistryName().toString(), Items.field_221978_gu.getRegistryName().toString(), Items.field_221980_gv.getRegistryName().toString(), Items.field_221982_gw.getRegistryName().toString(), Items.field_221984_gx.getRegistryName().toString(), Items.field_221986_gy.getRegistryName().toString(), Items.field_221988_gz.getRegistryName().toString(), Items.field_221885_gA.getRegistryName().toString(), Items.field_221887_gB.getRegistryName().toString(), Items.field_221889_gC.getRegistryName().toString(), Items.field_221891_gD.getRegistryName().toString(), Items.field_221893_gE.getRegistryName().toString(), Items.field_221895_gF.getRegistryName().toString(), Items.field_221897_gG.getRegistryName().toString()};
        satchelBans = SERVER_CONFIG.comment("A list of Items by Resource Location which are NOT allowed in Satchels.").define("Denylist", new ArrayList<String>(Arrays.asList(shulkerBoxes)));
        SERVER_CONFIG.pop(2);
        SERVER_CONFIG.push("Mobs");
        flagMobBasalz = SERVER_CONFIG.comment("If TRUE, the Basalz Mob is enabled.").define("Basalz", true);
        flagMobBlitz = SERVER_CONFIG.comment("If TRUE, the Blitz Mob is enabled.").define("Blitz", true);
        flagMobBlizz = SERVER_CONFIG.comment("If TRUE, the Blizz Mob is enabled.").define("Blizz", true);
        SERVER_CONFIG.pop(2);
        SERVER_CONFIG.push("Augments");
        flagReconfigSides = SERVER_CONFIG.comment("If TRUE, Side Reconfiguration is enabled by default on most augmentable blocks which support it.\nIf FALSE, an augment is required.\nThis setting does not control ALL blocks.").define("Default Side Reconfiguration", true);
        flagRSControl = SERVER_CONFIG.comment("If TRUE, Redstone Control is enabled by default on most augmentable blocks which support it.\nIf FALSE, an augment is required.\nThis setting does not control ALL blocks.").define("Default Redstone Control", true);
        flagXPStorage = SERVER_CONFIG.comment("If TRUE, XP Storage is enabled by default on most augmentable blocks which support it.\nIf FALSE, an augment is required.\nThis setting does not control ALL blocks.").define("Default XP Storage", false);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Villagers");
        enableVillagerTrades = SERVER_CONFIG.comment("If TRUE, trades will be added to various Villagers.").define("Enable Villager Trades", true);
        enableWandererTrades = SERVER_CONFIG.comment("If TRUE, trades will be added to the Wandering Trader.").define("Enable Wandering Trader Trades", true);
        SERVER_CONFIG.pop();
        ThermalConfig.genDeviceConfig();
        ThermalConfig.genDynamoConfig();
        ThermalConfig.genMachineConfig();
        ThermalConfig.genWorldConfig();
        serverSpec = SERVER_CONFIG.build();
        ThermalConfig.refreshServerConfig();
    }

    private static void genClientConfig() {
        CLIENT_CONFIG.push("Sounds");
        flagBlockAmbientSounds = CLIENT_CONFIG.comment("If TRUE, some 'Thermal Series' Blocks will have ambient sounds.").define("Ambient Block Sounds", true);
        flagMobAmbientSounds = CLIENT_CONFIG.comment("If TRUE, some 'Thermal Series' Mobs will have ambient sounds.").define("Ambient Mob Sounds", true);
        CLIENT_CONFIG.pop();
        clientSpec = CLIENT_CONFIG.build();
        ThermalConfig.refreshClientConfig();
    }

    private static void genWorldConfig() {
        SERVER_CONFIG.push("World Generation");
        worldGenApatite = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Apatite from generating.").define("Apatite", true);
        worldGenCinnabar = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Cinnabar from generating.").define("Cinnabar", true);
        worldGenNiter = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Niter from generating.").define("Niter", true);
        worldGenSulfur = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Sulfur from generating.").define("Sulfur", true);
        worldGenCopper = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Copper from generating.").define("Copper", true);
        worldGenTin = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Tin from generating.").define("Tin", true);
        worldGenLead = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Lead from generating.").define("Lead", true);
        worldGenSilver = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Silver from generating.").define("Silver", true);
        worldGenNickel = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Nickel from generating.").define("Nickel", true);
        worldGenOil = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Oil Sands from generating.").define("Oil", true);
        SERVER_CONFIG.pop();
    }

    private static void genDeviceConfig() {
        SERVER_CONFIG.push("Devices");
        if (ThermalFlags.getFlag("device_tree_extractor").getAsBoolean()) {
            SERVER_CONFIG.push("TreeExtractor");
            deviceTreeExtractorTimeConstant = SERVER_CONFIG.comment("This sets the base time constant (in ticks) for the Arboreal Extractor.").defineInRange("Time Constant", 500, 20, 72000);
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("device_fisher").getAsBoolean()) {
            SERVER_CONFIG.push("Fisher");
            deviceFisherTimeConstant = SERVER_CONFIG.comment("This sets the base time constant (in ticks) for the Aquatic Entangler.").defineInRange("Time Constant", 4800, 400, 72000);
            deviceFisherTimeReductionWater = SERVER_CONFIG.comment("This sets the time constant reduction (in ticks) per nearby Water source block for the Aquatic Entangler.").defineInRange("Water Source Time Constant Reduction", 20, 1, 1000);
            SERVER_CONFIG.pop();
        }
        SERVER_CONFIG.pop();
    }

    private static void genDynamoConfig() {
        SERVER_CONFIG.push("Dynamos");
        if (ThermalFlags.getFlag("dynamo_stirling").getAsBoolean()) {
            SERVER_CONFIG.push("Stirling");
            dynamoStirlingPower = SERVER_CONFIG.comment("This sets the base power generation (RF/t) for the Stirling Dynamo.").defineInRange("Base Power", StirlingFuelManager.instance().getBasePower(), StirlingFuelManager.instance().getMinPower(), StirlingFuelManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("dynamo_compression").getAsBoolean()) {
            SERVER_CONFIG.push("Compression");
            dynamoCompressionPower = SERVER_CONFIG.comment("This sets the base power generation (RF/t) for the Compression Dynamo.").defineInRange("Base Power", CompressionFuelManager.instance().getBasePower(), CompressionFuelManager.instance().getMinPower(), CompressionFuelManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("dynamo_magmatic").getAsBoolean()) {
            SERVER_CONFIG.push("Magmatic");
            dynamoMagmaticPower = SERVER_CONFIG.comment("This sets the base power generation (RF/t) for the Magmatic Dynamo.").defineInRange("Base Power", MagmaticFuelManager.instance().getBasePower(), MagmaticFuelManager.instance().getMinPower(), MagmaticFuelManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("dynamo_numismatic").getAsBoolean()) {
            SERVER_CONFIG.push("Numismatic");
            dynamoNumismaticPower = SERVER_CONFIG.comment("This sets the base power generation (RF/t) for the Numismatic Dynamo.").defineInRange("Base Power", NumismaticFuelManager.instance().getBasePower(), NumismaticFuelManager.instance().getMinPower(), NumismaticFuelManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("dynamo_lapidary").getAsBoolean()) {
            SERVER_CONFIG.push("Lapidary");
            dynamoLapidaryPower = SERVER_CONFIG.comment("This sets the base power generation (RF/t) for the Lapidary Dynamo.").defineInRange("Base Power", LapidaryFuelManager.instance().getBasePower(), LapidaryFuelManager.instance().getMinPower(), LapidaryFuelManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("dynamo_disenchantment").getAsBoolean()) {
            SERVER_CONFIG.push("Disenchantment");
            dynamoDisenchantmentPower = SERVER_CONFIG.comment("This sets the base power generation (RF/t) for the Disenchantment Dynamo.").defineInRange("Base Power", DisenchantmentFuelManager.instance().getBasePower(), DisenchantmentFuelManager.instance().getMinPower(), DisenchantmentFuelManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("dynamo_gourmand").getAsBoolean()) {
            SERVER_CONFIG.push("Gourmand");
            dynamoGourmandPower = SERVER_CONFIG.comment("This sets the base power generation (RF/t) for the Gourmand Dynamo.").defineInRange("Base Power", GourmandFuelManager.instance().getBasePower(), GourmandFuelManager.instance().getMinPower(), GourmandFuelManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        SERVER_CONFIG.pop();
    }

    private static void genMachineConfig() {
        SERVER_CONFIG.push("Machines");
        if (ThermalFlags.getFlag("machine_furnace").getAsBoolean()) {
            SERVER_CONFIG.push("Furnace");
            machineFurnacePower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Redstone Furnace.").defineInRange("Base Power", FurnaceRecipeManager.instance().getBasePower(), FurnaceRecipeManager.instance().getMinPower(), FurnaceRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_sawmill").getAsBoolean()) {
            SERVER_CONFIG.push("Sawmill");
            machineSawmillPower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Sawmill.").defineInRange("Base Power", SawmillRecipeManager.instance().getBasePower(), SawmillRecipeManager.instance().getMinPower(), SawmillRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_pulverizer").getAsBoolean()) {
            SERVER_CONFIG.push("Pulverizer");
            machinePulverizerPower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Pulverizer.").defineInRange("Base Power", PulverizerRecipeManager.instance().getBasePower(), PulverizerRecipeManager.instance().getMinPower(), PulverizerRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_smelter").getAsBoolean()) {
            SERVER_CONFIG.push("Smelter");
            machineSmelterPower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Induction Smelter.").defineInRange("Base Power", SmelterRecipeManager.instance().getBasePower(), SmelterRecipeManager.instance().getMinPower(), SmelterRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_insolator").getAsBoolean()) {
            SERVER_CONFIG.push("Insolator");
            machineInsolatorPower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Phytogenic Insolator.").defineInRange("Base Power", InsolatorRecipeManager.instance().getBasePower(), InsolatorRecipeManager.instance().getMinPower(), InsolatorRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_centrifuge").getAsBoolean()) {
            SERVER_CONFIG.push("Centrifuge");
            machineCentrifugePower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Centrifugal Separator.").defineInRange("Base Power", CentrifugeRecipeManager.instance().getBasePower(), CentrifugeRecipeManager.instance().getMinPower(), CentrifugeRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_press").getAsBoolean()) {
            SERVER_CONFIG.push("Press");
            machinePressPower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Multiservo Press.").defineInRange("Base Power", PressRecipeManager.instance().getBasePower(), PressRecipeManager.instance().getMinPower(), PressRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_crucible").getAsBoolean()) {
            SERVER_CONFIG.push("Crucible");
            machineCruciblePower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Magma Crucible.").defineInRange("Base Power", CrucibleRecipeManager.instance().getBasePower(), CrucibleRecipeManager.instance().getMinPower(), CrucibleRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_chiller").getAsBoolean()) {
            SERVER_CONFIG.push("Chiller");
            machineChillerPower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Blast Chiller.").defineInRange("Base Power", ChillerRecipeManager.instance().getBasePower(), ChillerRecipeManager.instance().getMinPower(), ChillerRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_furnace").getAsBoolean()) {
            SERVER_CONFIG.push("Refinery");
            machineRefineryPower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Fractionating Still.").defineInRange("Base Power", RefineryRecipeManager.instance().getBasePower(), RefineryRecipeManager.instance().getMinPower(), RefineryRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_pyrolyzer").getAsBoolean()) {
            SERVER_CONFIG.push("Pyrolyzer");
            machinePyrolyzerPower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Pyrolyzer.").defineInRange("Base Power", PyrolyzerRecipeManager.instance().getBasePower(), PyrolyzerRecipeManager.instance().getMinPower(), PyrolyzerRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_bottler").getAsBoolean()) {
            SERVER_CONFIG.push("Bottler");
            machineBottlerPower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Fluid Encapsulator.").defineInRange("Base Power", BottlerRecipeManager.instance().getBasePower(), BottlerRecipeManager.instance().getMinPower(), BottlerRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_brewer").getAsBoolean()) {
            SERVER_CONFIG.push("Brewer");
            machineBrewerPower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Alchemical Imbuer.").defineInRange("Base Power", BrewerRecipeManager.instance().getBasePower(), BrewerRecipeManager.instance().getMinPower(), BrewerRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("machine_crafter").getAsBoolean()) {
            SERVER_CONFIG.push("Crafter");
            machineCrafterPower = SERVER_CONFIG.comment("This sets the base power consumption (RF/t) for the Sequential Fabricator.").defineInRange("Base Power", CrafterRecipeManager.instance().getBasePower(), CrafterRecipeManager.instance().getMinPower(), CrafterRecipeManager.instance().getMaxPower());
            SERVER_CONFIG.pop();
        }
        SERVER_CONFIG.pop();
    }

    private static void refreshServerConfig() {
        ThermalEnergyHelper.standaloneRedstoneFlux = (Boolean)standaloneRedstoneFlux.get();
        ThermalFlags.setFlag(ThermalFlags.FLAG_VANILLA_BLOCKS, (Boolean)flagVanillaBlocks.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_ROCKWOOL, (Boolean)flagRockwool.get());
        ThermalFlags.setFlag("wrench", (Boolean)flagWrench.get());
        ThermalFlags.setFlag("redprint", (Boolean)flagRedprint.get());
        ThermalFlags.setFlag("rf_potato", (Boolean)flagRFPotato.get());
        ThermalFlags.setFlag("xp_crystal", (Boolean)flagXPCrystal.get());
        ThermalFlags.setFlag("lock", (Boolean)flagLock.get());
        ThermalFlags.setFlag("satchel", (Boolean)flagSatchel.get());
        ThermalFlags.setFlag("detonator", (Boolean)flagDetonator.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BASALZ, (Boolean)flagMobBasalz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BLITZ, (Boolean)flagMobBlitz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BLIZZ, (Boolean)flagMobBlizz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_SIDE_CONFIG_AUGMENT, (Boolean)flagReconfigSides.get() == false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_RS_CONTROL_AUGMENT, (Boolean)flagRSControl.get() == false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_XP_STORAGE_AUGMENT, (Boolean)flagXPStorage.get() == false);
        SatchelItem.setBannedItems((Collection)satchelBans.get());
        ThermalConfig.refreshDeviceConfig();
        ThermalConfig.refreshDynamoConfig();
        ThermalConfig.refreshMachineConfig();
        ThermalConfig.refreshWorldConfig();
    }

    private static void refreshDeviceConfig() {
        if (deviceTreeExtractorTimeConstant != null) {
            DeviceTreeExtractorTile.setTimeConstant((Integer)deviceTreeExtractorTimeConstant.get());
        }
        if (deviceFisherTimeConstant != null) {
            DeviceFisherTile.setTimeConstant((Integer)deviceFisherTimeConstant.get());
            DeviceFisherTile.setTimeReductionWater((Integer)deviceFisherTimeReductionWater.get());
        }
    }

    private static void refreshDynamoConfig() {
        if (dynamoStirlingPower != null) {
            StirlingFuelManager.instance().setBasePower((Integer)dynamoStirlingPower.get());
        }
        if (dynamoCompressionPower != null) {
            CompressionFuelManager.instance().setBasePower((Integer)dynamoCompressionPower.get());
        }
        if (dynamoMagmaticPower != null) {
            MagmaticFuelManager.instance().setBasePower((Integer)dynamoMagmaticPower.get());
        }
        if (dynamoNumismaticPower != null) {
            NumismaticFuelManager.instance().setBasePower((Integer)dynamoNumismaticPower.get());
        }
        if (dynamoLapidaryPower != null) {
            LapidaryFuelManager.instance().setBasePower((Integer)dynamoLapidaryPower.get());
        }
        if (dynamoDisenchantmentPower != null) {
            DisenchantmentFuelManager.instance().setBasePower((Integer)dynamoDisenchantmentPower.get());
        }
        if (dynamoGourmandPower != null) {
            GourmandFuelManager.instance().setBasePower((Integer)dynamoGourmandPower.get());
        }
    }

    private static void refreshMachineConfig() {
        if (machineFurnacePower != null) {
            FurnaceRecipeManager.instance().setBasePower((Integer)machineFurnacePower.get());
        }
        if (machineSawmillPower != null) {
            SawmillRecipeManager.instance().setBasePower((Integer)machineSawmillPower.get());
        }
        if (machinePulverizerPower != null) {
            PulverizerRecipeManager.instance().setBasePower((Integer)machinePulverizerPower.get());
        }
        if (machineSmelterPower != null) {
            SmelterRecipeManager.instance().setBasePower((Integer)machineSmelterPower.get());
        }
        if (machineInsolatorPower != null) {
            InsolatorRecipeManager.instance().setBasePower((Integer)machineInsolatorPower.get());
        }
        if (machineCentrifugePower != null) {
            CentrifugeRecipeManager.instance().setBasePower((Integer)machineCentrifugePower.get());
        }
        if (machinePressPower != null) {
            PressRecipeManager.instance().setBasePower((Integer)machinePressPower.get());
        }
        if (machineCruciblePower != null) {
            CrucibleRecipeManager.instance().setBasePower((Integer)machineCruciblePower.get());
        }
        if (machineChillerPower != null) {
            ChillerRecipeManager.instance().setBasePower((Integer)machineChillerPower.get());
        }
        if (machineRefineryPower != null) {
            RefineryRecipeManager.instance().setBasePower((Integer)machineRefineryPower.get());
        }
        if (machinePyrolyzerPower != null) {
            PyrolyzerRecipeManager.instance().setBasePower((Integer)machinePyrolyzerPower.get());
        }
        if (machineBottlerPower != null) {
            BottlerRecipeManager.instance().setBasePower((Integer)machineBottlerPower.get());
        }
        if (machineBrewerPower != null) {
            BrewerRecipeManager.instance().setBasePower((Integer)machineBrewerPower.get());
        }
        if (machineCrafterPower != null) {
            CrafterRecipeManager.instance().setBasePower((Integer)machineCrafterPower.get());
        }
    }

    private static void refreshWorldConfig() {
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_APATITE, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_APATITE).getAsBoolean() && (Boolean)worldGenApatite.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_CINNABAR, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_CINNABAR).getAsBoolean() && (Boolean)worldGenCinnabar.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_NITER, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NITER).getAsBoolean() && (Boolean)worldGenNiter.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_SULFUR, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SULFUR).getAsBoolean() && (Boolean)worldGenSulfur.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_COPPER, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_COPPER).getAsBoolean() && (Boolean)worldGenCopper.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_TIN, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN).getAsBoolean() && (Boolean)worldGenTin.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_LEAD, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD).getAsBoolean() && (Boolean)worldGenLead.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_SILVER, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER).getAsBoolean() && (Boolean)worldGenSilver.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_NICKEL, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL).getAsBoolean() && (Boolean)worldGenNickel.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_OIL, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_OIL).getAsBoolean() && (Boolean)worldGenOil.get() != false);
    }

    private static void refreshClientConfig() {
        blockAmbientSounds = (Boolean)flagBlockAmbientSounds.get();
        mobAmbientSounds = (Boolean)flagMobAmbientSounds.get();
    }

    @SubscribeEvent
    public static void configLoading(ModConfig.Loading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                ThermalConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                ThermalConfig.refreshServerConfig();
            }
        }
    }

    @SubscribeEvent
    public static void configReloading(ModConfig.Reloading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                ThermalConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                ThermalConfig.refreshServerConfig();
            }
        }
    }

    static {
        CLIENT_CONFIG = new ForgeConfigSpec.Builder();
        DEFAULT_MACHINE_SIDES_RAW = new byte[]{0, 0, 0, 0, 0, 0};
        DEFAULT_CELL_SIDES_RAW = new byte[]{0, 0, 0, 0, 0, 0};
        deviceAugments = 3;
        dynamoAugments = 4;
        machineAugments = 4;
        storageAugments = 3;
        toolAugments = 4;
        permanentLava = true;
        permanentWater = true;
        jeiBucketTanks = true;
        blockAmbientSounds = true;
        mobAmbientSounds = true;
    }
}

