/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.lib.block.impl.SoilBlock;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.tileentity.IAreaEffectTile;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DeviceSoilInfuserContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.ThermalTileAugmentable;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DeviceSoilInfuserTile
extends ThermalTileAugmentable
implements ITickableTileEntity,
IAreaEffectTile {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "RF", "Area");
    protected static final int BASE_PROCESS_MAX = 4000;
    protected ItemStorageCoFH chargeSlot = new ItemStorageCoFH(1, ThermalEnergyHelper::hasEnergyHandlerCap);
    protected static final int RADIUS = 2;
    protected int radius = 2;
    protected AxisAlignedBB area;
    protected int process;
    protected int processMax = 4000 * this.radius * this.radius;
    protected int processTick = this.getBaseProcessTick() / 4 * this.radius;

    public DeviceSoilInfuserTile() {
        super(TCoreReferences.DEVICE_SOIL_INFUSER_TILE);
        this.energyStorage = new EnergyStorageCoFH(this.getBaseEnergyStorage(), this.getBaseEnergyXfer());
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalConfig.deviceAugments);
        this.initHandlers();
    }

    public void func_73660_a() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.energyStorage.getEnergyStored() >= this.processTick) {
                this.process += this.processTick;
                this.energyStorage.modify(-this.processTick);
                if (this.process >= this.processMax) {
                    this.process -= this.processMax;
                    BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(-this.radius, -1, -this.radius), (BlockPos)this.field_174879_c.func_177982_a(this.radius, 1, this.radius)).forEach(this::chargeSoil);
                }
            } else {
                this.isActive = false;
            }
        } else if (this.redstoneControl.getState() && this.energyStorage.getEnergyStored() >= this.processTick) {
            this.isActive = true;
        }
        this.updateActiveState(curActive);
        this.chargeEnergy();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DeviceSoilInfuserContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Override
    public int getCurSpeed() {
        return this.isActive ? this.processTick : 0;
    }

    @Override
    public int getScaledProgress(int scale) {
        if (!this.isActive || this.processMax <= 0 || this.process <= 0) {
            return 0;
        }
        return scale * Math.min(this.process, this.processMax) / this.processMax;
    }

    @Override
    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.process);
        buffer.writeInt(this.processMax);
        buffer.writeInt(this.processTick);
        return buffer;
    }

    @Override
    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.process = buffer.readInt();
        this.processMax = buffer.readInt();
        this.processTick = buffer.readInt();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.process = nbt.func_74762_e("Proc");
        this.processMax = nbt.func_74762_e("ProcMax");
        this.processTick = nbt.func_74762_e("ProcTick");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Proc", this.process);
        nbt.func_74768_a("ProcMax", this.processMax);
        nbt.func_74768_a("ProcTick", this.processTick);
        return nbt;
    }

    public int getRadius() {
        return this.radius;
    }

    protected void chargeSoil(BlockPos blockPos) {
        BlockState state = this.field_145850_b.func_180495_p(blockPos);
        if (state.func_177230_c() instanceof SoilBlock) {
            SoilBlock.charge((BlockState)state, (World)this.field_145850_b, (BlockPos)blockPos);
        }
    }

    protected void chargeEnergy() {
        if (!this.chargeSlot.isEmpty()) {
            this.chargeSlot.getItemStack().getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(c -> this.energyStorage.receiveEnergy(c.extractEnergy(Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getSpace()), false), false));
        }
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.radius = 2;
    }

    @Override
    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.radius = (int)((float)this.radius + AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"Radius"));
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        float baseMod = AugmentableHelper.getAttributeModWithDefault((CompoundNBT)this.augmentNBT, (String)"BaseMod", (float)1.0f);
        this.processMax = 4000 * (1 + this.radius);
        this.processTick = Math.round((float)this.getBaseProcessTick() * baseMod);
        this.area = null;
    }

    public AxisAlignedBB getArea() {
        if (this.area == null) {
            this.area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.radius, -1, -this.radius), this.field_174879_c.func_177982_a(1 + this.radius, 1, 1 + this.radius));
        }
        return this.area;
    }

    public int getColor() {
        return this.isActive ? 7923823 : 0x555555;
    }
}

