/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.tileentity.TileCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DeviceRockGenContainer;
import cofh.thermal.core.util.managers.device.RockGenManager;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DeviceRockGenTile
extends DeviceTileBase
implements ITickableTileEntity {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade");
    protected static final Supplier<ItemStack> COBBLESTONE = () -> new ItemStack((IItemProvider)Blocks.field_150347_e, 0);
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH(e -> false).setEmptyItem(COBBLESTONE).setEnabled(() -> this.isActive);
    protected Block below = Blocks.field_150350_a;
    protected Block adjacent = Blocks.field_150350_a;
    protected int adjLava = 0;
    protected boolean cached;
    protected boolean valid;
    protected int process;
    protected int processMax = RockGenManager.instance().getDefaultEnergy();
    protected int genAmount = 1;

    public DeviceRockGenTile() {
        super(TCoreReferences.DEVICE_ROCK_GEN_TILE);
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalConfig.deviceAugments);
        this.initHandlers();
        this.renderFluid = new FluidStack((Fluid)Fluids.field_204547_b, 1000);
    }

    public Block getBelow() {
        return this.below;
    }

    public Block getAdjacent() {
        return this.adjacent;
    }

    public int getAdjLava() {
        return this.adjLava;
    }

    @Override
    protected void updateValidity() {
        if (this.field_145850_b == null || !this.field_145850_b.isAreaLoaded(this.field_174879_c, 1)) {
            return;
        }
        this.adjLava = 0;
        this.valid = false;
        Block[] adjBlocks = new Block[4];
        BlockPos[] cardinals = new BlockPos[]{this.field_174879_c.func_177978_c(), this.field_174879_c.func_177968_d(), this.field_174879_c.func_177976_e(), this.field_174879_c.func_177974_f()};
        for (int i = 0; i < 4; ++i) {
            BlockPos adj = cardinals[i];
            FluidState fluidState = this.field_145850_b.func_204610_c(adj);
            if (fluidState.func_206886_c().equals(Fluids.field_204547_b)) {
                ++this.adjLava;
            }
            adjBlocks[i] = fluidState.func_206888_e() || fluidState.func_206889_d() ? this.field_145850_b.func_180495_p(adj).func_177230_c() : Blocks.field_150350_a;
        }
        if (this.adjLava > 0) {
            Block under = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c();
            RockGenManager.RockGenRecipe recipe = RockGenManager.instance().getResult(under, adjBlocks);
            ItemStack result = recipe.getResult();
            if (!result.func_190926_b()) {
                this.outputSlot.setEmptyItem(() -> new ItemStack((IItemProvider)result.func_77973_b(), 0));
                if (!this.outputSlot.isEmpty() && !ItemHelper.itemsEqualWithTags((ItemStack)result, (ItemStack)this.outputSlot.getItemStack())) {
                    this.outputSlot.clear();
                }
                Block prevBelow = this.below;
                Block prevAdj = this.adjacent;
                this.below = recipe.getBelow();
                this.adjacent = recipe.getAdjacent();
                if (this.below != prevBelow || this.adjacent != prevAdj) {
                    TileStatePacket.sendToClient((TileCoFH)this);
                }
                this.processMax = recipe.getTime();
                this.genAmount = Math.max(1, result.func_190916_E());
                if (this.field_145850_b.func_226691_t_(this.field_174879_c).func_201856_r() == Biome.Category.NETHER) {
                    this.processMax = Math.max(1, this.processMax / 2);
                }
                this.process = this.processMax;
                this.valid = true;
            }
        }
        this.cached = true;
    }

    @Override
    protected void updateActiveState() {
        if (!this.cached) {
            this.updateValidity();
        }
        super.updateActiveState();
    }

    @Override
    protected boolean isValid() {
        return this.valid;
    }

    public void func_73660_a() {
        this.updateActiveState();
        if (!this.isActive) {
            return;
        }
        --this.process;
        if (this.process > 0) {
            return;
        }
        this.process = this.processMax;
        this.outputSlot.modify((int)((float)this.genAmount * this.baseMod));
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DeviceRockGenContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Override
    public int getScaledProgress(int scale) {
        if (!this.isActive || this.processMax <= 0 || this.outputSlot.isFull()) {
            return 0;
        }
        return scale * (this.processMax - this.process) / this.processMax;
    }

    @Override
    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.process);
        buffer.writeInt(this.processMax);
        return buffer;
    }

    @Override
    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.process = buffer.readInt();
        this.processMax = buffer.readInt();
    }

    @Override
    public PacketBuffer getStatePacket(PacketBuffer buffer) {
        super.getStatePacket(buffer);
        buffer.writeInt(this.process);
        buffer.writeInt(this.adjLava);
        buffer.func_180714_a(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.below).toString());
        buffer.func_180714_a(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.adjacent).toString());
        return buffer;
    }

    @Override
    public void handleStatePacket(PacketBuffer buffer) {
        super.handleStatePacket(buffer);
        this.process = buffer.readInt();
        this.adjLava = buffer.readInt();
        this.below = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buffer.func_218666_n()));
        this.adjacent = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buffer.func_218666_n()));
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.process = nbt.func_74762_e("Proc");
        this.processMax = nbt.func_74762_e("ProcMax");
        this.adjLava = nbt.func_74762_e("Lava");
        this.below = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("Below")));
        this.adjacent = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("Adjacent")));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Proc", this.process);
        nbt.func_74768_a("ProcMax", this.processMax);
        nbt.func_74768_a("Lava", this.adjLava);
        nbt.func_74778_a("Below", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.below).toString());
        nbt.func_74778_a("Adjacent", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.adjacent).toString());
        return nbt;
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

