/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.tileentity.IAreaEffectTile;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DevicePotionDiffuserContainer;
import cofh.thermal.core.util.managers.device.PotionDiffuserManager;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;

public class DevicePotionDiffuserTile
extends DeviceTileBase
implements ITickableTileEntity,
IAreaEffectTile {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Fluid", "Area", "Filter", "Potion");
    protected static final int TIME_CONSTANT = 60;
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && PotionDiffuserManager.instance().validBoost((ItemStack)item));
    protected FluidStorageCoFH inputTank = new FluidStorageCoFH(8000, fluid -> this.filter.valid(fluid) && FluidHelper.hasPotionTag((FluidStack)fluid));
    protected static final int FLUID_AMOUNT = 25;
    protected static final int RADIUS = 4;
    protected int radius = 4;
    protected AxisAlignedBB area;
    protected boolean cached;
    protected List<EffectInstance> effects = Collections.emptyList();
    protected boolean instant;
    protected int process = 1;
    protected int boostCycles;
    protected int boostMax = PotionDiffuserManager.instance().getDefaultEnergy();
    protected int boostAmplifier;
    protected float boostDuration;
    protected float potionAmpMod = 0.0f;
    protected float potionDurMod = 0.0f;

    public DevicePotionDiffuserTile() {
        super(TCoreReferences.DEVICE_POTION_DIFFUSER_TILE);
        this.inventory.addSlot(this.inputSlot, StorageGroup.ACCESSIBLE);
        this.tankInv.addTank(this.inputTank, StorageGroup.ACCESSIBLE);
        this.addAugmentSlots(ThermalConfig.deviceAugments);
        this.initHandlers();
    }

    @Override
    protected void updateActiveState(boolean prevActive) {
        if (!prevActive && this.isActive) {
            this.process = 1;
        }
        super.updateActiveState(prevActive);
    }

    @Override
    protected boolean isValid() {
        if (this.inputTank.getAmount() < 25) {
            this.cached = false;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        this.updateActiveState();
        if (!this.isActive) {
            return;
        }
        --this.process;
        if (this.process > 0) {
            return;
        }
        this.process = this.getTimeConstant();
        if (Utils.isClientWorld((World)this.world())) {
            this.diffuseClient();
            return;
        }
        Fluid curFluid = this.renderFluid.getFluid();
        this.cacheEffects();
        this.diffuse();
        if (curFluid != this.renderFluid.getFluid()) {
            TileStatePacket.sendToClient((TileCoFH)this);
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DevicePotionDiffuserContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Override
    public int getScaledDuration(int scale) {
        return !this.isActive || this.boostCycles <= 0 || this.boostMax <= 0 ? 0 : scale * this.boostCycles / this.boostMax;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void handleControlPacket(PacketBuffer buffer) {
        super.handleControlPacket(buffer);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.boostCycles);
        buffer.writeInt(this.boostMax);
        buffer.writeInt(this.boostAmplifier);
        buffer.writeFloat(this.boostDuration);
        return buffer;
    }

    @Override
    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.boostCycles = buffer.readInt();
        this.boostMax = buffer.readInt();
        this.boostAmplifier = buffer.readInt();
        this.boostDuration = buffer.readFloat();
    }

    @Override
    public PacketBuffer getStatePacket(PacketBuffer buffer) {
        super.getStatePacket(buffer);
        buffer.writeInt(this.process);
        buffer.writeBoolean(this.instant);
        return buffer;
    }

    @Override
    public void handleStatePacket(PacketBuffer buffer) {
        super.handleStatePacket(buffer);
        this.process = buffer.readInt();
        this.instant = buffer.readBoolean();
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.boostCycles = nbt.func_74762_e("BoostCycles");
        this.boostMax = nbt.func_74762_e("BoostMax");
        this.boostAmplifier = nbt.func_74762_e("BoostAmp");
        this.boostDuration = nbt.func_74760_g("BoostDur");
        this.instant = nbt.func_74767_n("Instant");
        this.process = nbt.func_74762_e("Proc");
        this.cacheEffects();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("BoostCycles", this.boostCycles);
        nbt.func_74768_a("BoostMax", this.boostMax);
        nbt.func_74768_a("BoostAmp", this.boostAmplifier);
        nbt.func_74776_a("BoostDur", this.boostDuration);
        nbt.func_74757_a("Instant", this.instant);
        nbt.func_74768_a("Proc", this.process);
        return nbt;
    }

    public boolean hasClientUpdate() {
        return true;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getTimeConstant() {
        return 60;
    }

    public boolean isInstant() {
        return this.instant;
    }

    protected void cacheEffects() {
        if (this.inputTank.isEmpty()) {
            if (this.cached) {
                this.effects.clear();
                this.instant = false;
                this.cached = false;
            }
        } else if (!this.cached) {
            this.effects = PotionUtils.func_185185_a((CompoundNBT)this.inputTank.getFluidStack().getTag());
            for (EffectInstance effect : this.effects) {
                this.instant |= effect.func_188419_a().func_76403_b();
            }
            this.cached = true;
        }
    }

    protected void diffuse() {
        if (this.inputTank.getAmount() < 25) {
            return;
        }
        if (this.effects.isEmpty()) {
            return;
        }
        AxisAlignedBB area = this.getArea();
        List targets = this.field_145850_b.func_175647_a(LivingEntity.class, area, EntityPredicates.field_94557_a);
        if (targets.isEmpty()) {
            return;
        }
        if (this.boostCycles > 0) {
            --this.boostCycles;
        } else if (PotionDiffuserManager.instance().validBoost(this.inputSlot.getItemStack())) {
            this.boostMax = this.boostCycles = PotionDiffuserManager.instance().getBoostCycles(this.inputSlot.getItemStack());
            this.boostAmplifier = PotionDiffuserManager.instance().getBoostAmplifier(this.inputSlot.getItemStack());
            this.boostDuration = PotionDiffuserManager.instance().getBoostDurationMod(this.inputSlot.getItemStack());
            this.inputSlot.consume(1);
        } else {
            this.boostCycles = 0;
            this.boostAmplifier = 0;
            this.boostDuration = 0.0f;
        }
        for (LivingEntity target : targets) {
            if (!target.func_184603_cC()) continue;
            for (EffectInstance effect : this.effects) {
                if (effect.func_188419_a().func_76403_b()) {
                    effect.func_188419_a().func_180793_a(null, null, target, this.getEffectAmplifier(effect), 0.5);
                    continue;
                }
                EffectInstance potion = new EffectInstance(effect.func_188419_a(), this.getEffectDuration(effect), this.getEffectAmplifier(effect), effect.func_82720_e(), effect.func_188418_e());
                target.func_195064_c(potion);
            }
        }
        this.inputTank.modify(-25);
        this.renderFluid = this.inputTank.getFluidStack();
    }

    protected void diffuseClient() {
        if (this.renderFluid.getAmount() < 25) {
            return;
        }
        AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.radius, -1, -this.radius), this.field_174879_c.func_177982_a(1 + this.radius, 1 + this.radius, 1 + this.radius));
        List targets = this.field_145850_b.func_175647_a(LivingEntity.class, area, EntityPredicates.field_94557_a);
        if (targets.isEmpty()) {
            return;
        }
        ThermalCore.PROXY.spawnDiffuserParticles(this);
    }

    protected int getEffectAmplifier(EffectInstance effect) {
        return Math.min(3, Math.round((float)effect.func_76458_c() + this.potionAmpMod + (float)this.boostAmplifier));
    }

    protected int getEffectDuration(EffectInstance effect) {
        return Math.min(72000, Math.round((float)effect.func_76459_b() * (1.0f + this.potionDurMod + this.boostDuration))) / 4;
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.radius = 4;
        this.potionAmpMod = 0.0f;
        this.potionDurMod = 0.0f;
    }

    @Override
    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.radius = (int)((float)this.radius + AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"Radius"));
        this.potionAmpMod += AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"PotionAmp");
        this.potionDurMod += AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"PotionDur");
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.area = null;
    }

    public AxisAlignedBB getArea() {
        if (this.area == null) {
            this.area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.radius, -1, -this.radius), this.field_174879_c.func_177982_a(1 + this.radius, 1 + this.radius, 1 + this.radius));
        }
        return this.area;
    }

    public int getColor() {
        return this.isActive ? (this.renderFluid.isEmpty() ? 0xF800F8 : FluidHelper.color((FluidStack)this.renderFluid)) : 0x555555;
    }
}

