/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.init.TCoreReferences;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BasalzProjectileEntity
extends DamagingProjectileEntity {
    public static float defaultDamage = 7.0f;
    public static int knockbackStrength = 2;
    public static int effectAmplifier = 0;
    public static int effectDuration = 100;

    public BasalzProjectileEntity(EntityType<? extends DamagingProjectileEntity> type, World world) {
        super(type, world);
    }

    public BasalzProjectileEntity(LivingEntity shooter, double accelX, double accelY, double accelZ, World world) {
        super(TCoreReferences.BASALZ_PROJECTILE_ENTITY, shooter, accelX, accelY, accelZ, world);
    }

    public BasalzProjectileEntity(double x, double y, double z, double accelX, double accelY, double accelZ, World world) {
        super(TCoreReferences.BASALZ_PROJECTILE_ENTITY, x, y, z, accelX, accelY, accelZ, world);
    }

    protected boolean func_184564_k() {
        return false;
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_218423_k;
    }

    protected void func_70227_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            if (!entity.func_190530_aW() && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.func_195064_c(new EffectInstance(CoreReferences.SUNDERED, effectDuration, effectAmplifier, false, false));
                Vector3d vec3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)knockbackStrength * 0.6);
                if (vec3d.func_189985_c() > 0.0) {
                    living.func_70024_g(vec3d.field_72450_a, 0.1, vec3d.field_72449_c);
                }
            }
            entity.func_70097_a(BasalzDamageSource.causeDamage(this, this.func_234616_v_()), defaultDamage);
        }
        if (Utils.isServerWorld((World)this.field_70170_p)) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected static class BasalzDamageSource
    extends EntityDamageSource {
        public BasalzDamageSource(Entity source) {
            super("basalz", source);
        }

        public static DamageSource causeDamage(BasalzProjectileEntity entityProj, Entity entitySource) {
            return new IndirectEntityDamageSource("basalz", (Entity)entityProj, (Entity)(entitySource == null ? entityProj : entitySource)).func_76349_b();
        }
    }
}

