/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.jei.device;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.client.gui.device.DeviceRockGenScreen;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.util.recipes.device.RockGenMapping;
import cofh.thermal.lib.compat.jei.Drawables;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class RockGenCategory
implements IRecipeCategory<RockGenMapping> {
    protected static final FluidStack LAVA_FLUID = new FluidStack((Fluid)Fluids.field_204547_b, 1000);
    protected final ResourceLocation uid;
    protected IDrawable background;
    protected IDrawable icon;
    protected ITextComponent name;
    protected IDrawableStatic slot;
    protected IDrawableStatic progressFluidBackground;
    protected IDrawableAnimated progressFluid;

    public RockGenCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        this.uid = uid;
        this.icon = guiHelper.createDrawableIngredient((Object)icon);
        this.background = guiHelper.drawableBuilder(DeviceRockGenScreen.TEXTURE, 26, 11, 140, 62).addPadding(0, 0, 16, 8).build();
        this.name = StringHelper.getTextComponent((String)TCoreReferences.DEVICE_ROCK_GEN_BLOCK.func_149739_a());
        this.slot = Drawables.getDrawables(guiHelper).getSlot(0);
        this.progressFluidBackground = Drawables.getDrawables(guiHelper).getProgressFill(1);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables(guiHelper).getProgress(1), 40, IDrawableAnimated.StartDirection.LEFT, true);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public Class<? extends RockGenMapping> getRecipeClass() {
        return RockGenMapping.class;
    }

    public String getTitle() {
        return this.name.getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RockGenMapping recipe, IIngredients ingredients) {
        FlowingFluid fluid;
        ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        inputFluids.add(LAVA_FLUID);
        Block adjacent = recipe.getAdjacent();
        Block below = recipe.getBelow();
        if (adjacent instanceof FlowingFluidBlock) {
            fluid = ((FlowingFluidBlock)adjacent).getFluid();
            inputFluids.add(new FluidStack((Fluid)fluid, 1000));
        } else if (adjacent != Blocks.field_150350_a) {
            inputItems.add(new ItemStack((IItemProvider)adjacent));
        }
        if (below instanceof FlowingFluidBlock) {
            fluid = ((FlowingFluidBlock)below).getFluid();
            inputFluids.add(new FluidStack((Fluid)fluid, 1000));
        } else if (below != Blocks.field_150350_a) {
            inputItems.add(new ItemStack((IItemProvider)below));
        }
        ingredients.setInputs(VanillaTypes.FLUID, inputFluids);
        ingredients.setInputs(VanillaTypes.ITEM, inputItems);
        ingredients.setOutputs(VanillaTypes.ITEM, Collections.singletonList(recipe.getResult()));
    }

    public void setRecipe(IRecipeLayout layout, RockGenMapping recipe, IIngredients ingredients) {
        int itemCount = 1;
        int fluidCount = 1;
        List inputFluids = ingredients.getInputs(VanillaTypes.FLUID);
        List inputItems = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        Block adjacent = recipe.getAdjacent();
        Block below = recipe.getBelow();
        guiItemStacks.init(0, false, 114, 23);
        guiFluidStacks.init(0, true, 23, 13, 16, 16, 1000, false, null);
        guiItemStacks.set(0, (List)outputs.get(0));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
        if (adjacent instanceof FlowingFluidBlock) {
            guiFluidStacks.init(fluidCount, true, 45, 13, 16, 16, 1000, false, null);
            guiFluidStacks.set(fluidCount, (List)inputFluids.get(fluidCount));
            ++fluidCount;
        } else if (adjacent != Blocks.field_150350_a) {
            guiItemStacks.init(itemCount, true, 44, 12);
            guiItemStacks.set(itemCount, (List)inputItems.get(itemCount - 1));
            ++itemCount;
        }
        if (below instanceof FlowingFluidBlock) {
            guiFluidStacks.init(fluidCount, true, 33, 33, 16, 16, 1000, false, null);
            guiFluidStacks.set(fluidCount, (List)inputFluids.get(fluidCount));
        } else if (below != Blocks.field_150350_a) {
            guiItemStacks.init(itemCount, true, 33, 33);
            guiItemStacks.set(itemCount, (List)inputItems.get(itemCount - 1));
        }
    }

    public void draw(RockGenMapping recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        if (recipe.getBelow() != Blocks.field_150350_a) {
            this.slot.draw(matrixStack, 33, 33);
        }
        RenderHelper.drawFluid((MatrixStack)matrixStack, (int)74, (int)23, (FluidStack)LAVA_FLUID, (int)24, (int)16);
        this.progressFluidBackground.draw(matrixStack, 74, 23);
        this.progressFluid.draw(matrixStack, 74, 23);
    }
}

