/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.machine;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.InsolatorRecipe;
import cofh.thermal.lib.compat.crt.actions.ActionRemoveThermalRecipeByOutput;
import cofh.thermal.lib.compat.crt.base.CRTRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.util.RecipePrintingUtil;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStack;
import com.blamejared.crafttweaker.impl.item.MCWeightedItemStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.Insolator")
@IRecipeHandler.For(value=InsolatorRecipe.class)
public class CRTInsolatorManager
implements IRecipeManager,
IRecipeHandler<InsolatorRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, MCWeightedItemStack[] outputs, IIngredientWithAmount ingredient, int fluidAmount, int energy) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CRTRecipe crtRecipe = new CRTRecipe(resourceLocation).energy(energy).input(ingredient).input(new CTFluidIngredient[]{new CTFluidIngredient.FluidStackIngredient((IFluidStack)new MCFluidStack(new FluidStack((Fluid)Fluids.field_204546_a, fluidAmount)))}).output(outputs);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)crtRecipe.recipe(InsolatorRecipe::new)));
    }

    public IRecipeType<InsolatorRecipe> getRecipeType() {
        return TCoreRecipeTypes.RECIPE_INSOLATOR;
    }

    public void removeRecipe(IItemStack output) {
        this.removeRecipe(new IItemStack[]{output});
    }

    @ZenCodeType.Method
    public void removeRecipe(IItemStack ... output) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveThermalRecipeByOutput((IRecipeManager)this, (IIngredient[])output));
    }

    public String dumpToCommandString(IRecipeManager manager, InsolatorRecipe recipe) {
        return String.format("<recipetype:%s>.addRecipe(\"%s\", [%s], %s, %s, %s);", recipe.func_222127_g(), recipe.func_199560_c(), RecipePrintingUtil.stringifyWeightedStacks(recipe.getOutputItems(), recipe.getOutputItemChances(), (String)", "), RecipePrintingUtil.stringifyIngredients(recipe.getInputItems(), (String)" | "), recipe.getInputFluids().get(0).getFluids()[0].getAmount(), recipe.getEnergy());
    }

    public Optional<Function<ResourceLocation, InsolatorRecipe>> replaceIngredients(IRecipeManager manager, InsolatorRecipe recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceIngredientList(recipe.getInputItems(), Ingredient.class, (IRecipe)recipe, rules, newIngredients -> id -> new CRTRecipe((ResourceLocation)id).energy(recipe.getEnergy()).setInputItems((List<Ingredient>)newIngredients).setOutputItems(recipe.getOutputItems(), recipe.getOutputItemChances()).setInputFluids(recipe.getInputFluids()).recipe(InsolatorRecipe::new));
    }
}

