/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.device;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.device.TreeExtractorBoost;
import cofh.thermal.lib.compat.crt.base.CRTHelper;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipe;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.TreeExtractorBoost")
@IRecipeHandler.For(value=TreeExtractorBoost.class)
public class CRTTreeExtractorBoostManager
implements IRecipeManager,
IRecipeHandler<TreeExtractorBoost> {
    @ZenCodeType.Method
    public void addBoost(String name, IIngredientWithAmount inputItem, float outputMod, int cycles) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        TreeExtractorBoost mapping = new TreeExtractorBoost(resourceLocation, CRTHelper.mapIIngredientWithAmount(inputItem), outputMod, cycles);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)mapping));
    }

    public IRecipeType<TreeExtractorBoost> getRecipeType() {
        return TCoreRecipeTypes.BOOST_TREE_EXTRACTOR;
    }

    public void removeRecipe(IItemStack input) {
        this.removeBoost(input);
    }

    @ZenCodeType.Method
    public void removeBoost(IItemStack input) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> {
            if (recipe instanceof TreeExtractorBoost) {
                return ((TreeExtractorBoost)((Object)recipe)).getIngredient().test(input.getInternal());
            }
            return false;
        }));
    }

    public String dumpToCommandString(IRecipeManager manager, TreeExtractorBoost recipe) {
        return String.format("<recipetype:%s>.addBoost(\"%s\", %s, %s, %s);", recipe.func_222127_g(), recipe.func_199560_c(), IIngredient.fromIngredient((Ingredient)recipe.getIngredient()).getCommandString(), Float.valueOf(recipe.getOutputMod()), recipe.getCycles());
    }

    public Optional<Function<ResourceLocation, TreeExtractorBoost>> replaceIngredients(IRecipeManager manager, TreeExtractorBoost recipe, List<IReplacementRule> rules) {
        Optional ingredient = IRecipeHandler.attemptReplacing((Object)recipe.getIngredient(), Ingredient.class, (IRecipe)recipe, rules);
        return ingredient.map(value -> id -> new TreeExtractorBoost((ResourceLocation)id, (Ingredient)value, recipe.getOutputMod(), recipe.getCycles()));
    }
}

