/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.palettes.AllPaletteBlocks;
import com.simibubi.create.foundation.worldgen.ConfigDrivenDecorator;
import com.simibubi.create.foundation.worldgen.ConfigDrivenFeatureEntry;
import com.simibubi.create.foundation.worldgen.ConfigDrivenOreFeature;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AllWorldFeatures {
    static Map<String, ConfigDrivenFeatureEntry> entries = new HashMap<String, ConfigDrivenFeatureEntry>();
    static final ConfigDrivenFeatureEntry COPPER = AllWorldFeatures.register("copper_ore", AllBlocks.COPPER_ORE, 18, 2.0f).between(40, 85);
    static final ConfigDrivenFeatureEntry ZINC = AllWorldFeatures.register("zinc_ore", AllBlocks.ZINC_ORE, 14, 4.0f).between(15, 70);
    static final ConfigDrivenFeatureEntry LIMESTONE = AllWorldFeatures.register("limestone", AllPaletteBlocks.LIMESTONE, 128, 0.015625f).between(30, 70);
    static final ConfigDrivenFeatureEntry WEATHERED_LIMESTONE = AllWorldFeatures.register("weathered_limestone", AllPaletteBlocks.WEATHERED_LIMESTONE, 128, 0.015625f).between(10, 30);
    static final ConfigDrivenFeatureEntry DOLOMITE = AllWorldFeatures.register("dolomite", AllPaletteBlocks.DOLOMITE, 128, 0.015625f).between(20, 70);
    static final ConfigDrivenFeatureEntry GABBRO = AllWorldFeatures.register("gabbro", AllPaletteBlocks.GABBRO, 128, 0.015625f).between(20, 70);
    static final ConfigDrivenFeatureEntry SCORIA = AllWorldFeatures.register("scoria", AllPaletteBlocks.NATURAL_SCORIA, 128, 0.03125f).between(0, 10);
    public static final int forcedUpdateVersion = 2;

    private static ConfigDrivenFeatureEntry register(String id, NonNullSupplier<? extends Block> block, int clusterSize, float frequency) {
        ConfigDrivenFeatureEntry configDrivenFeatureEntry = new ConfigDrivenFeatureEntry(id, block, clusterSize, frequency);
        entries.put(id, configDrivenFeatureEntry);
        return configDrivenFeatureEntry;
    }

    public static void registerFeatures() {
        entries.entrySet().forEach(entry -> Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)("create_" + (String)entry.getKey()), ((ConfigDrivenFeatureEntry)entry.getValue()).getFeature()));
    }

    public static void reload(BiomeLoadingEvent event) {
        entries.values().forEach(entry -> {
            if (event.getName() == Biomes.field_185440_P.getRegistryName()) {
                return;
            }
            if (event.getCategory() == Biome.Category.NETHER) {
                return;
            }
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, entry.getFeature());
        });
    }

    public static void fillConfig(ForgeConfigSpec.Builder builder) {
        entries.values().forEach(entry -> {
            builder.push(entry.id);
            entry.addToConfig(builder);
            builder.pop();
        });
    }

    public static void register() {
    }

    public static void registerOreFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)ConfigDrivenOreFeature.INSTANCE);
    }

    public static void registerDecoratorFeatures(RegistryEvent.Register<Placement<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)ConfigDrivenDecorator.INSTANCE);
    }
}

