/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.AllTags;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.compat.dynamictrees.DynamicTree;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.ChorusFlowerBlock;
import net.minecraft.block.ChorusPlantBlock;
import net.minecraft.block.KelpBlock;
import net.minecraft.block.KelpTopBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TreeCutter {
    public static final Tree NO_TREE = new Tree(Collections.emptyList(), Collections.emptyList());

    public static boolean canDynamicTreeCutFrom(Block startBlock) {
        return Mods.DYNAMICTREES.runIfInstalled(() -> () -> DynamicTree.isDynamicBranch(startBlock)).orElse(false);
    }

    @Nonnull
    public static Optional<AbstractBlockBreakQueue> findDynamicTree(Block startBlock, BlockPos pos) {
        if (TreeCutter.canDynamicTreeCutFrom(startBlock)) {
            return Mods.DYNAMICTREES.runIfInstalled(() -> () -> new DynamicTree(pos));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Tree findTree(@Nullable IBlockReader reader, BlockPos pos) {
        BlockPos currentPos;
        if (reader == null) {
            return NO_TREE;
        }
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        BlockState stateAbove = reader.func_180495_p(pos.func_177984_a());
        if (TreeCutter.isVerticalPlant(stateAbove)) {
            BlockPos current;
            logs.add(pos.func_177984_a());
            for (int i = 1; i < 256 && TreeCutter.isVerticalPlant(reader.func_180495_p(current = pos.func_177981_b(i))); ++i) {
                logs.add(current);
            }
            Collections.reverse(logs);
            return new Tree(logs, leaves);
        }
        if (TreeCutter.isChorus(stateAbove)) {
            frontier.add(pos.func_177984_a());
            while (!frontier.isEmpty()) {
                BlockPos current = (BlockPos)frontier.remove(0);
                visited.add(current);
                logs.add(current);
                for (Direction direction : Iterate.directions) {
                    BlockPos offset = current.func_177972_a(direction);
                    if (visited.contains(offset) || !TreeCutter.isChorus(reader.func_180495_p(offset))) continue;
                    frontier.add(offset);
                }
            }
            Collections.reverse(logs);
            return new Tree(logs, leaves);
        }
        if (!TreeCutter.validateCut(reader, pos)) {
            return NO_TREE;
        }
        visited.add(pos);
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 1, 1)).forEach(p -> frontier.add(new BlockPos((Vector3i)p)));
        while (!frontier.isEmpty()) {
            currentPos = (BlockPos)frontier.remove(0);
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            if (!TreeCutter.isLog(reader.func_180495_p(currentPos))) continue;
            logs.add(currentPos);
            TreeCutter.addNeighbours(currentPos, frontier, visited);
        }
        visited.clear();
        visited.addAll(logs);
        frontier.addAll(logs);
        while (!frontier.isEmpty()) {
            boolean isGenericLeaf;
            currentPos = (BlockPos)frontier.remove(0);
            if (!logs.contains(currentPos) && visited.contains(currentPos)) continue;
            visited.add(currentPos);
            BlockState blockState = reader.func_180495_p(currentPos);
            boolean isLog = TreeCutter.isLog(blockState);
            boolean isLeaf = TreeCutter.isLeaf(blockState);
            boolean bl = isGenericLeaf = isLeaf || TreeCutter.isNonDecayingLeaf(blockState);
            if (!isLog && !isGenericLeaf) continue;
            if (isGenericLeaf) {
                leaves.add(currentPos);
            }
            int distance = !isLeaf ? 0 : (Integer)blockState.func_177229_b((Property)LeavesBlock.field_208494_a);
            for (Direction direction : Iterate.directions) {
                BlockPos offset = currentPos.func_177972_a(direction);
                if (visited.contains(offset)) continue;
                BlockState state = reader.func_180495_p(offset);
                BlockPos subtract = offset.func_177973_b((Vector3i)pos);
                int horizontalDistance = Math.max(Math.abs(subtract.func_177958_n()), Math.abs(subtract.func_177952_p()));
                if ((!TreeCutter.isLeaf(state) || (Integer)state.func_177229_b((Property)LeavesBlock.field_208494_a) <= distance) && (!TreeCutter.isNonDecayingLeaf(state) || horizontalDistance >= 4)) continue;
                frontier.add(offset);
            }
        }
        return new Tree(logs, leaves);
    }

    public static boolean isChorus(BlockState stateAbove) {
        return stateAbove.func_177230_c() instanceof ChorusPlantBlock || stateAbove.func_177230_c() instanceof ChorusFlowerBlock;
    }

    public static boolean isVerticalPlant(BlockState stateAbove) {
        Block block = stateAbove.func_177230_c();
        if (block instanceof BambooBlock) {
            return true;
        }
        if (block instanceof CactusBlock) {
            return true;
        }
        if (block instanceof SugarCaneBlock) {
            return true;
        }
        if (block instanceof KelpBlock) {
            return true;
        }
        return block instanceof KelpTopBlock;
    }

    private static boolean validateCut(IBlockReader reader, BlockPos pos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        frontier.add(pos);
        frontier.add(pos.func_177984_a());
        int posY = pos.func_177956_o();
        while (!frontier.isEmpty()) {
            boolean lowerLayer;
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            visited.add(currentPos);
            boolean bl = lowerLayer = currentPos.func_177956_o() == posY;
            if (!TreeCutter.isLog(reader.func_180495_p(currentPos))) continue;
            if (!lowerLayer && !pos.equals((Object)currentPos.func_177977_b()) && TreeCutter.isLog(reader.func_180495_p(currentPos.func_177977_b()))) {
                return false;
            }
            for (Direction direction : Iterate.directions) {
                BlockPos offset;
                if (direction == Direction.DOWN || direction == Direction.UP && !lowerLayer || visited.contains(offset = currentPos.func_177972_a(direction))) continue;
                frontier.add(offset);
            }
        }
        return true;
    }

    private static void addNeighbours(BlockPos pos, List<BlockPos> frontier, Set<BlockPos> visited) {
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1)).filter(((Predicate<BlockPos>)visited::contains).negate()).forEach(p -> frontier.add(new BlockPos((Vector3i)p)));
    }

    private static boolean isLog(BlockState state) {
        return state.func_235714_a_((ITag)BlockTags.field_200031_h) || AllTags.AllBlockTags.SLIMY_LOGS.matches(state);
    }

    private static boolean isNonDecayingLeaf(BlockState state) {
        return state.func_235714_a_((ITag)BlockTags.field_232874_ao_) || state.func_177230_c() == Blocks.field_235383_mw_;
    }

    private static boolean isLeaf(BlockState state) {
        return state.func_235901_b_((Property)LeavesBlock.field_208494_a);
    }

    public static class Tree
    extends AbstractBlockBreakQueue {
        private final List<BlockPos> logs;
        private final List<BlockPos> leaves;

        public Tree(List<BlockPos> logs, List<BlockPos> leaves) {
            this.logs = logs;
            this.leaves = leaves;
        }

        @Override
        public void destroyBlocks(World world, ItemStack toDamage, @Nullable PlayerEntity playerEntity, BiConsumer<BlockPos, ItemStack> drop) {
            this.logs.forEach(this.makeCallbackFor(world, 0.5f, toDamage, playerEntity, drop));
            this.leaves.forEach(this.makeCallbackFor(world, 0.125f, toDamage, playerEntity, drop));
        }
    }
}

