/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.extensions.IForgeItemStack;

public class NBTHelper {
    public static void putMarker(CompoundNBT nbt, String marker) {
        nbt.func_74757_a(marker, true);
    }

    public static <T extends Enum<?>> T readEnum(CompoundNBT nbt, String key, Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (enumConstants == null) {
            throw new IllegalArgumentException("Non-Enum class passed to readEnum: " + enumClass.getName());
        }
        if (nbt.func_150297_b(key, 8)) {
            String name = nbt.func_74779_i(key);
            for (Enum t : enumConstants) {
                if (!t.name().equals(name)) continue;
                return (T)t;
            }
        }
        return (T)enumConstants[0];
    }

    public static <T extends Enum<?>> void writeEnum(CompoundNBT nbt, String key, T enumConstant) {
        nbt.func_74778_a(key, enumConstant.name());
    }

    public static <T> ListNBT writeCompoundList(Iterable<T> list, Function<T, CompoundNBT> serializer) {
        ListNBT listNBT = new ListNBT();
        list.forEach(t -> listNBT.add(serializer.apply(t)));
        return listNBT;
    }

    public static <T> List<T> readCompoundList(ListNBT listNBT, Function<CompoundNBT, T> deserializer) {
        ArrayList list = new ArrayList(listNBT.size());
        listNBT.forEach(inbt -> list.add(deserializer.apply((CompoundNBT)inbt)));
        return list;
    }

    public static <T> void iterateCompoundList(ListNBT listNBT, Consumer<CompoundNBT> consumer) {
        listNBT.forEach(inbt -> consumer.accept((CompoundNBT)inbt));
    }

    public static ListNBT writeItemList(Iterable<ItemStack> stacks) {
        return NBTHelper.writeCompoundList(stacks, IForgeItemStack::serializeNBT);
    }

    public static List<ItemStack> readItemList(ListNBT stacks) {
        return NBTHelper.readCompoundList(stacks, ItemStack::func_199557_a);
    }

    public static ListNBT writeAABB(AxisAlignedBB bb) {
        ListNBT bbtag = new ListNBT();
        bbtag.add((Object)FloatNBT.func_229689_a_((float)((float)bb.field_72340_a)));
        bbtag.add((Object)FloatNBT.func_229689_a_((float)((float)bb.field_72338_b)));
        bbtag.add((Object)FloatNBT.func_229689_a_((float)((float)bb.field_72339_c)));
        bbtag.add((Object)FloatNBT.func_229689_a_((float)((float)bb.field_72336_d)));
        bbtag.add((Object)FloatNBT.func_229689_a_((float)((float)bb.field_72337_e)));
        bbtag.add((Object)FloatNBT.func_229689_a_((float)((float)bb.field_72334_f)));
        return bbtag;
    }

    public static AxisAlignedBB readAABB(ListNBT bbtag) {
        if (bbtag == null || bbtag.isEmpty()) {
            return null;
        }
        return new AxisAlignedBB((double)bbtag.func_150308_e(0), (double)bbtag.func_150308_e(1), (double)bbtag.func_150308_e(2), (double)bbtag.func_150308_e(3), (double)bbtag.func_150308_e(4), (double)bbtag.func_150308_e(5));
    }

    @Nonnull
    public static INBT getINBT(CompoundNBT nbt, String id) {
        INBT inbt = nbt.func_74781_a(id);
        if (inbt != null) {
            return inbt;
        }
        return new CompoundNBT();
    }
}

