/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.gui.DelegatedStencilElement;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class TextStencilElement
extends DelegatedStencilElement {
    protected FontRenderer font;
    protected IFormattableTextComponent component;
    protected boolean centerVertically = false;
    protected boolean centerHorizontally = false;

    public TextStencilElement(FontRenderer font) {
        this.font = font;
        this.height = 10;
    }

    public TextStencilElement(FontRenderer font, String text) {
        this(font);
        this.component = new StringTextComponent(text);
    }

    public TextStencilElement(FontRenderer font, IFormattableTextComponent component) {
        this(font);
        this.component = component;
    }

    public TextStencilElement withText(String text) {
        this.component = new StringTextComponent(text);
        return this;
    }

    public TextStencilElement withText(IFormattableTextComponent component) {
        this.component = component;
        return this;
    }

    public TextStencilElement centered(boolean vertical, boolean horizontal) {
        this.centerVertically = vertical;
        this.centerHorizontally = horizontal;
        return this;
    }

    @Override
    protected void renderStencil(MatrixStack ms) {
        float x = 0.0f;
        float y = 0.0f;
        if (this.centerHorizontally) {
            x = (float)this.width / 2.0f - (float)this.font.func_238414_a_((ITextProperties)this.component) / 2.0f;
        }
        if (this.centerVertically) {
            float f = (float)this.height / 2.0f;
            this.font.getClass();
            y = f - (float)(9 - 1) / 2.0f;
        }
        this.font.func_243248_b(ms, (ITextComponent)this.component, x, y, -16777216);
    }

    @Override
    protected void renderElement(MatrixStack ms) {
        float x = 0.0f;
        float y = 0.0f;
        if (this.centerHorizontally) {
            x = (float)this.width / 2.0f - (float)this.font.func_238414_a_((ITextProperties)this.component) / 2.0f;
        }
        if (this.centerVertically) {
            float f = (float)this.height / 2.0f;
            this.font.getClass();
            y = f - (float)(9 - 1) / 2.0f;
        }
        ms.func_227860_a_();
        ms.func_227861_a_((double)x, (double)y, 0.0);
        int n = this.font.func_238414_a_((ITextProperties)this.component);
        this.font.getClass();
        this.element.render(ms, n, 9 + 2, this.alpha);
        ms.func_227865_b_();
    }

    public IFormattableTextComponent getComponent() {
        return this.component;
    }
}

