/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui.entries;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.config.ui.ConfigTextField;
import com.simibubi.create.foundation.config.ui.entries.ValueEntry;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.TextStencilElement;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class NumberEntry<T extends Number>
extends ValueEntry<T> {
    protected int minOffset = 0;
    protected int maxOffset = 0;
    protected TextStencilElement minText = null;
    protected TextStencilElement maxText = null;
    protected TextFieldWidget textField;

    @Nullable
    public static NumberEntry<? extends Number> create(Object type, String label, ForgeConfigSpec.ConfigValue<?> value, ForgeConfigSpec.ValueSpec spec) {
        if (type instanceof Integer) {
            return new IntegerEntry(label, (ForgeConfigSpec.ConfigValue<Integer>)value, spec);
        }
        if (type instanceof Float) {
            return new FloatEntry(label, (ForgeConfigSpec.ConfigValue<Float>)value, spec);
        }
        if (type instanceof Double) {
            return new DoubleEntry(label, (ForgeConfigSpec.ConfigValue<Double>)value, spec);
        }
        return null;
    }

    public NumberEntry(String label, ForgeConfigSpec.ConfigValue<T> value, ForgeConfigSpec.ValueSpec spec) {
        super(label, value, spec);
        this.textField = new ConfigTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20);
        if (this instanceof IntegerEntry && this.annotations.containsKey("IntDisplay")) {
            String textValue;
            String intDisplay = (String)this.annotations.get("IntDisplay");
            int intValue = (Integer)this.getValue();
            switch (intDisplay) {
                case "#": {
                    textValue = "#" + Integer.toHexString(intValue).toUpperCase(Locale.ROOT);
                    break;
                }
                case "0x": {
                    textValue = "0x" + Integer.toHexString(intValue).toUpperCase(Locale.ROOT);
                    break;
                }
                case "0b": {
                    textValue = "0b" + Integer.toBinaryString(intValue);
                    break;
                }
                default: {
                    textValue = String.valueOf(intValue);
                }
            }
            this.textField.func_146180_a(textValue);
        } else {
            this.textField.func_146180_a(String.valueOf(this.getValue()));
        }
        this.textField.func_146193_g(Theme.i(Theme.Key.TEXT));
        ForgeConfigSpec.Range range = spec.getRange();
        try {
            StringTextComponent t;
            Field minField = range.getClass().getDeclaredField("min");
            Field maxField = range.getClass().getDeclaredField("max");
            minField.setAccessible(true);
            maxField.setAccessible(true);
            Number min = (Number)minField.get(range);
            Number max = (Number)maxField.get(range);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            if (min.doubleValue() > ((Number)this.getTypeMin()).doubleValue()) {
                t = new StringTextComponent(this.formatBound(min) + " < ");
                this.minText = new TextStencilElement(font, (IFormattableTextComponent)t).centered(true, false);
                this.minText.withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient(ms, 0.0f, 0, height / 2, height, width, Theme.p(Theme.Key.TEXT_DARKER)));
                this.minOffset = font.func_238414_a_((ITextProperties)t);
            }
            if (max.doubleValue() < ((Number)this.getTypeMax()).doubleValue()) {
                t = new StringTextComponent(" < " + this.formatBound(max));
                this.maxText = new TextStencilElement(font, (IFormattableTextComponent)t).centered(true, false);
                this.maxText.withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient(ms, 0.0f, 0, height / 2, height, width, Theme.p(Theme.Key.TEXT_DARKER)));
                this.maxOffset = font.func_238414_a_((ITextProperties)t);
            }
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException | NullPointerException exception) {
            // empty catch block
        }
        this.textField.func_212954_a(s -> {
            try {
                Number number = (Number)this.getParser().apply((String)s);
                if (!spec.test((Object)number)) {
                    throw new IllegalArgumentException();
                }
                this.textField.func_146193_g(Theme.i(Theme.Key.TEXT));
                this.setValue(number);
            }
            catch (IllegalArgumentException ignored) {
                this.textField.func_146193_g(Theme.i(Theme.Key.BUTTON_FAIL));
            }
        });
        this.textField.func_146196_d();
        this.listeners.add(this.textField);
        this.onReset();
    }

    protected String formatBound(T bound) {
        String sci = String.format("%.2E", ((Number)bound).doubleValue());
        String str = String.valueOf(bound);
        return sci.length() < str.length() ? sci : str;
    }

    protected abstract T getTypeMin();

    protected abstract T getTypeMax();

    protected abstract Function<String, T> getParser();

    @Override
    protected void setEditable(boolean b) {
        super.setEditable(b);
        this.textField.func_146184_c(b);
    }

    @Override
    public void onValueChange(T newValue) {
        super.onValueChange(newValue);
        try {
            Number current = (Number)this.getParser().apply(this.textField.func_146179_b());
            if (!current.equals(newValue)) {
                this.textField.func_146180_a(String.valueOf(newValue));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.textField.func_146178_a();
    }

    @Override
    public void func_230432_a_(MatrixStack ms, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        super.func_230432_a_(ms, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
        this.textField.field_230690_l_ = x + width - 82 - 28;
        this.textField.field_230691_m_ = y + 8;
        this.textField.func_230991_b_(Math.min(width - this.getLabelWidth(width) - 28 - this.minOffset - this.maxOffset, 40));
        this.textField.setHeight(20);
        this.textField.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        if (this.minText != null) {
            ((RenderElement)((RenderElement)this.minText.at(this.textField.field_230690_l_ - this.minOffset, this.textField.field_230691_m_, 0.0f)).withBounds(this.minOffset, this.textField.func_238483_d_())).render(ms);
        }
        if (this.maxText != null) {
            ((RenderElement)((RenderElement)this.maxText.at(this.textField.field_230690_l_ + this.textField.func_230998_h_(), this.textField.field_230691_m_, 0.0f)).withBounds(this.maxOffset, this.textField.func_238483_d_())).render(ms);
        }
    }

    public static class DoubleEntry
    extends NumberEntry<Double> {
        public DoubleEntry(String label, ForgeConfigSpec.ConfigValue<Double> value, ForgeConfigSpec.ValueSpec spec) {
            super(label, value, spec);
        }

        @Override
        protected Double getTypeMin() {
            return -3.4028234663852886E38;
        }

        @Override
        protected Double getTypeMax() {
            return 3.4028234663852886E38;
        }

        @Override
        protected Function<String, Double> getParser() {
            return Double::parseDouble;
        }
    }

    public static class FloatEntry
    extends NumberEntry<Float> {
        public FloatEntry(String label, ForgeConfigSpec.ConfigValue<Float> value, ForgeConfigSpec.ValueSpec spec) {
            super(label, value, spec);
        }

        @Override
        protected Float getTypeMin() {
            return Float.valueOf(-3.4028235E38f);
        }

        @Override
        protected Float getTypeMax() {
            return Float.valueOf(Float.MAX_VALUE);
        }

        @Override
        protected Function<String, Float> getParser() {
            return Float::parseFloat;
        }
    }

    public static class IntegerEntry
    extends NumberEntry<Integer> {
        public IntegerEntry(String label, ForgeConfigSpec.ConfigValue<Integer> value, ForgeConfigSpec.ValueSpec spec) {
            super(label, value, spec);
        }

        @Override
        protected Integer getTypeMin() {
            return Integer.MIN_VALUE;
        }

        @Override
        protected Integer getTypeMax() {
            return Integer.MAX_VALUE;
        }

        @Override
        protected Function<String, Integer> getParser() {
            return string -> {
                if (string.startsWith("#")) {
                    return Integer.parseUnsignedInt(string.substring(1), 16);
                }
                if (string.startsWith("0x")) {
                    return Integer.parseUnsignedInt(string.substring(2), 16);
                }
                if (string.startsWith("0b")) {
                    return Integer.parseUnsignedInt(string.substring(2), 2);
                }
                return Integer.parseInt(string);
            };
        }
    }
}

