/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.render;

import com.simibubi.create.foundation.block.render.IBlockVertexColor;
import com.simibubi.create.foundation.block.render.QuadHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class ColoredVertexModel
extends BakedModelWrapper<IBakedModel> {
    private static final ModelProperty<BlockPos> POSITION_PROPERTY = new ModelProperty();
    private IBlockVertexColor color;

    public ColoredVertexModel(IBakedModel originalModel, IBlockVertexColor color) {
        super(originalModel);
        this.color = color;
    }

    public IModelData getModelData(IBlockDisplayReader world, BlockPos pos, BlockState state, IModelData tileData) {
        return new ModelDataMap.Builder().withInitial(POSITION_PROPERTY, (Object)pos).build();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData);
        if (quads.isEmpty()) {
            return quads;
        }
        if (!extraData.hasProperty(POSITION_PROPERTY)) {
            return quads;
        }
        BlockPos data = (BlockPos)extraData.getData(POSITION_PROPERTY);
        quads = new ArrayList<BakedQuad>(quads);
        VertexFormat format = DefaultVertexFormats.field_176600_a;
        int colorIndex = 0;
        for (int elementId = 0; elementId < format.func_227894_c_().size(); ++elementId) {
            VertexFormatElement element = (VertexFormatElement)format.func_227894_c_().get(elementId);
            if (element.func_177375_c() != VertexFormatElement.Usage.COLOR) continue;
            colorIndex = elementId;
        }
        int colorOffset = format.getOffset(colorIndex) / 4;
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            BakedQuad newQuad = QuadHelper.clone(quad);
            int[] vertexData = newQuad.func_178209_a();
            for (int vertex = 0; vertex < vertexData.length; vertex += format.func_181719_f()) {
                int color;
                float x = Float.intBitsToFloat(vertexData[vertex]);
                float y = Float.intBitsToFloat(vertexData[vertex + 1]);
                float z = Float.intBitsToFloat(vertexData[vertex + 2]);
                vertexData[vertex + colorOffset] = color = this.color.getColor(x + (float)data.func_177958_n(), y + (float)data.func_177956_o(), z + (float)data.func_177952_p());
            }
            quads.set(i, newQuad);
        }
        return quads;
    }
}

