/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.schematics.ClientSchematicLoader;
import com.simibubi.create.content.schematics.block.SchematicTableContainer;
import com.simibubi.create.foundation.gui.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SchematicTableScreen
extends AbstractSimiContainerScreen<SchematicTableContainer> {
    protected AllGuiTextures background;
    private List<Rectangle2d> extraAreas = Collections.emptyList();
    private ScrollInput schematicsArea;
    private IconButton confirmButton;
    private IconButton folderButton;
    private IconButton refreshButton;
    private Label schematicsLabel;
    private final ITextComponent uploading = Lang.translate("gui.schematicTable.uploading", new Object[0]);
    private final ITextComponent finished = Lang.translate("gui.schematicTable.finished", new Object[0]);
    private final ITextComponent refresh = Lang.translate("gui.schematicTable.refresh", new Object[0]);
    private final ITextComponent folder = Lang.translate("gui.schematicTable.open_folder", new Object[0]);
    private final ITextComponent noSchematics = Lang.translate("gui.schematicTable.noSchematics", new Object[0]);
    private final ITextComponent availableSchematicsTitle = Lang.translate("gui.schematicTable.availableSchematics", new Object[0]);
    private final ItemStack renderedItem = AllBlocks.SCHEMATIC_TABLE.asStack();
    private float progress;
    private float chasingProgress;
    private float lastChasingProgress;

    public SchematicTableScreen(SchematicTableContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.background = AllGuiTextures.SCHEMATIC_TABLE;
    }

    @Override
    protected void func_231160_c_() {
        this.setWindowSize(this.background.width, this.background.height + 4 + AllGuiTextures.PLAYER_INVENTORY.height);
        this.setWindowOffset(-11, 8);
        super.func_231160_c_();
        this.widgets.clear();
        CreateClient.SCHEMATIC_SENDER.refresh();
        List<ITextComponent> availableSchematics = CreateClient.SCHEMATIC_SENDER.getAvailableSchematics();
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        this.schematicsLabel = new Label(x + 49, y + 26, StringTextComponent.field_240750_d_).withShadow();
        this.schematicsLabel.text = StringTextComponent.field_240750_d_;
        if (!availableSchematics.isEmpty()) {
            this.schematicsArea = new SelectionScrollInput(x + 45, y + 21, 139, 18).forOptions(availableSchematics).titled(this.availableSchematicsTitle.func_230531_f_()).writingTo(this.schematicsLabel);
            this.widgets.add(this.schematicsArea);
            this.widgets.add(this.schematicsLabel);
        }
        this.confirmButton = new IconButton(x + 44, y + 56, AllIcons.I_CONFIRM);
        this.folderButton = new IconButton(x + 21, y + 21, AllIcons.I_OPEN_FOLDER);
        this.folderButton.setToolTip(this.folder);
        this.refreshButton = new IconButton(x + 207, y + 21, AllIcons.I_REFRESH);
        this.refreshButton.setToolTip(this.refresh);
        this.widgets.add(this.confirmButton);
        this.widgets.add(this.folderButton);
        this.widgets.add(this.refreshButton);
        this.extraAreas = ImmutableList.of((Object)new Rectangle2d(x + this.background.width, y + this.background.height - 40, 48, 48), (Object)new Rectangle2d(this.refreshButton.field_230690_l_, this.refreshButton.field_230691_m_, this.refreshButton.func_230998_h_(), this.refreshButton.func_238483_d_()));
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.field_147009_r + this.background.height + 4;
        this.renderPlayerInventory(ms, invX, invY);
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        this.background.draw(ms, (AbstractGui)this, x, y);
        ITextComponent titleText = ((SchematicTableContainer)this.field_147002_h).getTileEntity().isUploading ? this.uploading : (((SchematicTableContainer)this.field_147002_h).func_75139_a(1).func_75216_d() ? this.finished : this.field_230704_d_);
        SchematicTableScreen.func_238472_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)titleText, (int)(x + (this.background.width - 8) / 2), (int)(y + 3), (int)0xFFFFFF);
        if (this.schematicsArea == null) {
            this.field_230712_o_.func_243246_a(ms, this.noSchematics, (float)(x + 54), (float)(y + 26), 0xD3D3D3);
        }
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.renderedItem).at(x + this.background.width, y + this.background.height - 40, -200.0f)).scale(3.0).render(ms);
        AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.bind();
        int width = (int)((float)AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.width * MathHelper.func_219799_g((float)partialTicks, (float)this.lastChasingProgress, (float)this.chasingProgress));
        int height = AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.height;
        RenderSystem.disableLighting();
        this.func_238474_b_(ms, x + 70, y + 57, AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.startX, AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.startY, width, height);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        boolean finished = ((SchematicTableContainer)this.field_147002_h).func_75139_a(1).func_75216_d();
        if (((SchematicTableContainer)this.field_147002_h).getTileEntity().isUploading || finished) {
            if (finished) {
                this.progress = 1.0f;
                this.lastChasingProgress = 1.0f;
                this.chasingProgress = 1.0f;
            } else {
                this.lastChasingProgress = this.chasingProgress;
                this.progress = ((SchematicTableContainer)this.field_147002_h).getTileEntity().uploadingProgress;
                this.chasingProgress += (this.progress - this.chasingProgress) * 0.5f;
            }
            this.confirmButton.field_230693_o_ = false;
            if (this.schematicsLabel != null) {
                this.schematicsLabel.colored(0xCCDDFF);
                String uploadingSchematic = ((SchematicTableContainer)this.field_147002_h).getTileEntity().uploadingSchematic;
                StringTextComponent stringTextComponent = this.schematicsLabel.text = uploadingSchematic == null ? null : new StringTextComponent(uploadingSchematic);
            }
            if (this.schematicsArea != null) {
                this.schematicsArea.field_230694_p_ = false;
            }
        } else {
            this.progress = 0.0f;
            this.lastChasingProgress = 0.0f;
            this.chasingProgress = 0.0f;
            this.confirmButton.field_230693_o_ = true;
            if (this.schematicsLabel != null) {
                this.schematicsLabel.colored(0xFFFFFF);
            }
            if (this.schematicsArea != null) {
                this.schematicsArea.writingTo(this.schematicsLabel);
                this.schematicsArea.field_230694_p_ = true;
            }
        }
    }

    @Override
    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        List<ITextComponent> availableSchematics;
        ClientSchematicLoader schematicSender = CreateClient.SCHEMATIC_SENDER;
        if (this.confirmButton.field_230693_o_ && this.confirmButton.func_230449_g_() && ((SchematicTableContainer)this.field_147002_h).canWrite() && this.schematicsArea != null) {
            this.progress = 0.0f;
            this.chasingProgress = 0.0f;
            this.lastChasingProgress = 0.0f;
            availableSchematics = schematicSender.getAvailableSchematics();
            ITextComponent schematic = availableSchematics.get(this.schematicsArea.getState());
            schematicSender.startNewUpload(schematic.func_150261_e());
        }
        if (this.folderButton.func_230449_g_()) {
            Util.func_110647_a().func_195641_a(Paths.get("schematics/", new String[0]).toFile());
        }
        if (this.refreshButton.func_230449_g_()) {
            schematicSender.refresh();
            availableSchematics = schematicSender.getAvailableSchematics();
            this.widgets.remove((Object)this.schematicsArea);
            if (!availableSchematics.isEmpty()) {
                this.schematicsArea = new SelectionScrollInput(this.field_147003_i + 45, this.field_147009_r + 21, 139, 18).forOptions(availableSchematics).titled(this.availableSchematicsTitle.func_230531_f_()).writingTo(this.schematicsLabel);
                this.schematicsArea.onChanged();
                this.widgets.add(this.schematicsArea);
            } else {
                this.schematicsArea = null;
                this.schematicsLabel.text = StringTextComponent.field_240750_d_;
            }
        }
        return super.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    @Override
    public List<Rectangle2d> getExtraAreas() {
        return this.extraAreas;
    }
}

