/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.astralsorcery;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class AstralSorceryAttunementAttribute
implements ItemAttribute {
    String constellationName;

    public AstralSorceryAttunementAttribute(String constellationName) {
        this.constellationName = constellationName;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        CompoundNBT nbt = this.extractAstralNBT(itemStack);
        String constellation = nbt.func_74764_b("constellation") ? nbt.func_74779_i("constellation") : nbt.func_74779_i("constellationName");
        ResourceLocation itemResource = itemStack.func_77973_b().getRegistryName();
        if (itemResource != null && itemResource.toString().contains("shifting_star_")) {
            constellation = itemResource.toString().replace("shifting_star_", "");
        }
        return constellation.equals(this.constellationName);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        CompoundNBT nbt = this.extractAstralNBT(itemStack);
        String constellation = nbt.func_74764_b("constellation") ? nbt.func_74779_i("constellation") : nbt.func_74779_i("constellationName");
        ResourceLocation itemResource = itemStack.func_77973_b().getRegistryName();
        if (itemResource != null && itemResource.toString().contains("shifting_star_")) {
            constellation = itemResource.toString().replace("shifting_star_", "");
        }
        ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
        if (constellation.length() > 0) {
            atts.add(new AstralSorceryAttunementAttribute(constellation));
        }
        return atts;
    }

    @Override
    public String getTranslationKey() {
        return "astralsorcery_constellation";
    }

    @Override
    public Object[] getTranslationParameters() {
        ResourceLocation constResource = new ResourceLocation(this.constellationName);
        String something = new TranslationTextComponent(String.format("%s.constellation.%s", constResource.func_110624_b(), constResource.func_110623_a())).getString();
        return new Object[]{something};
    }

    @Override
    public void writeNBT(CompoundNBT nbt) {
        nbt.func_74778_a("constellation", this.constellationName);
    }

    @Override
    public ItemAttribute readNBT(CompoundNBT nbt) {
        return new AstralSorceryAttunementAttribute(nbt.func_74779_i("constellation"));
    }

    private CompoundNBT extractAstralNBT(ItemStack stack) {
        return stack.func_77978_p() != null ? stack.func_77978_p().func_74775_l("astralsorcery") : new CompoundNBT();
    }
}

