/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CardboardBoxItem
extends Item {
    static final int SLOTS = 9;
    static final List<CardboardBoxItem> ALL_BOXES = new ArrayList<CardboardBoxItem>();

    public CardboardBoxItem(Item.Properties properties) {
        super(properties);
        ALL_BOXES.add(this);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!playerIn.func_225608_bj_()) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        ItemStack box = playerIn.func_184586_b(handIn);
        for (ItemStack stack : CardboardBoxItem.getContents(box)) {
            playerIn.field_71071_by.func_191975_a(worldIn, stack);
        }
        if (!playerIn.func_184812_l_()) {
            box.func_190918_g(1);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)box);
    }

    public static ItemStack containing(List<ItemStack> stacks) {
        ItemStack box = new ItemStack((IItemProvider)CardboardBoxItem.randomBox());
        CompoundNBT compound = new CompoundNBT();
        NonNullList list = NonNullList.func_191196_a();
        list.addAll(stacks);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, (NonNullList)list);
        box.func_77982_d(compound);
        return box;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    public static void addAddress(ItemStack box, String address) {
        box.func_196082_o().func_74778_a("Address", address);
    }

    public static boolean matchAddress(ItemStack box, String other) {
        String address = box.func_77978_p().func_74779_i("Address");
        if (address == null || address.isEmpty()) {
            return false;
        }
        if (address.equals("*")) {
            return true;
        }
        if (address.equals(other)) {
            return true;
        }
        return address.endsWith("*") && other.startsWith(address.substring(0, address.length() - 1));
    }

    public static List<ItemStack> getContents(ItemStack box) {
        NonNullList list = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)box.func_196082_o(), (NonNullList)list);
        return list;
    }

    public static CardboardBoxItem randomBox() {
        return ALL_BOXES.get(new Random().nextInt(ALL_BOXES.size()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_196082_o();
        if (compoundnbt.func_150297_b("Address", 8)) {
            tooltip.add((ITextComponent)new StringTextComponent("-> " + compoundnbt.func_74779_i("Address")).func_240699_a_(TextFormatting.GOLD));
        }
        if (!compoundnbt.func_150297_b("Items", 9)) {
            return;
        }
        int i = 0;
        int j = 0;
        for (ItemStack itemstack : CardboardBoxItem.getContents(stack)) {
            if (itemstack.func_190926_b()) continue;
            ++j;
            if (i > 4) continue;
            ++i;
            ITextComponent itextcomponent = itemstack.func_200301_q();
            tooltip.add((ITextComponent)itextcomponent.func_230531_f_().func_240702_b_(" x").func_240702_b_(String.valueOf(itemstack.func_190916_E())).func_240699_a_(TextFormatting.GRAY));
        }
        if (j - i > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("container.shulkerBox.more", new Object[]{j - i}).func_240699_a_(TextFormatting.ITALIC));
        }
    }
}

