/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.diodes;

import com.simibubi.create.content.logistics.block.diodes.ToggleLatchBlock;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PoweredLatchBlock
extends ToggleLatchBlock {
    public static BooleanProperty POWERED_SIDE = BooleanProperty.func_177716_a((String)"powered_side");

    public PoweredLatchBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)POWERED_SIDE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new Property[]{POWERED_SIDE}));
    }

    protected void func_176398_g(World worldIn, BlockPos pos, BlockState state) {
        boolean back = (Boolean)state.func_177229_b((Property)field_196348_c);
        boolean shouldBack = this.func_176404_e(worldIn, pos, state);
        boolean side = (Boolean)state.func_177229_b((Property)POWERED_SIDE);
        boolean shouldSide = this.isPoweredOnSides(worldIn, pos, state);
        TickPriority tickpriority = TickPriority.HIGH;
        if (this.func_176402_i((IBlockReader)worldIn, pos, state)) {
            tickpriority = TickPriority.EXTREMELY_HIGH;
        } else if (side || back) {
            tickpriority = TickPriority.VERY_HIGH;
        }
        if (worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            return;
        }
        if (back != shouldBack || side != shouldSide) {
            worldIn.func_205220_G_().func_205362_a(pos, (Object)this, this.func_196346_i(state), tickpriority);
        }
    }

    protected boolean isPoweredOnSides(World worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
        Direction left = direction.func_176746_e();
        Direction right = direction.func_176735_f();
        for (Direction d : new Direction[]{left, right}) {
            BlockPos blockpos = pos.func_177972_a(d);
            int i = worldIn.func_175651_c(blockpos, d);
            if (i > 0) {
                return true;
            }
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            if (blockstate.func_177230_c() != Blocks.field_150488_af || (Integer)blockstate.func_177229_b((Property)RedstoneWireBlock.field_176351_O) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        boolean back = (Boolean)state.func_177229_b((Property)field_196348_c);
        boolean shouldBack = this.func_176404_e((World)worldIn, pos, state);
        boolean side = (Boolean)state.func_177229_b((Property)POWERED_SIDE);
        boolean shouldSide = this.isPoweredOnSides((World)worldIn, pos, state);
        BlockState stateIn = state;
        if (back != shouldBack) {
            state = (BlockState)state.func_206870_a((Property)field_196348_c, (Comparable)Boolean.valueOf(shouldBack));
            if (shouldBack) {
                state = (BlockState)state.func_206870_a((Property)POWERING, (Comparable)Boolean.valueOf(true));
            } else if (side) {
                state = (BlockState)state.func_206870_a((Property)POWERING, (Comparable)Boolean.valueOf(false));
            }
        }
        if (side != shouldSide) {
            state = (BlockState)state.func_206870_a((Property)POWERED_SIDE, (Comparable)Boolean.valueOf(shouldSide));
            if (shouldSide) {
                state = (BlockState)state.func_206870_a((Property)POWERING, (Comparable)Boolean.valueOf(false));
            } else if (back) {
                state = (BlockState)state.func_206870_a((Property)POWERING, (Comparable)Boolean.valueOf(true));
            }
        }
        if (state != stateIn) {
            worldIn.func_180501_a(pos, state, 2);
        }
    }

    @Override
    protected ActionResultType activated(World worldIn, BlockPos pos, BlockState state) {
        if (state.func_177229_b((Property)field_196348_c) != state.func_177229_b((Property)POWERED_SIDE)) {
            return ActionResultType.PASS;
        }
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)POWERING), 2);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        if (side == null) {
            return false;
        }
        return side.func_176740_k().func_176722_c();
    }
}

