/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.simibubi.create.content.curiosities.toolbox.ToolboxBlock;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.ISyncPersistentData;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.List;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class ToolboxHandler {
    public static final WorldAttached<WeakHashMap<BlockPos, ToolboxTileEntity>> toolboxes = new WorldAttached(w -> new WeakHashMap());
    static int validationTimer = 20;

    public static void onLoad(ToolboxTileEntity te) {
        toolboxes.get((IWorld)te.func_145831_w()).put(te.func_174877_v(), te);
    }

    public static void onUnload(ToolboxTileEntity te) {
        toolboxes.get((IWorld)te.func_145831_w()).remove(te.func_174877_v());
    }

    public static void entityTick(Entity entity, World world) {
        if (world.field_72995_K) {
            return;
        }
        if (!(world instanceof ServerWorld)) {
            return;
        }
        if (!(entity instanceof ServerPlayerEntity)) {
            return;
        }
        if (entity.field_70173_aa % validationTimer != 0) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entity;
        if (!player.getPersistentData().func_74764_b("CreateToolboxData")) {
            return;
        }
        boolean sendData = false;
        CompoundNBT compound = player.getPersistentData().func_74775_l("CreateToolboxData");
        for (int i = 0; i < 9; ++i) {
            String key = String.valueOf(i);
            if (!compound.func_74764_b(key)) continue;
            CompoundNBT data = compound.func_74775_l(key);
            BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)data.func_74775_l("Pos"));
            int slot = data.func_74762_e("Slot");
            if (!world.isAreaLoaded(pos, 0)) continue;
            if (!(world.func_180495_p(pos).func_177230_c() instanceof ToolboxBlock)) {
                compound.func_82580_o(key);
                sendData = true;
                continue;
            }
            TileEntity prevBlockEntity = world.func_175625_s(pos);
            if (!(prevBlockEntity instanceof ToolboxTileEntity)) continue;
            ((ToolboxTileEntity)prevBlockEntity).connectPlayer(slot, (PlayerEntity)player, i);
        }
        if (sendData) {
            ToolboxHandler.syncData((PlayerEntity)player);
        }
    }

    public static void playerLogin(PlayerEntity player) {
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        if (player.getPersistentData().func_74764_b("CreateToolboxData") && !player.getPersistentData().func_74775_l("CreateToolboxData").isEmpty()) {
            ToolboxHandler.syncData(player);
        }
    }

    public static void syncData(PlayerEntity player) {
        AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new ISyncPersistentData.Packet((Entity)player));
    }

    public static List<ToolboxTileEntity> getNearest(IWorld world, PlayerEntity player, int maxAmount) {
        Vector3d location = player.func_213303_ch();
        double maxRange = ToolboxHandler.getMaxRange(player);
        return toolboxes.get(world).keySet().stream().filter(p -> ToolboxHandler.distance(location, p) < maxRange * maxRange).sorted((p1, p2) -> Double.compare(ToolboxHandler.distance(location, p1), ToolboxHandler.distance(location, p2))).limit(maxAmount).map(toolboxes.get(world)::get).collect(Collectors.toList());
    }

    public static void unequip(PlayerEntity player, int hotbarSlot, boolean keepItems) {
        CompoundNBT compound = player.getPersistentData().func_74775_l("CreateToolboxData");
        World world = player.field_70170_p;
        String key = String.valueOf(hotbarSlot);
        if (!compound.func_74764_b(key)) {
            return;
        }
        CompoundNBT prevData = compound.func_74775_l(key);
        BlockPos prevPos = NBTUtil.func_186861_c((CompoundNBT)prevData.func_74775_l("Pos"));
        int prevSlot = prevData.func_74762_e("Slot");
        TileEntity prevBlockEntity = world.func_175625_s(prevPos);
        if (prevBlockEntity instanceof ToolboxTileEntity) {
            ToolboxTileEntity toolbox = (ToolboxTileEntity)prevBlockEntity;
            toolbox.unequip(prevSlot, player, hotbarSlot, keepItems || !ToolboxHandler.withinRange(player, toolbox));
        }
        compound.func_82580_o(key);
    }

    public static boolean withinRange(PlayerEntity player, ToolboxTileEntity box) {
        if (player.field_70170_p != box.func_145831_w()) {
            return false;
        }
        double maxRange = ToolboxHandler.getMaxRange(player);
        return ToolboxHandler.distance(player.func_213303_ch(), box.func_174877_v()) < maxRange * maxRange;
    }

    public static double distance(Vector3d location, BlockPos p) {
        return location.func_186679_c((double)((float)p.func_177958_n() + 0.5f), (double)p.func_177956_o(), (double)((float)p.func_177952_p() + 0.5f));
    }

    public static double getMaxRange(PlayerEntity player) {
        return ((Integer)AllConfigs.SERVER.curiosities.toolboxRange.get()).doubleValue();
    }
}

