/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.particle.CubeParticleData;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeHooks;

public class BlazeBurnerTileEntity
extends SmartTileEntity {
    public static final int MAX_HEAT_CAPACITY = 10000;
    private static final Color[][] PARTICLE_COLORS = new Color[][]{new Color[0], {new Color(3871770), new Color(4658202), new Color(8010532), new Color(8736038)}, {new Color(2752771), new Color(7609098), new Color(12812870), new Color(13417848)}, {new Color(6490883), new Color(9123075), new Color(12354048), new Color(13420617)}, {new Color(1860472), new Color(4692149), new Color(5088960), new Color(12241102)}};
    private static final Color[] CREATIVE_PARTICLE_COLORS = new Color[]{new Color(5515613), new Color(7224438), new Color(10831775), new Color(8721788)};
    protected FuelType activeFuel = FuelType.NONE;
    protected int remainingBurnTime = 0;
    protected LerpedFloat headAngle = LerpedFloat.angular();
    protected boolean isCreative = false;

    public BlazeBurnerTileEntity(TileEntityType<? extends BlazeBurnerTileEntity> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public FuelType getActiveFuel() {
        return this.activeFuel;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.tickRotation();
            this.spawnParticles(this.getHeatLevelFromBlock(), 1.0);
            return;
        }
        if (this.isCreative) {
            return;
        }
        if (this.remainingBurnTime > 0) {
            --this.remainingBurnTime;
        }
        if (this.activeFuel == FuelType.NORMAL) {
            this.updateBlockState();
        }
        if (this.remainingBurnTime > 0) {
            return;
        }
        if (this.activeFuel == FuelType.SPECIAL) {
            this.activeFuel = FuelType.NORMAL;
            this.remainingBurnTime = 5000;
        } else {
            this.activeFuel = FuelType.NONE;
        }
        this.updateBlockState();
    }

    private void tickRotation() {
        float target = 0.0f;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            double z;
            double x;
            if (this.isVirtual()) {
                x = -4.0;
                z = -10.0;
            } else {
                x = player.func_226277_ct_();
                z = player.func_226281_cx_();
            }
            double dx = x - ((double)this.func_174877_v().func_177958_n() + 0.5);
            double dz = z - ((double)this.func_174877_v().func_177952_p() + 0.5);
            target = AngleHelper.deg(-MathHelper.func_181159_b((double)dz, (double)dx)) - 90.0f;
        }
        target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff(this.headAngle.getValue(), target);
        this.headAngle.chase(target, 0.25, LerpedFloat.Chaser.exp(5.0));
        this.headAngle.tickChaser();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        if (!this.isCreative) {
            compound.func_74768_a("fuelLevel", this.activeFuel.ordinal());
            compound.func_74768_a("burnTimeRemaining", this.remainingBurnTime);
        } else {
            compound.func_74757_a("isCreative", true);
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.activeFuel = FuelType.values()[compound.func_74762_e("fuelLevel")];
        this.remainingBurnTime = compound.func_74762_e("burnTimeRemaining");
        this.isCreative = compound.func_74767_n("isCreative");
        super.fromTag(state, compound, clientPacket);
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBurnerBlock.getHeatLevelOf(this.func_195044_w());
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevelFromFuelType(this.activeFuel));
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState == heat) {
            return;
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)heat)));
        this.notifyUpdate();
    }

    protected boolean tryUpdateFuel(ItemStack itemStack, boolean forceOverflow, boolean simulate) {
        int newBurnTime;
        if (this.isCreative) {
            return false;
        }
        FuelType newFuel = FuelType.NONE;
        if (AllItems.BLAZE_CAKE.isIn(itemStack)) {
            newBurnTime = 1000;
            newFuel = FuelType.SPECIAL;
        } else {
            newBurnTime = ForgeHooks.getBurnTime((ItemStack)itemStack);
            if (newBurnTime > 0) {
                newFuel = FuelType.NORMAL;
            }
        }
        if (newFuel == FuelType.NONE) {
            return false;
        }
        if (newFuel.ordinal() < this.activeFuel.ordinal()) {
            return false;
        }
        if (this.activeFuel == FuelType.SPECIAL && this.remainingBurnTime > 20) {
            return false;
        }
        if (newFuel == this.activeFuel) {
            if (this.remainingBurnTime + newBurnTime > 10000 && !forceOverflow) {
                return false;
            }
            newBurnTime = MathHelper.func_76125_a((int)(this.remainingBurnTime + newBurnTime), (int)0, (int)10000);
        }
        if (simulate) {
            return true;
        }
        this.activeFuel = newFuel;
        this.remainingBurnTime = newBurnTime;
        if (this.field_145850_b.field_72995_K) {
            BlazeBurnerBlock.HeatLevel level = this.getHeatLevelFromFuelType(this.activeFuel);
            for (int i = 0; i < 20; ++i) {
                this.spawnParticles(level, 1.0 + 0.25 * (double)(i / 4));
            }
        } else {
            this.playSound();
            this.updateBlockState();
        }
        return true;
    }

    protected void applyCreativeFuel() {
        boolean wasCreative = this.isCreative;
        this.activeFuel = FuelType.NONE;
        this.remainingBurnTime = 0;
        this.isCreative = true;
        if (this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 30; ++i) {
                double burstMult = 1.0 + 0.25 * (double)(i / 4);
                this.spawnParticle(CREATIVE_PARTICLE_COLORS, 0.04f, 35, false, 0.03 * burstMult, 0.15 * burstMult);
            }
        } else {
            this.playSound();
            if (wasCreative) {
                this.setBlockHeat(this.getHeatLevelFromBlock().nextActiveLevel());
            }
        }
    }

    public boolean isCreativeFuel(ItemStack stack) {
        return AllItems.CREATIVE_BLAZE_CAKE.isIn(stack);
    }

    protected void playSound() {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187606_E, SoundCategory.BLOCKS, 0.125f + this.field_145850_b.field_73012_v.nextFloat() * 0.125f, 0.75f - this.field_145850_b.field_73012_v.nextFloat() * 0.25f);
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevelFromFuelType(FuelType fuel) {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        switch (this.activeFuel) {
            case SPECIAL: {
                level = BlazeBurnerBlock.HeatLevel.SEETHING;
                break;
            }
            case NORMAL: {
                boolean lowPercent = (double)this.remainingBurnTime / 10000.0 < 0.1;
                level = lowPercent ? BlazeBurnerBlock.HeatLevel.FADING : BlazeBurnerBlock.HeatLevel.KINDLED;
                break;
            }
        }
        return level;
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        if (this.field_145850_b == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        Random r = this.field_145850_b.func_201674_k();
        switch (heatLevel) {
            case SMOULDERING: {
                if (r.nextDouble() > 0.25) {
                    return;
                }
                this.spawnParticle(heatLevel, 0.03f, 15, false, 0.015 * burstMult, 0.1 * burstMult);
                break;
            }
            case FADING: {
                if (r.nextDouble() > 0.5) {
                    return;
                }
                this.spawnParticle(heatLevel, 0.035f, 18, false, 0.03 * burstMult, 0.15 * burstMult);
                break;
            }
            case KINDLED: {
                this.spawnParticle(heatLevel, 0.04f, 35, true, 0.05 * burstMult, 0.2 * burstMult);
                break;
            }
            case SEETHING: {
                for (int i = 0; i < 2; ++i) {
                    if (r.nextDouble() > 0.6) {
                        return;
                    }
                    this.spawnParticle(heatLevel, 0.045f, 35, true, 0.06 * burstMult, 0.22 * burstMult);
                }
                break;
            }
        }
    }

    protected void spawnParticle(Color color, float scale, int avgAge, boolean hot, double speed, double spread) {
        Random random = this.field_145850_b.func_201674_k();
        this.field_145850_b.func_195589_b((IParticleData)new CubeParticleData(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), scale, avgAge, hot), (double)this.field_174879_c.func_177958_n() + 0.5 + (random.nextDouble() * 2.0 - 1.0) * spread, (double)this.field_174879_c.func_177956_o() + 0.6 + random.nextDouble() / 4.0, (double)this.field_174879_c.func_177952_p() + 0.5 + (random.nextDouble() * 2.0 - 1.0) * spread, 0.0, speed, 0.0);
    }

    protected void spawnParticle(Color[] colors, float scale, int avgAge, boolean hot, double speed, double spread) {
        if (colors.length == 0) {
            return;
        }
        this.spawnParticle(colors[(int)(Math.random() * (double)colors.length)], scale, avgAge, hot, speed, spread);
    }

    protected void spawnParticle(BlazeBurnerBlock.HeatLevel heatLevel, float scale, int avgAge, boolean hot, double speed, double spread) {
        this.spawnParticle(PARTICLE_COLORS[heatLevel.ordinal()], scale, avgAge, hot, speed, spread);
    }

    public static enum FuelType {
        NONE,
        NORMAL,
        SPECIAL;

    }
}

