/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.recipe;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.mixer.MixingRecipe;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.utility.ISimpleReloadListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionMixingRecipeManager {
    public static Map<Item, List<MixingRecipe>> ALL = new HashMap<Item, List<MixingRecipe>>();
    public static final ISimpleReloadListener LISTENER = (resourceManager, profiler) -> {
        ALL.clear();
        PotionMixingRecipeManager.getAllBrewingRecipes().forEach(recipe -> {
            Iterator iterator = recipe.func_192400_c().iterator();
            while (iterator.hasNext()) {
                int n = 0;
                Ingredient ingredient = (Ingredient)iterator.next();
                ItemStack[] itemStackArray = ingredient.func_193365_a();
                int n2 = itemStackArray.length;
                if (n >= n2) continue;
                ItemStack itemStack = itemStackArray[n];
                ALL.computeIfAbsent(itemStack.func_77973_b(), t -> new ArrayList()).add(recipe);
                return;
            }
        });
    };

    public static List<MixingRecipe> getAllBrewingRecipes() {
        ArrayList<MixingRecipe> mixingRecipes = new ArrayList<MixingRecipe>();
        for (IBrewingRecipe iBrewingRecipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(iBrewingRecipe instanceof VanillaBrewingRecipe)) continue;
            ArrayList bottles = new ArrayList();
            PotionBrewing.field_185215_c.forEach(i -> {
                for (ItemStack itemStack : i.func_193365_a()) {
                    bottles.add(itemStack);
                }
            });
            Collection<ItemStack> reagents = PotionMixingRecipeManager.getAllReagents(iBrewingRecipe);
            HashSet<ItemStack> basicPotions = new HashSet<ItemStack>();
            for (Potion potion : ForgeRegistries.POTION_TYPES.getValues()) {
                if (potion == Potions.field_185229_a) continue;
                for (ItemStack stack : bottles) {
                    basicPotions.add(PotionUtils.func_185188_a((ItemStack)stack.func_77946_l(), (Potion)potion));
                }
            }
            HashSet<String> uniqueKeys = new HashSet<String>();
            ArrayList<Object> potionFrontier = new ArrayList<Object>();
            ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
            potionFrontier.addAll(basicPotions);
            int recipeIndex = 0;
            while (!potionFrontier.isEmpty()) {
                newPotions.clear();
                for (ItemStack itemStack : potionFrontier) {
                    Potion inputPotion = PotionUtils.func_185191_c((ItemStack)itemStack);
                    for (ItemStack potionReagent : reagents) {
                        Potion outputPotion;
                        String uniqueKey;
                        ItemStack outputPotionStack = iBrewingRecipe.getOutput(itemStack.func_77946_l(), potionReagent);
                        if (outputPotionStack.func_190926_b() || !uniqueKeys.add(uniqueKey = potionReagent.func_77973_b().getRegistryName().toString() + "_" + inputPotion.getRegistryName().toString() + "_" + itemStack.func_77973_b().getRegistryName().toString()) || itemStack.func_77973_b() == outputPotionStack.func_77973_b() && (outputPotion = PotionUtils.func_185191_c((ItemStack)outputPotionStack)) == Potions.field_185230_b) continue;
                        FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(itemStack);
                        FluidStack fluidFromPotionItem2 = PotionFluidHandler.getFluidFromPotionItem(outputPotionStack);
                        fluidFromPotionItem.setAmount(1000);
                        fluidFromPotionItem2.setAmount(1000);
                        MixingRecipe mixingRecipe = new ProcessingRecipeBuilder<MixingRecipe>(MixingRecipe::new, Create.asResource("potion_" + recipeIndex++)).require(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{potionReagent})).require(FluidIngredient.fromFluidStack(fluidFromPotionItem)).output(fluidFromPotionItem2).requiresHeat(HeatCondition.HEATED).build();
                        mixingRecipes.add(mixingRecipe);
                        newPotions.add(outputPotionStack);
                    }
                }
                potionFrontier.clear();
                potionFrontier.addAll(newPotions);
            }
            break block0;
        }
        return mixingRecipes;
    }

    public static Collection<ItemStack> getAllReagents(IBrewingRecipe recipe) {
        return ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(arg_0 -> ((IBrewingRecipe)recipe).isIngredient(arg_0)).collect(Collectors.toList());
    }
}

