/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.content.contraptions.relays.elementary.BracketedTileEntityBehaviour;
import com.simibubi.create.content.contraptions.wrench.IWrenchableWithBracket;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SixWayBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FluidPipeBlock
extends SixWayBlock
implements IWaterLoggable,
IWrenchableWithBracket {
    public FluidPipeBlock(AbstractBlock.Properties properties) {
        super(0.25f, properties);
        this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        if (this.tryRemoveBracket(context)) {
            return ActionResultType.SUCCESS;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction clickedFace = context.func_196000_l();
        Direction.Axis axis = this.getAxis((IBlockReader)world, pos, state);
        if (axis == null) {
            Vector3d clickLocation = context.func_221532_j().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            double closest = 3.4028234663852886E38;
            Direction argClosest = Direction.UP;
            for (Direction direction : Iterate.directions) {
                Vector3d centerOf;
                double distance;
                if (clickedFace.func_176740_k() == direction.func_176740_k() || !((distance = (centerOf = Vector3d.func_237489_a_((Vector3i)direction.func_176730_m())).func_72436_e(clickLocation)) < closest)) continue;
                closest = distance;
                argClosest = direction;
            }
            axis = argClosest.func_176740_k();
        }
        if (clickedFace.func_176740_k() == axis) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K) {
            FluidTransportBehaviour.cacheFlows((IWorld)world, pos);
            world.func_175656_a(pos, (BlockState)((BlockState)AllBlocks.GLASS_FLUID_PIPE.getDefaultState().func_206870_a((Property)GlassFluidPipeBlock.field_176298_M, (Comparable)axis)).func_206870_a((Property)BlockStateProperties.field_208198_y, state.func_177229_b((Property)BlockStateProperties.field_208198_y)));
            FluidTransportBehaviour.loadFlows((IWorld)world, pos);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!AllBlocks.COPPER_CASING.isIn(player.func_184586_b(hand))) {
            return ActionResultType.PASS;
        }
        AllTriggers.triggerFor(AllTriggers.CASING_PIPE, player);
        if (!world.field_72995_K) {
            FluidTransportBehaviour.cacheFlows((IWorld)world, pos);
            world.func_175656_a(pos, EncasedPipeBlock.transferSixWayProperties(state, AllBlocks.ENCASED_FLUID_PIPE.getDefaultState()));
            FluidTransportBehaviour.loadFlows((IWorld)world, pos);
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState getAxisState(Direction.Axis axis) {
        BlockState defaultState = this.func_176223_P();
        for (Direction d : Iterate.directions) {
            defaultState = (BlockState)defaultState.func_206870_a((Property)field_196491_B.get(d), (Comparable)Boolean.valueOf(d.func_176740_k() == axis));
        }
        return defaultState;
    }

    @Nullable
    private Direction.Axis getAxis(IBlockReader world, BlockPos pos, BlockState state) {
        return FluidPropagator.getStraightPipeAxis(state);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.FLUID_PIPE.create();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = state.func_177230_c() != newState.func_177230_c();
        if (blockTypeChanged && !world.field_72995_K) {
            FluidPropagator.propagateChangedPipe((IWorld)world, pos, state);
        }
        if (state != newState && !isMoving) {
            this.removeBracket((IBlockReader)world, pos, true).ifPresent(stack -> Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack));
        }
        if (state.hasTileEntity() && (blockTypeChanged || !newState.hasTileEntity())) {
            world.func_175713_t(pos);
        }
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        if (state != oldState) {
            world.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.HIGH);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        DebugPacketSender.func_218806_a((World)world, (BlockPos)pos);
        Direction d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null) {
            return;
        }
        if (!FluidPipeBlock.isOpenAt(state, d)) {
            return;
        }
        world.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.HIGH);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random r) {
        FluidPropagator.propagateChangedPipe((IWorld)world, pos, state);
    }

    public static boolean isPipe(BlockState state) {
        return state.func_177230_c() instanceof FluidPipeBlock;
    }

    public static boolean canConnectTo(IBlockDisplayReader world, BlockPos neighbourPos, BlockState neighbour, Direction direction) {
        if (FluidPropagator.hasFluidCapability((IBlockReader)world, neighbourPos, direction.func_176734_d())) {
            return true;
        }
        if (neighbour.func_235901_b_((Property)BlockStateProperties.field_227036_ao_)) {
            return true;
        }
        FluidTransportBehaviour transport = TileEntityBehaviour.get((IBlockReader)world, neighbourPos, FluidTransportBehaviour.TYPE);
        BracketedTileEntityBehaviour bracket = TileEntityBehaviour.get((IBlockReader)world, neighbourPos, BracketedTileEntityBehaviour.TYPE);
        if (FluidPipeBlock.isPipe(neighbour)) {
            return bracket == null || !bracket.isBracketPresent() || FluidPropagator.getStraightPipeAxis(neighbour) == direction.func_176740_k();
        }
        if (transport == null) {
            return false;
        }
        return transport.canHaveFlowToward(neighbour, direction.func_176734_d());
    }

    public static boolean shouldDrawRim(IBlockDisplayReader world, BlockPos pos, BlockState state, Direction direction) {
        BlockPos offsetPos = pos.func_177972_a(direction);
        BlockState facingState = world.func_180495_p(offsetPos);
        if (!FluidPipeBlock.isPipe(facingState)) {
            return true;
        }
        if (!FluidPipeBlock.canConnectTo(world, offsetPos, facingState, direction)) {
            return true;
        }
        if (!FluidPipeBlock.isCornerOrEndPipe(world, pos, state)) {
            return false;
        }
        if (FluidPropagator.getStraightPipeAxis(facingState) != null) {
            return true;
        }
        if (!FluidPipeBlock.shouldDrawCasing(world, pos, state) && FluidPipeBlock.shouldDrawCasing(world, offsetPos, facingState)) {
            return true;
        }
        if (FluidPipeBlock.isCornerOrEndPipe(world, offsetPos, facingState)) {
            return direction.func_176743_c() == Direction.AxisDirection.POSITIVE;
        }
        return true;
    }

    public static boolean isOpenAt(BlockState state, Direction direction) {
        return (Boolean)state.func_177229_b((Property)field_196491_B.get(direction));
    }

    public static boolean isCornerOrEndPipe(IBlockDisplayReader world, BlockPos pos, BlockState state) {
        return FluidPipeBlock.isPipe(state) && FluidPropagator.getStraightPipeAxis(state) == null && !FluidPipeBlock.shouldDrawCasing(world, pos, state);
    }

    public static boolean shouldDrawCasing(IBlockDisplayReader world, BlockPos pos, BlockState state) {
        if (!FluidPipeBlock.isPipe(state)) {
            return false;
        }
        for (Direction.Axis axis : Iterate.axes) {
            int connections = 0;
            for (Direction direction : Iterate.directions) {
                if (direction.func_176740_k() == axis || !FluidPipeBlock.isOpenAt(state, direction)) continue;
                ++connections;
            }
            if (connections <= 2) continue;
            return true;
        }
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_196488_a, field_196490_b, field_196492_c, field_196495_y, field_196496_z, field_196489_A, BlockStateProperties.field_208198_y});
        super.func_206840_a(builder);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState FluidState2 = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.updateBlockState(this.func_176223_P(), context.func_196010_d(), null, (IBlockDisplayReader)context.func_195991_k(), context.func_195995_a()).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(FluidState2.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighbourState, IWorld world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (FluidPipeBlock.isOpenAt(state, direction) && neighbourState.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
            world.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.HIGH);
        }
        return this.updateBlockState(state, direction, direction.func_176734_d(), (IBlockDisplayReader)world, pos);
    }

    public BlockState updateBlockState(BlockState state, Direction preferredDirection, @Nullable Direction ignore, IBlockDisplayReader world, BlockPos pos) {
        BracketedTileEntityBehaviour bracket = TileEntityBehaviour.get((IBlockReader)world, pos, BracketedTileEntityBehaviour.TYPE);
        if (bracket != null && bracket.isBracketPresent()) {
            return state;
        }
        BlockState prevState = state;
        int prevStateSides = (int)Arrays.stream(Iterate.directions).map(field_196491_B::get).filter(arg_0 -> ((BlockState)prevState).func_177229_b(arg_0)).count();
        for (Direction d : Iterate.directions) {
            if (d == ignore) continue;
            boolean shouldConnect = FluidPipeBlock.canConnectTo(world, pos.func_177972_a(d), world.func_180495_p(pos.func_177972_a(d)), d);
            state = (BlockState)state.func_206870_a((Property)field_196491_B.get(d), (Comparable)Boolean.valueOf(shouldConnect));
        }
        Direction connectedDirection = null;
        for (Direction d : Iterate.directions) {
            if (!FluidPipeBlock.isOpenAt(state, d)) continue;
            if (connectedDirection != null) {
                return state;
            }
            connectedDirection = d;
        }
        if (connectedDirection != null) {
            return (BlockState)state.func_206870_a((Property)field_196491_B.get(connectedDirection.func_176734_d()), (Comparable)Boolean.valueOf(true));
        }
        if (prevStateSides == 2) {
            return prevState;
        }
        return (BlockState)((BlockState)state.func_206870_a((Property)field_196491_B.get(preferredDirection), (Comparable)Boolean.valueOf(true))).func_206870_a((Property)field_196491_B.get(preferredDirection.func_176734_d()), (Comparable)Boolean.valueOf(true));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    @Override
    public Optional<ItemStack> removeBracket(IBlockReader world, BlockPos pos, boolean inOnReplacedContext) {
        BracketedTileEntityBehaviour behaviour = BracketedTileEntityBehaviour.get(world, pos, BracketedTileEntityBehaviour.TYPE);
        if (behaviour == null) {
            return Optional.empty();
        }
        BlockState bracket = behaviour.getBracket();
        behaviour.removeBracket(inOnReplacedContext);
        if (bracket == Blocks.field_150350_a.func_176223_P()) {
            return Optional.empty();
        }
        return Optional.of(new ItemStack((IItemProvider)bracket.func_177230_c()));
    }

    public boolean func_196266_a(BlockState state, IBlockReader reader, BlockPos pos, PathType type) {
        return false;
    }
}

