/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.waterwheel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.waterwheel.WaterWheelTileEntity;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BubbleColumnBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WaterWheelBlock
extends DirectionalKineticBlock
implements ITE<WaterWheelTileEntity> {
    public WaterWheelBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.WATER_WHEEL.create();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        for (Direction direction : Iterate.directions) {
            BlockPos neighbourPos = pos.func_177972_a(direction);
            BlockState neighbourState = worldIn.func_180495_p(neighbourPos);
            if (!AllBlocks.WATER_WHEEL.has(neighbourState) || ((Direction)neighbourState.func_177229_b((Property)FACING)).func_176740_k() == ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == direction.func_176740_k()) continue;
            return false;
        }
        return true;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (worldIn instanceof WrappedWorld) {
            return stateIn;
        }
        this.updateFlowAt(stateIn, worldIn, currentPos, facing);
        this.updateWheelSpeed(worldIn, currentPos);
        return stateIn;
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        this.updateAllSides(state, worldIn, pos);
    }

    public void updateAllSides(BlockState state, World worldIn, BlockPos pos) {
        for (Direction d : Iterate.directions) {
            this.updateFlowAt(state, (IWorld)worldIn, pos, d);
        }
        this.updateWheelSpeed((IWorld)worldIn, pos);
    }

    private void updateFlowAt(BlockState state, IWorld world, BlockPos pos, Direction side) {
        BlockState adjacentBlock;
        if (side.func_176740_k() == ((Direction)state.func_177229_b((Property)FACING)).func_176740_k()) {
            return;
        }
        FluidState fluid = world.func_204610_c(pos.func_177972_a(side));
        Direction wf = (Direction)state.func_177229_b((Property)FACING);
        boolean clockwise = wf.func_176743_c() == Direction.AxisDirection.POSITIVE;
        int clockwiseMultiplier = 2;
        Vector3d vec = fluid.func_215673_c((IBlockReader)world, pos.func_177972_a(side));
        if (side.func_176740_k().func_176722_c() && (adjacentBlock = world.func_180495_p(pos.func_177972_a(side))).func_177230_c() == Blocks.field_203203_C.getBlock()) {
            vec = new Vector3d(0.0, (Boolean)adjacentBlock.func_177229_b((Property)BubbleColumnBlock.field_203160_a) != false ? -1.0 : 1.0, 0.0);
        }
        vec = vec.func_186678_a((double)side.func_176743_c().func_179524_a());
        Vector3d flow = vec = new Vector3d(Math.signum(vec.field_72450_a), Math.signum(vec.field_72448_b), Math.signum(vec.field_72449_c));
        this.withTileEntityDo((IBlockReader)world, pos, te -> {
            double flowStrength = 0.0;
            if (wf.func_176740_k() == Direction.Axis.Z) {
                if (side.func_176740_k() == Direction.Axis.Y) {
                    double d = flowStrength = flow.field_72450_a > 0.0 ^ !clockwise ? -flow.field_72450_a * (double)clockwiseMultiplier : -flow.field_72450_a;
                }
                if (side.func_176740_k() == Direction.Axis.X) {
                    double d = flowStrength = flow.field_72448_b < 0.0 ^ !clockwise ? flow.field_72448_b * (double)clockwiseMultiplier : flow.field_72448_b;
                }
            }
            if (wf.func_176740_k() == Direction.Axis.X) {
                if (side.func_176740_k() == Direction.Axis.Y) {
                    double d = flowStrength = flow.field_72449_c < 0.0 ^ !clockwise ? flow.field_72449_c * (double)clockwiseMultiplier : flow.field_72449_c;
                }
                if (side.func_176740_k() == Direction.Axis.Z) {
                    double d = flowStrength = flow.field_72448_b > 0.0 ^ !clockwise ? -flow.field_72448_b * (double)clockwiseMultiplier : -flow.field_72448_b;
                }
            }
            if (wf.func_176740_k() == Direction.Axis.Y) {
                if (side.func_176740_k() == Direction.Axis.Z) {
                    double d = flowStrength = flow.field_72450_a < 0.0 ^ !clockwise ? flow.field_72450_a * (double)clockwiseMultiplier : flow.field_72450_a;
                }
                if (side.func_176740_k() == Direction.Axis.X) {
                    double d = flowStrength = flow.field_72449_c > 0.0 ^ !clockwise ? -flow.field_72449_c * (double)clockwiseMultiplier : -flow.field_72449_c;
                }
            }
            if (te.getSpeed() == 0.0f && flowStrength != 0.0 && !world.func_201670_d()) {
                AllTriggers.triggerForNearbyPlayers(AllTriggers.WATER_WHEEL, world, pos, 5);
                if (FluidHelper.isLava(fluid.func_206886_c())) {
                    AllTriggers.triggerForNearbyPlayers(AllTriggers.LAVA_WHEEL, world, pos, 5);
                }
                if (fluid.func_206886_c().func_207187_a((Fluid)AllFluids.CHOCOLATE.get())) {
                    AllTriggers.triggerForNearbyPlayers(AllTriggers.CHOCOLATE_WHEEL, world, pos, 5);
                }
            }
            Integer flowModifier = (Integer)AllConfigs.SERVER.kinetics.waterWheelFlowSpeed.get();
            te.setFlow(side, (float)(flowStrength * (double)flowModifier.intValue() / 2.0));
        });
    }

    private void updateWheelSpeed(IWorld world, BlockPos pos) {
        this.withTileEntityDo((IBlockReader)world, pos, GeneratingKineticTileEntity::updateGeneratedRotation);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean sneaking;
        Direction face = context.func_196000_l();
        Direction horizontalFacing = context.func_195992_f();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockState placedOn = world.func_180495_p(pos.func_177972_a(face.func_176734_d()));
        if (AllBlocks.WATER_WHEEL.has(placedOn)) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, placedOn.func_177229_b((Property)FACING));
        }
        Direction facing = face;
        boolean bl = sneaking = player != null && player.func_225608_bj_();
        if (player != null) {
            Vector3d lookVec = player.func_70040_Z();
            double tolerance = 0.985;
            facing = !this.func_196260_a((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.UP), (IWorldReader)world, pos) ? horizontalFacing : (Vector3d.func_237491_b_((Vector3i)Direction.DOWN.func_176730_m()).func_72430_b(lookVec.func_72432_b()) > tolerance ? Direction.DOWN : (Vector3d.func_237491_b_((Vector3i)Direction.UP.func_176730_m()).func_72430_b(lookVec.func_72432_b()) > tolerance ? Direction.UP : horizontalFacing));
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)(sneaking ? facing.func_176734_d() : facing));
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == face.func_176740_k();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.func_177229_b((Property)FACING)).func_176740_k();
    }

    @Override
    public float getParticleTargetRadius() {
        return 1.125f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 1.0f;
    }

    @Override
    public boolean hideStressImpact() {
        return true;
    }

    @Override
    public Class<WaterWheelTileEntity> getTileEntityClass() {
        return WaterWheelTileEntity.class;
    }
}

