/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraptionEntity;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftBlock;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class GantryCarriageTileEntity
extends KineticTileEntity
implements IDisplayAssemblyExceptions {
    boolean assembleNextTick;
    protected AssemblyException lastException;

    public GantryCarriageTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
    }

    public void checkValidGantryShaft() {
        if (this.shouldAssemble()) {
            this.queueAssembly();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.func_195044_w().func_196955_c((IWorldReader)this.field_145850_b, this.field_174879_c)) {
            this.field_145850_b.func_175655_b(this.field_174879_c, true);
        }
    }

    public void queueAssembly() {
        this.assembleNextTick = true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.assembleNextTick) {
            this.tryAssemble();
            this.assembleNextTick = false;
        }
    }

    @Override
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    private void tryAssemble() {
        Direction shaftOrientation;
        BlockState blockState = this.func_195044_w();
        if (!(blockState.func_177230_c() instanceof GantryCarriageBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.func_177229_b((Property)BlockStateProperties.field_208155_H);
        GantryContraption contraption = new GantryContraption(direction);
        TileEntity shaftTe = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction.func_176734_d()));
        if (!(shaftTe instanceof GantryShaftTileEntity)) {
            return;
        }
        BlockState shaftState = shaftTe.func_195044_w();
        if (!AllBlocks.GANTRY_SHAFT.has(shaftState)) {
            return;
        }
        float pinionMovementSpeed = ((GantryShaftTileEntity)shaftTe).getPinionMovementSpeed();
        Direction movementDirection = shaftOrientation = (Direction)shaftState.func_177229_b((Property)GantryShaftBlock.FACING);
        if (pinionMovementSpeed < 0.0f) {
            movementDirection = movementDirection.func_176734_d();
        }
        try {
            this.lastException = null;
            if (!contraption.assemble(this.field_145850_b, this.field_174879_c)) {
                return;
            }
            this.sendData();
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (ContraptionCollider.isCollidingWithWorld(this.field_145850_b, contraption, this.field_174879_c.func_177972_a(movementDirection), movementDirection)) {
            return;
        }
        contraption.removeBlocksFromWorld(this.field_145850_b, BlockPos.field_177992_a);
        GantryContraptionEntity movedContraption = GantryContraptionEntity.create(this.field_145850_b, contraption, shaftOrientation);
        BlockPos anchor = this.field_174879_c;
        movedContraption.func_70107_b(anchor.func_177958_n(), anchor.func_177956_o(), anchor.func_177952_p());
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.field_145850_b, this.field_174879_c);
        this.field_145850_b.func_217376_c((Entity)movedContraption);
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        AssemblyException.write(compound, this.lastException);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.lastException = AssemblyException.read(compound);
        super.fromTag(state, compound, clientPacket);
    }

    @Override
    public float propagateRotationTo(KineticTileEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        float defaultModifier = super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
        if (connectedViaAxes) {
            return defaultModifier;
        }
        if (!AllBlocks.GANTRY_SHAFT.has(stateTo)) {
            return defaultModifier;
        }
        if (!((Boolean)stateTo.func_177229_b((Property)GantryShaftBlock.POWERED)).booleanValue()) {
            return defaultModifier;
        }
        Direction direction = Direction.func_176737_a((float)diff.func_177958_n(), (float)diff.func_177956_o(), (float)diff.func_177952_p());
        if (stateFrom.func_177229_b((Property)GantryCarriageBlock.FACING) != direction.func_176734_d()) {
            return defaultModifier;
        }
        return GantryCarriageTileEntity.getGantryPinionModifier((Direction)stateTo.func_177229_b((Property)GantryShaftBlock.FACING), (Direction)stateFrom.func_177229_b((Property)GantryCarriageBlock.FACING));
    }

    public static float getGantryPinionModifier(Direction shaft, Direction pinionDirection) {
        Direction.Axis shaftAxis = shaft.func_176740_k();
        float directionModifier = shaft.func_176743_c().func_179524_a();
        if (shaftAxis == Direction.Axis.Y && (pinionDirection == Direction.NORTH || pinionDirection == Direction.EAST)) {
            return -directionModifier;
        }
        if (shaftAxis == Direction.Axis.X && (pinionDirection == Direction.DOWN || pinionDirection == Direction.SOUTH)) {
            return -directionModifier;
        }
        if (shaftAxis == Direction.Axis.Z && (pinionDirection == Direction.UP || pinionDirection == Direction.WEST)) {
            return -directionModifier;
        }
        return directionModifier;
    }

    private boolean shouldAssemble() {
        BlockState blockState = this.func_195044_w();
        if (!(blockState.func_177230_c() instanceof GantryCarriageBlock)) {
            return false;
        }
        Direction facing = ((Direction)blockState.func_177229_b((Property)GantryCarriageBlock.FACING)).func_176734_d();
        BlockState shaftState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing));
        if (!(shaftState.func_177230_c() instanceof GantryShaftBlock)) {
            return false;
        }
        if (((Boolean)shaftState.func_177229_b((Property)GantryShaftBlock.POWERED)).booleanValue()) {
            return false;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        return te instanceof GantryShaftTileEntity && ((GantryShaftTileEntity)te).canAssembleOn();
    }

    public boolean shouldRenderNormally() {
        return true;
    }
}

