/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.NonStationaryLighter;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StabilizedContraption
extends Contraption {
    private Direction facing;

    public StabilizedContraption() {
    }

    public StabilizedContraption(Direction facing) {
        this.facing = facing;
    }

    @Override
    public boolean assemble(World world, BlockPos pos) throws AssemblyException {
        BlockPos offset = pos.func_177972_a(this.facing);
        if (!this.searchMovedStructure(world, offset, null)) {
            return false;
        }
        this.startMoving(world);
        return !this.blocks.isEmpty();
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return false;
    }

    @Override
    protected ContraptionType getType() {
        return ContraptionType.STABILIZED;
    }

    @Override
    public CompoundNBT writeNBT(boolean spawnPacket) {
        CompoundNBT tag = super.writeNBT(spawnPacket);
        tag.func_74768_a("Facing", this.facing.func_176745_a());
        return tag;
    }

    @Override
    public void readNBT(World world, CompoundNBT tag, boolean spawnData) {
        this.facing = Direction.func_82600_a((int)tag.func_74762_e("Facing"));
        super.readNBT(world, tag, spawnData);
    }

    @Override
    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        return false;
    }

    public Direction getFacing() {
        return this.facing;
    }

    @Override
    public ContraptionLighter<?> makeLighter() {
        return new NonStationaryLighter<StabilizedContraption>(this);
    }
}

