/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceBlock;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceRenderer;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PortableStorageInterfaceMovement
extends MovementBehaviour {
    static final String _workingPos_ = "WorkingPos";
    static final String _clientPrevPos_ = "ClientPrevPos";

    @Override
    public Vector3d getActiveAreaOffset(MovementContext context) {
        return Vector3d.func_237491_b_((Vector3i)((Direction)context.state.func_177229_b((Property)PortableStorageInterfaceBlock.field_176387_N)).func_176730_m()).func_186678_a((double)1.85f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, PlacementSimulationWorld renderWorld, ContraptionMatrices matrices, IRenderTypeBuffer buffer) {
        PortableStorageInterfaceRenderer.renderInContraption(context, renderWorld, matrices, buffer);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        context.data.func_82580_o(_workingPos_);
        if (this.findInterface(context, pos)) {
            context.stall = true;
        }
    }

    protected boolean findInterface(MovementContext context, BlockPos pos) {
        Optional<Direction> currentFacingIfValid = this.getCurrentFacingIfValid(context);
        if (!currentFacingIfValid.isPresent()) {
            return false;
        }
        Direction currentFacing = currentFacingIfValid.get();
        PortableStorageInterfaceTileEntity psi = this.findStationaryInterface(context.world, pos, context.state, currentFacing);
        if (psi == null) {
            return false;
        }
        if ((psi.isTransferring() || psi.isPowered()) && !context.world.field_72995_K) {
            return false;
        }
        context.data.func_218657_a(_workingPos_, (INBT)NBTUtil.func_186859_a((BlockPos)psi.func_174877_v()));
        if (!context.world.field_72995_K) {
            Vector3d diff = VecHelper.getCenterOf((Vector3i)psi.func_174877_v()).func_178788_d(context.position);
            diff = VecHelper.project(diff, Vector3d.func_237491_b_((Vector3i)currentFacing.func_176730_m()));
            float distance = (float)(diff.func_72433_c() + (double)1.85f - 1.0);
            psi.startTransferringTo(context.contraption, distance);
        } else {
            context.data.func_218657_a(_clientPrevPos_, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        }
        return true;
    }

    @Override
    public void tick(MovementContext context) {
        if (context.world.field_72995_K) {
            boolean stalled = context.contraption.stalled;
            if (stalled && !context.data.func_74764_b(_workingPos_)) {
                BlockPos pos = new BlockPos(context.position);
                if (!context.data.func_74764_b(_clientPrevPos_) || !NBTUtil.func_186861_c((CompoundNBT)context.data.func_74775_l(_clientPrevPos_)).equals((Object)pos)) {
                    this.findInterface(context, pos);
                }
            }
            if (!stalled) {
                this.reset(context);
            }
            return;
        }
        if (!context.data.func_74764_b(_workingPos_)) {
            return;
        }
        BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)context.data.func_74775_l(_workingPos_));
        Optional<Direction> currentFacingIfValid = this.getCurrentFacingIfValid(context);
        if (!currentFacingIfValid.isPresent()) {
            return;
        }
        PortableStorageInterfaceTileEntity stationaryInterface = this.getStationaryInterfaceAt(context.world, pos, context.state, currentFacingIfValid.get());
        if (stationaryInterface == null || !stationaryInterface.isTransferring()) {
            this.reset(context);
            return;
        }
    }

    @Override
    public void stopMoving(MovementContext context) {
        this.reset(context);
    }

    public void reset(MovementContext context) {
        context.data.func_82580_o(_clientPrevPos_);
        context.data.func_82580_o(_workingPos_);
        context.stall = false;
    }

    private PortableStorageInterfaceTileEntity findStationaryInterface(World world, BlockPos pos, BlockState state, Direction facing) {
        for (int i = 0; i < 2; ++i) {
            PortableStorageInterfaceTileEntity interfaceAt = this.getStationaryInterfaceAt(world, pos.func_177967_a(facing, i), state, facing);
            if (interfaceAt == null) continue;
            return interfaceAt;
        }
        return null;
    }

    private PortableStorageInterfaceTileEntity getStationaryInterfaceAt(World world, BlockPos pos, BlockState state, Direction facing) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof PortableStorageInterfaceTileEntity)) {
            return null;
        }
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() != state.func_177230_c()) {
            return null;
        }
        if (blockState.func_177229_b((Property)PortableStorageInterfaceBlock.field_176387_N) != facing.func_176734_d()) {
            return null;
        }
        return (PortableStorageInterfaceTileEntity)te;
    }

    private Optional<Direction> getCurrentFacingIfValid(MovementContext context) {
        Direction facingFromVector;
        Vector3d directionVec = Vector3d.func_237491_b_((Vector3i)((Direction)context.state.func_177229_b((Property)PortableStorageInterfaceBlock.field_176387_N)).func_176730_m());
        if ((directionVec = (Vector3d)context.rotation.apply(directionVec)).func_72438_d(Vector3d.func_237491_b_((Vector3i)(facingFromVector = Direction.func_210769_a((double)directionVec.field_72450_a, (double)directionVec.field_72448_b, (double)directionVec.field_72449_c)).func_176730_m())) > 0.5) {
            return Optional.empty();
        }
        return Optional.of(facingFromVector);
    }
}

