/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldReader;

public interface IRotate
extends IWrenchable {
    public boolean hasShaftTowards(IWorldReader var1, BlockPos var2, BlockState var3, Direction var4);

    public Direction.Axis getRotationAxis(BlockState var1);

    default public SpeedLevel getMinimumRequiredSpeedLevel() {
        return SpeedLevel.NONE;
    }

    default public boolean hideStressImpact() {
        return false;
    }

    default public boolean showCapacityWithAnnotation() {
        return false;
    }

    public static enum StressImpact {
        LOW,
        MEDIUM,
        HIGH,
        OVERSTRESSED;


        public TextFormatting getAbsoluteColor() {
            return this == LOW ? TextFormatting.YELLOW : (this == MEDIUM ? TextFormatting.GOLD : TextFormatting.RED);
        }

        public TextFormatting getRelativeColor() {
            return this == LOW ? TextFormatting.GREEN : (this == MEDIUM ? TextFormatting.YELLOW : (this == HIGH ? TextFormatting.GOLD : TextFormatting.RED));
        }

        public static StressImpact of(double stressPercent) {
            if (stressPercent > 1.0) {
                return OVERSTRESSED;
            }
            if (stressPercent > 0.75) {
                return HIGH;
            }
            if (stressPercent > 0.5) {
                return MEDIUM;
            }
            return LOW;
        }

        public static boolean isEnabled() {
            return (Boolean)AllConfigs.SERVER.kinetics.disableStress.get() == false;
        }

        public static ITextComponent getFormattedStressText(double stressPercent) {
            StressImpact stressLevel = StressImpact.of(stressPercent);
            TextFormatting color = stressLevel.getRelativeColor();
            StringTextComponent level = new StringTextComponent(ItemDescription.makeProgressBar(3, Math.min(stressLevel.ordinal(), 2)));
            level.func_230529_a_((ITextComponent)Lang.translate("tooltip.stressImpact." + Lang.asId(stressLevel.name()), new Object[0]));
            level.func_240702_b_(String.format(" (%s%%) ", (int)(stressPercent * 100.0)));
            return level.func_240699_a_(color);
        }
    }

    public static enum SpeedLevel {
        NONE,
        MEDIUM,
        FAST;


        public TextFormatting getTextColor() {
            return this == NONE ? TextFormatting.GREEN : (this == MEDIUM ? TextFormatting.AQUA : TextFormatting.LIGHT_PURPLE);
        }

        public int getColor() {
            return this == NONE ? 0x22FF22 : (this == MEDIUM ? 34047 : 0xFF55FF);
        }

        public int getParticleSpeed() {
            return this == NONE ? 10 : (this == MEDIUM ? 20 : 30);
        }

        public static SpeedLevel of(float speed) {
            if ((double)(speed = Math.abs(speed)) >= (Double)AllConfigs.SERVER.kinetics.fastSpeed.get()) {
                return FAST;
            }
            if ((double)speed >= (Double)AllConfigs.SERVER.kinetics.mediumSpeed.get()) {
                return MEDIUM;
            }
            return NONE;
        }

        public float getSpeedValue() {
            switch (this) {
                case FAST: {
                    return ((Double)AllConfigs.SERVER.kinetics.fastSpeed.get()).floatValue();
                }
                case MEDIUM: {
                    return ((Double)AllConfigs.SERVER.kinetics.mediumSpeed.get()).floatValue();
                }
            }
            return 0.0f;
        }

        public static ITextComponent getFormattedSpeedText(float speed, boolean overstressed) {
            SpeedLevel speedLevel = SpeedLevel.of(speed);
            StringTextComponent level = new StringTextComponent(ItemDescription.makeProgressBar(3, speedLevel.ordinal()));
            if (speedLevel == MEDIUM) {
                level.func_230529_a_((ITextComponent)Lang.translate("tooltip.speedRequirement.medium", new Object[0]));
            }
            if (speedLevel == FAST) {
                level.func_230529_a_((ITextComponent)Lang.translate("tooltip.speedRequirement.high", new Object[0]));
            }
            level.func_240702_b_(" (" + IHaveGoggleInformation.format(Math.abs(speed))).func_230529_a_((ITextComponent)Lang.translate("generic.unit.rpm", new Object[0])).func_240702_b_(") ");
            if (overstressed) {
                level.func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.STRIKETHROUGH});
            } else {
                level.func_240699_a_(speedLevel.getTextColor());
            }
            return level;
        }
    }
}

