/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.anvil;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AnvilRecipeMaker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ItemStack ENCHANTED_BOOK = new ItemStack((IItemProvider)Items.field_151134_bR);

    private AnvilRecipeMaker() {
    }

    public static List<Object> getAnvilRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        Stopwatch sw = Stopwatch.createStarted();
        try {
            AnvilRecipeMaker.getRepairRecipes(recipes, vanillaRecipeFactory);
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to create repair recipes.", (Throwable)e);
        }
        sw.stop();
        LOGGER.debug("Registered vanilla repair recipes in {}", (Object)sw);
        sw.reset();
        sw.start();
        try {
            AnvilRecipeMaker.getBookEnchantmentRecipes(recipes, vanillaRecipeFactory, ingredientManager);
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to create enchantment recipes.", (Throwable)e);
        }
        sw.stop();
        LOGGER.debug("Registered enchantment recipes in {}", (Object)sw);
        return recipes;
    }

    private static void getBookEnchantmentRecipes(List<Object> recipes, IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        Collection<ItemStack> ingredients = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
        Collection enchantments = ForgeRegistries.ENCHANTMENTS.getValues();
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.func_77956_u()) continue;
            for (Enchantment enchantment : enchantments) {
                if (!enchantment.func_92089_a(ingredient)) continue;
                try {
                    AnvilRecipeMaker.getBookEnchantmentRecipes(recipes, vanillaRecipeFactory, enchantment, ingredient);
                }
                catch (RuntimeException e) {
                    String ingredientInfo = ErrorUtil.getIngredientInfo(ingredient);
                    LOGGER.error("Failed to register book enchantment recipes for ingredient: {}", (Object)ingredientInfo, (Object)e);
                }
            }
        }
    }

    private static void getBookEnchantmentRecipes(List<Object> recipes, IVanillaRecipeFactory vanillaRecipeFactory, Enchantment enchantment, ItemStack ingredient) {
        Item item = ingredient.func_77973_b();
        ArrayList perLevelBooks = Lists.newArrayList();
        ArrayList perLevelOutputs = Lists.newArrayList();
        for (int level = 1; level <= enchantment.func_77325_b(); ++level) {
            Map<Enchantment, Integer> enchMap = Collections.singletonMap(enchantment, level);
            ItemStack bookEnchant = ENCHANTED_BOOK.func_77946_l();
            EnchantmentHelper.func_82782_a(enchMap, (ItemStack)bookEnchant);
            if (!item.isBookEnchantable(ingredient, bookEnchant)) continue;
            perLevelBooks.add(bookEnchant);
            ItemStack withEnchant = ingredient.func_77946_l();
            EnchantmentHelper.func_82782_a(enchMap, (ItemStack)withEnchant);
            perLevelOutputs.add(withEnchant);
        }
        if (!perLevelBooks.isEmpty() && !perLevelOutputs.isEmpty()) {
            Object anvilRecipe = vanillaRecipeFactory.createAnvilRecipe(ingredient, (List<ItemStack>)perLevelBooks, (List<ItemStack>)perLevelOutputs);
            recipes.add(anvilRecipe);
        }
    }

    private static void getRepairRecipes(List<Object> recipes, IVanillaRecipeFactory vanillaRecipeFactory) {
        HashMap items = Maps.newHashMap();
        Ingredient repairWoods = ItemTier.WOOD.func_200924_f();
        items.put(repairWoods, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151041_m), new ItemStack((IItemProvider)Items.field_151039_o), new ItemStack((IItemProvider)Items.field_151053_p), new ItemStack((IItemProvider)Items.field_151038_n), new ItemStack((IItemProvider)Items.field_151017_I)}));
        Ingredient repairShields = Ingredient.func_199805_a((ITag)ItemTags.field_199905_b);
        items.put(repairShields, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_185159_cQ)}));
        items.put(ItemTier.STONE.func_200924_f(), Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151052_q), new ItemStack((IItemProvider)Items.field_151050_s), new ItemStack((IItemProvider)Items.field_151049_t), new ItemStack((IItemProvider)Items.field_151051_r), new ItemStack((IItemProvider)Items.field_151018_J)}));
        Ingredient repairLeather = ArmorMaterial.LEATHER.func_200898_c();
        items.put(repairLeather, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151024_Q), new ItemStack((IItemProvider)Items.field_151027_R), new ItemStack((IItemProvider)Items.field_151026_S), new ItemStack((IItemProvider)Items.field_151021_T)}));
        Ingredient repairIronItems = ItemTier.IRON.func_200924_f();
        items.put(repairIronItems, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151040_l), new ItemStack((IItemProvider)Items.field_151035_b), new ItemStack((IItemProvider)Items.field_151036_c), new ItemStack((IItemProvider)Items.field_151037_a), new ItemStack((IItemProvider)Items.field_151019_K)}));
        Ingredient repairIronArmor = ArmorMaterial.IRON.func_200898_c();
        items.put(repairIronArmor, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151028_Y), new ItemStack((IItemProvider)Items.field_151030_Z), new ItemStack((IItemProvider)Items.field_151165_aa), new ItemStack((IItemProvider)Items.field_151167_ab)}));
        Ingredient repairChain = ArmorMaterial.CHAIN.func_200898_c();
        items.put(repairChain, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151020_U), new ItemStack((IItemProvider)Items.field_151023_V), new ItemStack((IItemProvider)Items.field_151022_W), new ItemStack((IItemProvider)Items.field_151029_X)}));
        Ingredient repairGoldItems = ItemTier.GOLD.func_200924_f();
        items.put(repairGoldItems, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151010_B), new ItemStack((IItemProvider)Items.field_151005_D), new ItemStack((IItemProvider)Items.field_151006_E), new ItemStack((IItemProvider)Items.field_151011_C), new ItemStack((IItemProvider)Items.field_151013_M)}));
        Ingredient repairGoldArmor = ArmorMaterial.GOLD.func_200898_c();
        items.put(repairGoldArmor, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151169_ag), new ItemStack((IItemProvider)Items.field_151171_ah), new ItemStack((IItemProvider)Items.field_151149_ai), new ItemStack((IItemProvider)Items.field_151151_aj)}));
        Ingredient repairDiamondItems = ItemTier.DIAMOND.func_200924_f();
        items.put(repairDiamondItems, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151048_u), new ItemStack((IItemProvider)Items.field_151046_w), new ItemStack((IItemProvider)Items.field_151056_x), new ItemStack((IItemProvider)Items.field_151047_v), new ItemStack((IItemProvider)Items.field_151012_L)}));
        Ingredient repairDiamondArmor = ArmorMaterial.DIAMOND.func_200898_c();
        items.put(repairDiamondArmor, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151161_ac), new ItemStack((IItemProvider)Items.field_151163_ad), new ItemStack((IItemProvider)Items.field_151173_ae), new ItemStack((IItemProvider)Items.field_151175_af)}));
        Ingredient repairNetheriteItems = ItemTier.NETHERITE.func_200924_f();
        items.put(repairNetheriteItems, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_234754_kI_), new ItemStack((IItemProvider)Items.field_234757_kL_), new ItemStack((IItemProvider)Items.field_234758_kU_), new ItemStack((IItemProvider)Items.field_234755_kJ_), new ItemStack((IItemProvider)Items.field_234756_kK_)}));
        Ingredient repairNetheriteArmor = ArmorMaterial.NETHERITE.func_200898_c();
        items.put(repairNetheriteArmor, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_234766_lv_), new ItemStack((IItemProvider)Items.field_234763_ls_), new ItemStack((IItemProvider)Items.field_234765_lu_), new ItemStack((IItemProvider)Items.field_234764_lt_)}));
        Ingredient repairElytra = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_204840_eX});
        items.put(repairElytra, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_185160_cR)}));
        Ingredient repairTurtle = ArmorMaterial.TURTLE.func_200898_c();
        items.put(repairTurtle, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_203179_ao)}));
        for (Map.Entry entry : items.entrySet()) {
            ArrayList repairMaterials = Lists.newArrayList((Object[])((Ingredient)entry.getKey()).func_193365_a());
            for (ItemStack ingredient : (List)entry.getValue()) {
                ItemStack damaged1 = ingredient.func_77946_l();
                damaged1.func_196085_b(damaged1.func_77958_k());
                ItemStack damaged2 = ingredient.func_77946_l();
                damaged2.func_196085_b(damaged2.func_77958_k() * 3 / 4);
                ItemStack damaged3 = ingredient.func_77946_l();
                damaged3.func_196085_b(damaged3.func_77958_k() * 2 / 4);
                if (!repairMaterials.isEmpty()) {
                    Object repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(damaged1, (List<ItemStack>)repairMaterials, Collections.singletonList(damaged2));
                    recipes.add(repairWithMaterial);
                }
                Object repairWithSame = vanillaRecipeFactory.createAnvilRecipe(damaged2, Collections.singletonList(damaged2), Collections.singletonList(damaged3));
                recipes.add(repairWithSame);
            }
        }
    }

    public static int findLevelsCost(ItemStack leftStack, ItemStack rightStack) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return -1;
        }
        PlayerInventory fakeInventory = new PlayerInventory((PlayerEntity)player);
        try {
            RepairContainer repair = new RepairContainer(0, fakeInventory);
            ((Slot)repair.field_75151_b.get(0)).func_75215_d(leftStack);
            ((Slot)repair.field_75151_b.get(1)).func_75215_d(rightStack);
            return repair.func_216976_f();
        }
        catch (RuntimeException e) {
            String left = ErrorUtil.getItemStackInfo(leftStack);
            String right = ErrorUtil.getItemStackInfo(rightStack);
            LOGGER.error("Could not get anvil level cost for: ({} and {}).", (Object)left, (Object)right, (Object)e);
            return -1;
        }
    }
}

