/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Util;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.world.IslandPos;

public class SkyblockSavedData
extends WorldSavedData {
    private static final String NAME = "gog_skyblock_islands";
    private static final int OFFSET = 1;
    public BiMap<IslandPos, UUID> skyblocks = HashBiMap.create();
    private Spiral spiral = new Spiral();

    public SkyblockSavedData() {
        super(NAME);
    }

    public static SkyblockSavedData get(ServerWorld world) {
        return (SkyblockSavedData)world.func_217481_x().func_215752_a(SkyblockSavedData::new, NAME);
    }

    public IslandPos getSpawn() {
        if (this.skyblocks.containsValue((Object)Util.field_240973_b_)) {
            return (IslandPos)this.skyblocks.inverse().get((Object)Util.field_240973_b_);
        }
        IslandPos pos = new IslandPos(1, 1);
        this.skyblocks.put((Object)pos, (Object)Util.field_240973_b_);
        this.func_76185_a();
        return pos;
    }

    public IslandPos create(UUID playerId) {
        int[] pos;
        IslandPos islandPos;
        int scale = (Integer)ConfigHandler.COMMON.gogIslandScaleMultiplier.get();
        while (this.skyblocks.containsKey((Object)(islandPos = new IslandPos((pos = this.spiral.next())[0] * scale + 1, pos[1] * scale + 1)))) {
        }
        this.skyblocks.put((Object)islandPos, (Object)playerId);
        this.func_76185_a();
        return islandPos;
    }

    public void func_76184_a(CompoundNBT nbt) {
        HashBiMap map = HashBiMap.create();
        for (INBT inbt : nbt.func_150295_c("Islands", 10)) {
            CompoundNBT tag = (CompoundNBT)inbt;
            map.put((Object)IslandPos.fromTag(tag), (Object)tag.func_186857_a("Player"));
        }
        this.skyblocks = map;
        this.spiral = Spiral.fromArray(nbt.func_74759_k("SpiralState"));
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        for (Map.Entry entry : this.skyblocks.entrySet()) {
            CompoundNBT entryTag = ((IslandPos)entry.getKey()).toTag();
            entryTag.func_186854_a("Player", (UUID)entry.getValue());
            list.add((Object)entryTag);
        }
        nbt.func_74783_a("SpiralState", this.spiral.toIntArray());
        nbt.func_218657_a("Islands", (INBT)list);
        return nbt;
    }

    private static class Spiral {
        private int x = 0;
        private int y = 0;
        private int dx = 0;
        private int dy = -1;

        Spiral() {
        }

        Spiral(int x, int y, int dx, int dy) {
            this.x = x;
            this.y = y;
            this.dx = dx;
            this.dy = dy;
        }

        int[] next() {
            if (this.x == this.y || this.x < 0 && this.x == -this.y || this.x > 0 && this.x == 1 - this.y) {
                int t = this.dx;
                this.dx = -this.dy;
                this.dy = t;
            }
            this.x += this.dx;
            this.y += this.dy;
            return new int[]{this.x, this.y};
        }

        int[] toIntArray() {
            return new int[]{this.x, this.y, this.dx, this.dy};
        }

        static Spiral fromArray(int[] ints) {
            return new Spiral(ints[0], ints[1], ints[2], ints[3]);
        }
    }
}

