/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemRelicBauble;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ItemOdinRing
extends ItemRelicBauble {
    private static final Set<String> damageNegations = new HashSet<String>();

    public ItemOdinRing(Item.Properties props) {
        super(props);
        damageNegations.add(DamageSource.field_76369_e.field_76373_n);
        damageNegations.add(DamageSource.field_76379_h.field_76373_n);
        damageNegations.add(DamageSource.field_76371_c.field_76373_n);
        damageNegations.add(DamageSource.field_76368_d.field_76373_n);
        damageNegations.add(DamageSource.field_76366_f.field_76373_n);
        damageNegations.add(DamageSource.field_76372_a.field_76373_n);
        damageNegations.add(DamageSource.field_76370_b.field_76373_n);
        damageNegations.add(DamageSource.field_190095_e.field_76373_n);
        damageNegations.add(DamageSource.field_188406_j.field_76373_n);
    }

    @Override
    public void onValidPlayerWornTick(PlayerEntity player) {
        if (player.func_70027_ad()) {
            player.func_70066_B();
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getEquippedAttributeModifiers(ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(ItemOdinRing.getBaubleUUID(stack), "Odin Ring", 20.0, AttributeModifier.Operation.ADDITION));
        return attributes;
    }

    public static void onPlayerAttacked(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (damageNegations.contains(event.getSource().field_76373_n) && !EquipmentHandler.findOrEmpty(ModItems.odinRing, (LivingEntity)player).func_190926_b()) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public ResourceLocation getAdvancement() {
        return ResourceLocationHelper.prefix("challenge/odin_ring");
    }
}

