/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker.actions;

import com.blamejared.crafttweaker.api.exceptions.ScriptException;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.registry.Registry;
import vazkii.botania.api.recipe.IElvenTradeRecipe;

public class ActionRemoveElvenTradeRecipe
extends ActionRecipeBase {
    private final IItemStack[] outputs;

    public ActionRemoveElvenTradeRecipe(IRecipeManager manager, IItemStack[] outputs) {
        super(manager);
        this.outputs = outputs;
    }

    public void apply() {
        Iterator iter = this.getManager().getRecipes().entrySet().iterator();
        while (iter.hasNext()) {
            IElvenTradeRecipe recipe = (IElvenTradeRecipe)iter.next().getValue();
            if (recipe.getOutputs().size() != this.outputs.length) continue;
            List collected = recipe.getOutputs().stream().map(MCItemStackMutable::new).collect(Collectors.toList());
            boolean valid = true;
            for (int i = 0; i < this.outputs.length; ++i) {
                if (this.outputs[i].matches((IItemStack)collected.get(i))) continue;
                valid = false;
            }
            if (!valid) continue;
            iter.remove();
        }
    }

    public String describe() {
        return "Removing \"" + Registry.field_218367_H.func_177774_c((Object)this.getManager().getRecipeType()) + "\" recipes with output: " + Arrays.toString(this.outputs) + "\"";
    }

    public boolean validate(ILogger logger) {
        if (this.outputs == null) {
            logger.throwingWarn("output cannot be null!", (Throwable)new ScriptException("output MCBlockState cannot be null!"));
            return false;
        }
        return true;
    }
}

