/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl_native.blocks.ExpandBlockState;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipePureDaisy;
import vazkii.botania.common.integration.crafttweaker.CTIntegration;
import vazkii.botania.common.integration.crafttweaker.actions.ActionRemovePureDaisyRecipe;

@Document(value="mods/Botania/PureDaisy")
@ZenRegister
@IRecipeHandler.For(value=RecipePureDaisy.class)
@ZenCodeType.Name(value="mods.botania.PureDaisy")
public class PureDaisyRecipeManager
implements IRecipeManager,
IRecipeHandler<RecipePureDaisy> {
    @ZenCodeType.Method
    public void addRecipe(String name, BlockState output, StateIngredient input, @ZenCodeType.OptionalInt(value=150) int time) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)new RecipePureDaisy(resourceLocation, input, output, time), ""));
    }

    @ZenCodeType.Method
    public void removeRecipe(BlockState state) {
        CraftTweakerAPI.apply((IAction)new ActionRemovePureDaisyRecipe(this, state));
    }

    public void removeRecipe(IItemStack output) {
        throw new UnsupportedOperationException("The Pure Daisy does not output IItemStacks, use removeRecipeByBlock(BlockState)!");
    }

    public void removeRecipe(IIngredient output) {
        throw new UnsupportedOperationException("The Pure Daisy does not output IItemStacks, use removeRecipeByBlock(BlockState)!");
    }

    public IRecipeType<IPureDaisyRecipe> getRecipeType() {
        return ModRecipeTypes.PURE_DAISY_TYPE;
    }

    public String dumpToCommandString(IRecipeManager manager, RecipePureDaisy recipe) {
        StringJoiner s = new StringJoiner(", ", manager.getCommandString() + ".addRecipe(", ");");
        s.add(StringUtils.quoteAndEscape((ResourceLocation)recipe.func_199560_c()));
        s.add(ExpandBlockState.getCommandString((BlockState)recipe.getOutputState()));
        s.add(CTIntegration.ingredientToCommandString(recipe.getInput()));
        if (recipe.getTime() != 150) {
            s.add(String.valueOf(recipe.getTime()));
        }
        return s.toString();
    }

    public Optional<Function<ResourceLocation, RecipePureDaisy>> replaceIngredients(IRecipeManager manager, RecipePureDaisy recipe, List<IReplacementRule> rules) {
        return Optional.empty();
    }
}

