/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeManaInfusion;
import vazkii.botania.common.integration.crafttweaker.CTIntegration;

@Document(value="mods/Botania/ManaInfusion")
@ZenRegister
@IRecipeHandler.For(value=RecipeManaInfusion.class)
@ZenCodeType.Name(value="mods.botania.ManaInfusion")
public class ManaInfusionRecipeManager
implements IRecipeManager,
IRecipeHandler<RecipeManaInfusion> {
    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, IIngredient input, int mana, @ZenCodeType.Optional StateIngredient catalyst, @ZenCodeType.OptionalString String group, @ZenCodeType.Optional IRecipeManager.RecipeFunctionSingle function) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        if (group == null) {
            group = "";
        }
        RecipeManaInfusion recipe = function == null ? new RecipeManaInfusion(resourceLocation, output.getInternal(), input.asVanillaIngredient(), mana, group, catalyst) : new InfusionWithFunction(resourceLocation, output.getInternal(), input.asVanillaIngredient(), mana, group, catalyst, function);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe, ""));
    }

    public IRecipeType<IManaInfusionRecipe> getRecipeType() {
        return ModRecipeTypes.MANA_INFUSION_TYPE;
    }

    public String dumpToCommandString(IRecipeManager manager, RecipeManaInfusion recipe) {
        ArrayList<String> s = new ArrayList<String>();
        s.add(StringUtils.quoteAndEscape((ResourceLocation)recipe.func_199560_c()));
        s.add(new MCItemStackMutable(recipe.func_77571_b()).getCommandString());
        IIngredient input = IIngredient.fromIngredient((Ingredient)((Ingredient)recipe.func_192400_c().get(0)));
        s.add(input.getCommandString());
        s.add(String.valueOf(recipe.getManaToConsume()));
        s.add(recipe.getRecipeCatalyst() != null ? CTIntegration.ingredientToCommandString(recipe.getRecipeCatalyst()) : null);
        s.add(!recipe.func_193358_e().equals("") ? recipe.func_193358_e() : null);
        if (recipe instanceof InfusionWithFunction) {
            s.add("(usualOut, input) => { ... }");
        }
        ListIterator iterator = s.listIterator(s.size());
        while (iterator.hasPrevious() && iterator.previous() == null) {
            iterator.remove();
        }
        return s.stream().collect(Collectors.joining(", ", manager.getCommandString() + ".addRecipe(", ");"));
    }

    public Optional<Function<ResourceLocation, RecipeManaInfusion>> replaceIngredients(IRecipeManager manager, RecipeManaInfusion recipe, List<IReplacementRule> rules) {
        return IRecipeHandler.attemptReplacing((Object)recipe.func_192400_c().get(0), Ingredient.class, (IRecipe)recipe, rules).map(ingr -> {
            if (recipe instanceof InfusionWithFunction) {
                return id -> new InfusionWithFunction((ResourceLocation)id, recipe.func_77571_b(), (Ingredient)ingr, recipe.getManaToConsume(), recipe.func_193358_e(), recipe.getRecipeCatalyst(), ((InfusionWithFunction)recipe).getFunction());
            }
            return id -> new RecipeManaInfusion((ResourceLocation)id, recipe.func_77571_b(), (Ingredient)ingr, recipe.getManaToConsume(), recipe.func_193358_e(), recipe.getRecipeCatalyst());
        });
    }

    private static class InfusionWithFunction
    extends RecipeManaInfusion {
        private final IRecipeManager.RecipeFunctionSingle function;

        public InfusionWithFunction(ResourceLocation resourceLocation, ItemStack internal, Ingredient input1, int mana, String group, StateIngredient catalyst, IRecipeManager.RecipeFunctionSingle function) {
            super(resourceLocation, internal, input1, mana, group, catalyst);
            this.function = function;
        }

        @Override
        @Nonnull
        public ItemStack getRecipeOutput(@Nonnull ItemStack input) {
            return this.function.process((IItemStack)new MCItemStack(this.func_77571_b()), (IItemStack)new MCItemStack(input)).getInternal().func_77946_l();
        }

        private IRecipeManager.RecipeFunctionSingle getFunction() {
            return this.function;
        }
    }
}

