/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.corporea;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaNodeDetector;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.impl.corporea.DummyCorporeaNode;
import vazkii.botania.common.integration.corporea.ForgeCapNodeDetector;
import vazkii.botania.common.integration.corporea.VanillaNodeDetector;

public class CorporeaNodeDetectors {
    private static final Deque<ICorporeaNodeDetector> DETECTORS = (Deque)Util.func_200696_a(new ArrayDeque(), d -> {
        d.addLast(new ForgeCapNodeDetector());
        d.addLast(new VanillaNodeDetector());
    });

    public static synchronized void register(ICorporeaNodeDetector detector) {
        DETECTORS.addFirst(detector);
    }

    public static ICorporeaNode findNode(World world, ICorporeaSpark spark) {
        for (ICorporeaNodeDetector detector : DETECTORS) {
            ICorporeaNode node = detector.getNode(world, spark);
            if (node == null) continue;
            return node;
        }
        return new DummyCorporeaNode(world, spark.getAttachPos(), spark);
    }
}

